/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.mffs.common.multitool;

import com.nekokittygames.mffs.api.IForceEnergyItems;
import com.nekokittygames.mffs.common.ForceEnergyItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class ItemMultitool
extends ForceEnergyItems
implements IForceEnergyItems {
    private int typ;
    private static List<ItemMultitool> MTTypes = new ArrayList<ItemMultitool>();

    protected ItemMultitool(int typ, boolean addToList) {
        this.typ = typ;
        this.func_77625_d(1);
        this.func_77656_e(100);
        this.func_77627_a(true);
        if (addToList) {
            MTTypes.add(this);
        }
    }

    protected ItemMultitool(int typ) {
        this(typ, true);
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean func_77645_m() {
        return true;
    }

    public abstract EnumActionResult onItemUseFirst(ItemStack var1, EntityPlayer var2, World var3, BlockPos var4, EnumFacing var5, float var6, float var7, float var8, EnumHand var9);

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (playerIn.func_70093_af()) {
            int modeNum = 0;
            for (int i = 0; i < MTTypes.size(); ++i) {
                ItemMultitool MT = MTTypes.get(i);
                if (!MT.getRegistryName().equals((Object)itemStackIn.func_77973_b().getRegistryName())) continue;
                modeNum = i + 1 < MTTypes.size() ? i + 1 : 0;
            }
            int powerleft = this.getAvailablePower(itemStackIn);
            ItemStack inHand = playerIn.field_71071_by.func_70448_g();
            inHand = new ItemStack((Item)MTTypes.get(modeNum), 1);
            this.chargeItem(inHand, powerleft, false);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)inHand);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)itemStackIn);
    }

    public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        par1ItemStack.func_77964_b(this.getItemDamage(par1ItemStack));
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List info, boolean b) {
        String tooltip = String.format("%d FE/%d FE ", this.getAvailablePower(itemStack), this.getMaximumPower(itemStack));
        info.add(tooltip);
    }

    @Override
    public int getPowerTransferrate() {
        return 50000;
    }

    @Override
    public int getMaximumPower(ItemStack itemStack) {
        return 1000000;
    }

    @Override
    public int getItemDamage(ItemStack itemStack) {
        return 101 - this.getAvailablePower(itemStack) * 100 / this.getMaximumPower(itemStack);
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        super.func_150895_a(itemIn, tab, subItems);
        ItemStack charged = new ItemStack((Item)this, 1);
        charged.func_77964_b(1);
        this.setAvailablePower(charged, this.getMaximumPower(null));
        subItems.add(charged);
    }
}

