/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.mffs.common.block;

import com.nekokittygames.mffs.common.ModularForceFieldSystem;
import com.nekokittygames.mffs.common.SecurityHelper;
import com.nekokittygames.mffs.common.SecurityRight;
import com.nekokittygames.mffs.common.item.ItemCardEmpty;
import com.nekokittygames.mffs.common.item.ItemCardPowerLink;
import com.nekokittygames.mffs.common.item.ItemCardSecurityLink;
import com.nekokittygames.mffs.common.modules.ModuleBase;
import com.nekokittygames.mffs.common.multitool.ItemMultitool;
import com.nekokittygames.mffs.common.tileentity.TileEntityAdvSecurityStation;
import com.nekokittygames.mffs.common.tileentity.TileEntityControlSystem;
import com.nekokittygames.mffs.common.tileentity.TileEntityMachines;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockMFFSBase
extends Block
implements ITileEntityProvider {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");

    public BlockMFFSBase() {
        super(Material.field_151573_f);
        this.func_149722_s();
        this.func_149752_b(100.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149647_a(ModularForceFieldSystem.MFFSTab);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ACTIVE});
    }

    public int func_176201_c(IBlockState state) {
        Byte b0 = 0;
        int i = b0 | ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
        return i |= ((Boolean)state.func_177229_b((IProperty)ACTIVE) != false ? 0 : 1) << 3;
    }

    public IBlockState func_176203_a(int meta) {
        int x = meta & 8;
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)BlockPistonBase.func_176317_b((int)meta)).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(x > 0));
    }

    public abstract TileEntity func_149915_a(World var1, int var2);

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entityplayer, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        Item equipped;
        if (entityplayer.func_70093_af()) {
            return false;
        }
        if (world.field_72995_K) {
            return true;
        }
        TileEntityMachines tileentity = (TileEntityMachines)world.func_175625_s(pos);
        Item item = equipped = entityplayer.func_184614_ca() != null ? entityplayer.func_184614_ca().func_77973_b() : null;
        if (equipped != null) {
            if (equipped instanceof ItemMultitool || equipped instanceof ItemCardEmpty || equipped instanceof ModuleBase || equipped instanceof ItemCardPowerLink || equipped instanceof ItemCardSecurityLink) {
                return false;
            }
            if (equipped == Item.func_150898_a((Block)Blocks.field_150442_at)) {
                return false;
            }
            if (tileentity == null) {
                return false;
            }
        }
        if (tileentity instanceof TileEntityAdvSecurityStation && tileentity.isActive() && !SecurityHelper.isAccessGranted(tileentity, entityplayer, world, SecurityRight.CSR)) {
            return true;
        }
        if (tileentity instanceof TileEntityControlSystem && !SecurityHelper.isAccessGranted(tileentity, entityplayer, world, SecurityRight.UCS)) {
            return true;
        }
        if (!SecurityHelper.isAccessGranted(tileentity, entityplayer, world, SecurityRight.EB)) {
            return true;
        }
        entityplayer.openGui((Object)ModularForceFieldSystem.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityMachines) {
            ((TileEntityMachines)tileEntity).dropPlugins();
        }
        world.func_175713_t(pos);
    }

    public static boolean isActive(IBlockAccess iblockaccess, BlockPos pos) {
        TileEntity tileentity = iblockaccess.func_175625_s(pos);
        if (tileentity instanceof TileEntityMachines) {
            return ((TileEntityMachines)tileentity).isActive();
        }
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityMachines) {
            // empty if block
        }
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)BlockPistonBase.func_185647_a((BlockPos)pos, (EntityLivingBase)placer));
    }

    public float func_149638_a(Entity exploder) {
        return super.func_149638_a(exploder);
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        if (world.func_175625_s(pos) instanceof TileEntityMachines) {
            TileEntity tileentity = world.func_175625_s(pos);
            if (((TileEntityMachines)tileentity).isActive()) {
                return 999.0f;
            }
            return 100.0f;
        }
        return 100.0f;
    }
}

