/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.mffs.common.block;

import com.nekokittygames.mffs.api.IFieldTeleporter;
import com.nekokittygames.mffs.api.IForceFieldBlock;
import com.nekokittygames.mffs.api.PointXYZ;
import com.nekokittygames.mffs.common.ForceFieldBlockStack;
import com.nekokittygames.mffs.common.ForceFieldTyps;
import com.nekokittygames.mffs.common.Functions;
import com.nekokittygames.mffs.common.Linkgrid;
import com.nekokittygames.mffs.common.MFFSDamageSource;
import com.nekokittygames.mffs.common.ModularForceFieldSystem;
import com.nekokittygames.mffs.common.SecurityHelper;
import com.nekokittygames.mffs.common.SecurityRight;
import com.nekokittygames.mffs.common.WorldMap;
import com.nekokittygames.mffs.common.item.ItemCardPowerLink;
import com.nekokittygames.mffs.common.multitool.ItemDebugger;
import com.nekokittygames.mffs.common.tileentity.TileEntityCapacitor;
import com.nekokittygames.mffs.common.tileentity.TileEntityForceField;
import com.nekokittygames.mffs.common.tileentity.TileEntityProjector;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockForceField
extends Block
implements IForceFieldBlock,
ITileEntityProvider {
    public static PropertyEnum<ForceFieldTyps> FORCEFIELD_TYPE = PropertyEnum.func_177709_a((String)"type", ForceFieldTyps.class);
    public static int renderer;
    public BlockPos blockPos;

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FORCEFIELD_TYPE});
    }

    public int func_176201_c(IBlockState state) {
        return ((ForceFieldTyps)((Object)state.func_177229_b(FORCEFIELD_TYPE))).ordinal();
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int eventID, int eventParam) {
        super.func_189539_a(state, worldIn, pos, eventID, eventParam);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity != null && tileentity.func_145842_c(eventID, eventParam);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(FORCEFIELD_TYPE, (Comparable)((Object)ForceFieldTyps.values()[meta]));
    }

    public BlockForceField() {
        super(Material.field_151592_s);
        this.func_149722_s();
        this.func_149752_b(999.0f);
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(FORCEFIELD_TYPE, (Comparable)((Object)ForceFieldTyps.Default)));
        this.func_149663_c("modularforcefieldsystem.forceField");
        this.setRegistryName("forceField");
    }

    public int func_149738_a(World worldIn) {
        return 5;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.blockPos = pos;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        IBlockState bs = world.func_180495_p(neighbor);
        if (bs.func_177230_c() != ModularForceFieldSystem.MFFSFieldblock) {
            for (int x1 = -1; x1 <= 1; ++x1) {
                for (int y1 = -1; y1 <= 1; ++y1) {
                    for (int z1 = -1; z1 <= 1; ++z1) {
                        if (world.func_180495_p(pos.func_177982_a(x1, y1, z1)) == ModularForceFieldSystem.MFFSFieldblock || world.func_180495_p(pos.func_177982_a(x1, y1, z1)) != Blocks.field_150350_a) continue;
                        this.func_180663_b((World)world, pos.func_177982_a(x1, y1, z1), bs);
                    }
                }
            }
        }
    }

    public int func_149750_m(IBlockState state) {
        if (state.func_177229_b(FORCEFIELD_TYPE) == ForceFieldTyps.Light) {
            return 255;
        }
        return super.func_149750_m(state);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState block) {
        TileEntityProjector Projector;
        ForceFieldBlockStack ffworldmap = WorldMap.getForceFieldWorld(world).getForceFieldStackMap(new PointXYZ(pos, world).hashCode());
        if (ffworldmap != null && !ffworldmap.isEmpty() && (Projector = Linkgrid.getWorldMap(world).getProjektor().get(ffworldmap.getProjectorID())) != null) {
            if (!Projector.isActive()) {
                ffworldmap.removebyProjector(ffworldmap.getProjectorID());
            } else {
                world.func_175656_a(pos, ModularForceFieldSystem.MFFSFieldblock.func_176223_P().func_177226_a(FORCEFIELD_TYPE, (Comparable)((Object)ffworldmap.getTyp())));
                world.markAndNotifyBlock(pos, world.func_175726_f(pos), world.func_180495_p(pos), ModularForceFieldSystem.MFFSFieldblock.func_176223_P().func_177226_a(FORCEFIELD_TYPE, (Comparable)((Object)ffworldmap.getTyp())), 3);
                ffworldmap.setSync(true);
                if (ffworldmap.getTyp() == ForceFieldTyps.Default) {
                    Projector.consumePower(ModularForceFieldSystem.forceFieldBlockCost * ModularForceFieldSystem.forceFieldBlockCreateModifier, false);
                } else {
                    Projector.consumePower(ModularForceFieldSystem.forceFieldBlockCost * ModularForceFieldSystem.forceFieldBlockCreateModifier * ModularForceFieldSystem.forceFieldBlockZapperModifier, false);
                }
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return false;
        }
        ItemStack stack = heldItem;
        if (stack == null) {
            return false;
        }
        Item item = stack.func_77973_b();
        boolean debugger = item instanceof ItemDebugger;
        if (!(item instanceof IFieldTeleporter) && !debugger) {
            return false;
        }
        WorldMap.ForceFieldWorld wff = WorldMap.getForceFieldWorld(world);
        ForceFieldBlockStack ffworldmap = wff.getForceFieldStackMap(new PointXYZ(pos, world));
        if (ffworldmap != null) {
            int Sec_Gen_ID = -1;
            int First_Gen_ID = ffworldmap.getGenratorID();
            int First_Pro_ID = ffworldmap.getProjectorID();
            TileEntityCapacitor generator = Linkgrid.getWorldMap(world).getCapacitor().get(First_Gen_ID);
            TileEntityProjector projector = Linkgrid.getWorldMap(world).getProjektor().get(First_Pro_ID);
            if (projector != null && generator != null) {
                if (debugger) {
                    projector.setBurnedOut(true);
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("mffs.burntOut", new Object[]{projector.func_174877_v().toString()}));
                    return true;
                }
                if (projector.isActive()) {
                    boolean passThrough = false;
                    switch (projector.getaccesstyp()) {
                        case 0: {
                            passThrough = false;
                            String[] ops = ModularForceFieldSystem.Admin.split(";");
                            for (int i = 0; i <= ops.length - 1; ++i) {
                                if (!player.func_110124_au().toString().equalsIgnoreCase(ops[i])) continue;
                                passThrough = true;
                            }
                            break;
                        }
                        case 1: {
                            passThrough = true;
                            break;
                        }
                        case 2: {
                            passThrough = SecurityHelper.isAccessGranted(generator, player, world, SecurityRight.FFB);
                            break;
                        }
                        case 3: {
                            passThrough = SecurityHelper.isAccessGranted(projector, player, world, SecurityRight.FFB);
                        }
                    }
                    if (passThrough) {
                        int typ = 99;
                        int ymodi = 0;
                        int lm = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                        int i1 = Math.round(player.field_70125_A);
                        if (i1 >= 65) {
                            typ = 1;
                        } else if (i1 <= -65) {
                            typ = 0;
                        } else if (lm == 0) {
                            typ = 2;
                        } else if (lm == 1) {
                            typ = 5;
                        } else if (lm == 2) {
                            typ = 3;
                        } else if (lm == 3) {
                            typ = 4;
                        }
                        int counter = 0;
                        while (Sec_Gen_ID != 0) {
                            Sec_Gen_ID = wff.isExistForceFieldStackMap(pos, counter, typ, world);
                            if (Sec_Gen_ID == 0) continue;
                            ++counter;
                        }
                        if (First_Gen_ID != wff.isExistForceFieldStackMap(pos, counter - 1, typ, world)) {
                            Functions.ChattoPlayer(player, "fieldSecurity.accessDenied", new Object[0]);
                            return false;
                        }
                        BlockPos newPos = new BlockPos((Vec3i)pos);
                        switch (typ) {
                            case 0: {
                                newPos = newPos.func_177982_a(0, counter, 0);
                                ymodi = -1;
                                break;
                            }
                            case 1: {
                                newPos = newPos.func_177982_a(0, -counter, 0);
                                ymodi = 1;
                                break;
                            }
                            case 2: {
                                newPos = newPos.func_177982_a(0, 0, counter);
                                break;
                            }
                            case 3: {
                                newPos = newPos.func_177982_a(0, 0, -counter);
                                break;
                            }
                            case 4: {
                                newPos = newPos.func_177982_a(counter, 0, 0);
                                break;
                            }
                            case 5: {
                                newPos = newPos.func_177982_a(-counter, 0, 0);
                            }
                        }
                        Functions.ChattoPlayer(player, "fieldSecurity.accessGranted", new Object[0]);
                        if (counter >= 0 && counter <= 5) {
                            if ((world.func_180495_p(newPos).func_185904_a().func_76224_d() || world.func_175623_d(newPos)) && (world.func_180495_p(newPos.func_177982_a(0, -ymodi, 0)).func_185904_a().func_76224_d() || world.func_175623_d(newPos.func_177982_a(0, -ymodi, 0)))) {
                                if (newPos.func_177956_o() - ymodi <= 0) {
                                    Functions.ChattoPlayer(player, "fieldSecurity.voidNotAllowed", new Object[0]);
                                } else {
                                    IFieldTeleporter teleporter = (IFieldTeleporter)item;
                                    if (teleporter.canFieldTeleport(player, stack, ModularForceFieldSystem.forceFieldTransportCost)) {
                                        teleporter.onFieldTeleportSuccess(player, stack, ModularForceFieldSystem.forceFieldTransportCost);
                                        player.func_70634_a((double)newPos.func_177958_n() + 0.5, (double)(newPos.func_177956_o() - ymodi), (double)newPos.func_177952_p() + 0.5);
                                    } else {
                                        teleporter.onFieldTeleportFailed(player, stack, ModularForceFieldSystem.forceFieldTransportCost);
                                    }
                                }
                            } else {
                                Functions.ChattoPlayer(player, "fieldSecurity.detectedObstacle", new Object[0]);
                            }
                        } else {
                            Functions.ChattoPlayer(player, "fieldSecurity.fieldTooStrong", new Object[0]);
                        }
                    } else {
                        Functions.ChattoPlayer(player, "fieldSecurity.accessDenied", new Object[0]);
                    }
                }
            } else if (projector != null && projector.func_70301_a(projector.getPowerlinkSlot()) != null && !(projector.func_70301_a(projector.getPowerlinkSlot()).func_77973_b() instanceof ItemCardPowerLink)) {
                Functions.ChattoPlayer(player, "fieldSecurity.invalidItemInPowerLink", new Object[0]);
            }
        }
        return false;
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        if (world.field_72995_K) {
            return;
        }
        ForceFieldBlockStack ffworldmap = WorldMap.getForceFieldWorld(world).getForceFieldStackMap(new PointXYZ(pos, world).hashCode());
        if (ffworldmap != null && !ModularForceFieldSystem.adventureMapMode) {
            TileEntityProjector projector = Linkgrid.getWorldMap(world).getProjektor().get(ffworldmap.getProjectorID());
            if (projector != null) {
                switch (projector.getaccesstyp()) {
                    case 0: {
                        player.func_70097_a(MFFSDamageSource.fieldShock, 10.0f);
                        Functions.ChattoPlayer(player, "field.highEnergyField", new Object[0]);
                        break;
                    }
                    case 2: 
                    case 3: {
                        if (SecurityHelper.isAccessGranted(projector, player, world, SecurityRight.SR)) break;
                        player.func_70097_a(MFFSDamageSource.fieldShock, 10.0f);
                        Functions.ChattoPlayer(player, "field.highEnergyField", new Object[0]);
                    }
                }
            }
            if (!SecurityHelper.isAccessGranted(projector, player, world, SecurityRight.SR)) {
                player.func_70097_a(MFFSDamageSource.fieldShock, 10.0f);
                Functions.ChattoPlayer(player, "field.highEnergyField", new Object[0]);
            }
        }
        Random random = null;
        this.func_180650_b(world, pos, world.func_180495_p(pos), random);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null && te instanceof TileEntityForceField) {
            TileEntityForceField tef = (TileEntityForceField)te;
            Block block = tef.getForcefieldCamoblock();
            if (block != null) {
                return block.func_176221_a(block.func_176203_a(tef.getForcefieldCamoblockmeta()), worldIn, pos);
            }
            return super.func_176221_a(state, worldIn, pos);
        }
        return super.func_176221_a(state, worldIn, pos);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, World world, BlockPos pos) {
        if (blockState.func_177229_b(FORCEFIELD_TYPE) == ForceFieldTyps.Zapper) {
            float f = 0.0625f;
            return new AxisAlignedBB((double)((float)pos.func_177958_n() + f), (double)((float)pos.func_177956_o() + f), (double)((float)pos.func_177952_p() + f), (double)((float)(pos.func_177958_n() + 1) - f), (double)((float)(pos.func_177956_o() + 1) - f), (double)((float)(pos.func_177952_p() + 1) - f));
        }
        return super.func_180646_a(blockState, world, pos);
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return this.func_185496_a(state, (IBlockAccess)worldIn, pos);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        TileEntityProjector projector;
        ForceFieldBlockStack ffworldmap;
        if (state.func_177229_b(FORCEFIELD_TYPE) == ForceFieldTyps.Zapper) {
            if (entity instanceof EntityLiving) {
                entity.func_70097_a(MFFSDamageSource.fieldShock, 10.0f);
            }
        } else if (entity instanceof EntityPlayer && (ffworldmap = WorldMap.getForceFieldWorld(world).getorcreateFFStackMap(pos, world)) != null && (projector = Linkgrid.getWorldMap(world).getProjektor().get(ffworldmap.getProjectorID())) != null) {
            boolean passtrue = false;
            switch (projector.getaccesstyp()) {
                case 0: {
                    passtrue = false;
                    if (!ModularForceFieldSystem.Admin.equals(((EntityPlayer)entity).func_110124_au())) break;
                    passtrue = true;
                    break;
                }
                case 1: {
                    passtrue = true;
                    break;
                }
                case 2: {
                    TileEntityCapacitor generator = Linkgrid.getWorldMap(world).getCapacitor().get(ffworldmap.getGenratorID());
                    passtrue = SecurityHelper.isAccessGranted(generator, (EntityPlayer)entity, world, SecurityRight.FFB);
                    break;
                }
                case 3: {
                    passtrue = SecurityHelper.isAccessGranted(projector, (EntityPlayer)entity, world, SecurityRight.FFB);
                }
            }
            if (!passtrue) {
                ((EntityPlayer)entity).func_70097_a(MFFSDamageSource.fieldShock, 20.0f);
            } else {
                ((EntityPlayer)entity).func_70097_a(MFFSDamageSource.fieldShock, 1.0f);
            }
            Functions.ChattoPlayer((EntityPlayer)entity, "field.highEnergyField", new Object[0]);
        }
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        IBlockState iblockstate = blockAccess.func_180495_p(pos.func_177972_a(side));
        Block block = iblockstate.func_177230_c();
        if (blockState != iblockstate) {
            return true;
        }
        if (block == this) {
            return false;
        }
        return block == this ? false : super.func_176225_a(blockState, blockAccess, pos, side);
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT_MIPPED || layer == BlockRenderLayer.CUTOUT;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        TileEntity tileEntity;
        ForceFieldBlockStack ffworldmap = WorldMap.getForceFieldWorld(world).getForceFieldStackMap(new PointXYZ(pos, world).hashCode());
        if (ffworldmap != null && !ffworldmap.isEmpty() && (tileEntity = (TileEntity)Linkgrid.getWorldMap(world).getProjektor().get(ffworldmap.getProjectorID())) instanceof TileEntityProjector && tileEntity != null) {
            ((TileEntityProjector)tileEntity).consumePower(ModularForceFieldSystem.forceFieldBlockCost * ModularForceFieldSystem.forceFieldBlockCreateModifier, false);
        }
        return 999.0f;
    }

    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (ModularForceFieldSystem.showZapperParticles && stateIn.func_177229_b(FORCEFIELD_TYPE) == ForceFieldTyps.Zapper) {
            double d = (double)pos.func_177958_n() + Math.random() + 0.2;
            double d1 = (double)pos.func_177956_o() + Math.random() + 0.2;
            double d2 = (double)pos.func_177952_p() + Math.random() + 0.2;
            worldIn.func_175688_a(EnumParticleTypes.TOWN_AURA, d, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        TileEntityProjector Projector;
        ForceFieldBlockStack ffworldmap = WorldMap.getForceFieldWorld(world).getForceFieldStackMap(new PointXYZ(pos, world).hashCode());
        if (ffworldmap != null && !ffworldmap.isEmpty() && (Projector = Linkgrid.getWorldMap(world).getProjektor().get(ffworldmap.getProjectorID())) != null && !Projector.isActive()) {
            ffworldmap.removebyProjector(ffworldmap.getProjectorID());
        }
        if (ffworldmap == null || ffworldmap.isEmpty()) {
            world.func_175713_t(pos);
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
        }
        world.func_175704_b(pos, pos);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        if (meta == ForceFieldTyps.Camouflage.ordinal()) {
            return new TileEntityForceField();
        }
        return null;
    }

    @Override
    public void weakenForceField(World world, BlockPos pos) {
        if (ModularForceFieldSystem.influencedByOtherMods) {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
        }
    }
}

