/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import gcewing.architecture.Matrix3;
import gcewing.architecture.Vector3;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class Trans3 {
    public static Trans3 ident = new Trans3(Vector3.zero);
    public static Trans3 blockCenter = new Trans3(Vector3.blockCenter);
    public static Trans3[][] sideTurnRotations = new Trans3[6][4];
    public Vector3 offset;
    public Matrix3 rotation;
    public double scaling;

    public static Trans3 blockCenter(BlockPos blockPos) {
        return new Trans3(Vector3.blockCenter(blockPos));
    }

    public static Trans3 sideTurn(int n, int n2) {
        return sideTurnRotations[n][n2];
    }

    public static Trans3 sideTurn(double d, double d2, double d3, int n, int n2) {
        return Trans3.sideTurn(new Vector3(d, d2, d3), n, n2);
    }

    public static Trans3 blockCenterSideTurn(int n, int n2) {
        return Trans3.sideTurn(Vector3.blockCenter, n, n2);
    }

    public static Trans3 sideTurn(Vector3 vector3, int n, int n2) {
        return new Trans3(vector3, Matrix3.sideTurnRotations[n][n2]);
    }

    public Trans3(Vector3 vector3) {
        this(vector3, Matrix3.ident);
    }

    public Trans3(Vector3 vector3, Matrix3 matrix3) {
        this(vector3, matrix3, 1.0);
    }

    public Trans3(Vector3 vector3, Matrix3 matrix3, double d) {
        this.offset = vector3;
        this.rotation = matrix3;
        this.scaling = d;
    }

    public Trans3(double d, double d2, double d3) {
        this(new Vector3(d, d2, d3), Matrix3.ident, 1.0);
    }

    public Trans3(BlockPos blockPos) {
        this((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5);
    }

    public Trans3 translate(Vector3 vector3) {
        if (vector3 == Vector3.zero) {
            return this;
        }
        return this.translate(vector3.x, vector3.y, vector3.z);
    }

    public Trans3 translate(double d, double d2, double d3) {
        return new Trans3(this.offset.add(this.rotation.mul(d * this.scaling, d2 * this.scaling, d3 * this.scaling)), this.rotation, this.scaling);
    }

    public Trans3 rotate(Matrix3 matrix3) {
        return new Trans3(this.offset, this.rotation.mul(matrix3), this.scaling);
    }

    public Trans3 rotX(double d) {
        return this.rotate(Matrix3.rotX(d));
    }

    public Trans3 rotY(double d) {
        return this.rotate(Matrix3.rotY(d));
    }

    public Trans3 rotZ(double d) {
        return this.rotate(Matrix3.rotZ(d));
    }

    public Trans3 scale(double d) {
        return new Trans3(this.offset, this.rotation, this.scaling * d);
    }

    public Trans3 side(EnumFacing enumFacing) {
        return this.side(enumFacing.ordinal());
    }

    public Trans3 side(int n) {
        return this.rotate(Matrix3.sideRotations[n]);
    }

    public Trans3 turn(int n) {
        return this.rotate(Matrix3.turnRotations[n]);
    }

    public Trans3 t(Trans3 trans3) {
        return new Trans3(this.offset.add(this.rotation.mul(trans3.offset).mul(this.scaling)), this.rotation.mul(trans3.rotation), this.scaling * trans3.scaling);
    }

    public Vector3 p(double d, double d2, double d3) {
        return this.p(new Vector3(d, d2, d3));
    }

    public Vector3 p(Vector3 vector3) {
        return this.offset.add(this.rotation.mul(vector3.mul(this.scaling)));
    }

    public Vector3 ip(double d, double d2, double d3) {
        return this.ip(new Vector3(d, d2, d3));
    }

    public Vector3 ip(Vector3 vector3) {
        return this.rotation.imul(vector3.sub(this.offset)).mul(1.0 / this.scaling);
    }

    public Vector3 v(double d, double d2, double d3) {
        return this.v(new Vector3(d, d2, d3));
    }

    public Vector3 iv(double d, double d2, double d3) {
        return this.iv(new Vector3(d, d2, d3));
    }

    public Vector3 v(Vec3i vec3i) {
        return this.v(vec3i.func_177958_n(), vec3i.func_177956_o(), vec3i.func_177952_p());
    }

    public Vector3 iv(Vec3i vec3i) {
        return this.iv(vec3i.func_177958_n(), vec3i.func_177956_o(), vec3i.func_177952_p());
    }

    public Vector3 v(Vector3 vector3) {
        return this.rotation.mul(vector3.mul(this.scaling));
    }

    public Vector3 v(EnumFacing enumFacing) {
        return this.v(Vector3.getDirectionVec(enumFacing));
    }

    public Vector3 iv(EnumFacing enumFacing) {
        return this.iv(Vector3.getDirectionVec(enumFacing));
    }

    public Vector3 iv(Vector3 vector3) {
        return this.rotation.imul(vector3).mul(1.0 / this.scaling);
    }

    public Vector3 iv(Vec3d vec3d) {
        return this.iv(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
    }

    public AxisAlignedBB t(AxisAlignedBB axisAlignedBB) {
        return Trans3.boxEnclosing(this.p(axisAlignedBB.field_72340_a, axisAlignedBB.field_72338_b, axisAlignedBB.field_72339_c), this.p(axisAlignedBB.field_72336_d, axisAlignedBB.field_72337_e, axisAlignedBB.field_72334_f));
    }

    public AxisAlignedBB box(Vector3 vector3, Vector3 vector32) {
        return Trans3.boxEnclosing(this.p(vector3), this.p(vector32));
    }

    public static int turnFor(Entity entity, int n) {
        if (n > 1) {
            return 0;
        }
        int n2 = Math.round(entity.field_70177_z / 90.0f);
        n2 = n == 0 ? 2 - n2 : 2 + n2;
        return n2 & 3;
    }

    public static AxisAlignedBB boxEnclosing(Vector3 vector3, Vector3 vector32) {
        return new AxisAlignedBB(vector3.x, vector3.y, vector3.z, vector32.x, vector32.y, vector32.z);
    }

    public EnumFacing t(EnumFacing enumFacing) {
        return this.v(enumFacing).facing();
    }

    public EnumFacing it(EnumFacing enumFacing) {
        return this.iv(enumFacing).facing();
    }

    public void addBox(Vector3 vector3, Vector3 vector32, List list) {
        this.addBox(vector3.x, vector3.y, vector3.z, vector32.x, vector32.y, vector32.z, list);
    }

    public void addBox(double d, double d2, double d3, double d4, double d5, double d6, List list) {
        AxisAlignedBB axisAlignedBB = Trans3.boxEnclosing(this.p(d, d2, d3), this.p(d4, d5, d6));
        list.add(axisAlignedBB);
    }

    static {
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 4; ++j) {
                Trans3.sideTurnRotations[i][j] = new Trans3(Vector3.zero, Matrix3.sideTurnRotations[i][j]);
            }
        }
    }
}

