/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import java.util.Collection;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.MapStorage;
import net.minecraftforge.common.DimensionManager;

public class BaseUtils {
    public static EnumFacing[] facings = EnumFacing.values();

    public static int min(int n, int n2) {
        return n < n2 ? n : n2;
    }

    public static int max(int n, int n2) {
        return n > n2 ? n : n2;
    }

    public static double min(double d, double d2) {
        return d < d2 ? d : d2;
    }

    public static double max(double d, double d2) {
        return d > d2 ? d : d2;
    }

    public static int ifloor(double d) {
        return (int)Math.floor(d);
    }

    public static int iround(double d) {
        return (int)Math.round(d);
    }

    public static int iceil(double d) {
        return (int)Math.ceil(d);
    }

    public static Object[] arrayOf(Collection collection) {
        int n = collection.size();
        Object[] objectArray = new Object[n];
        int n2 = 0;
        for (Object e : collection) {
            objectArray[n2++] = e;
        }
        return objectArray;
    }

    public static int packedColor(double d, double d2, double d3) {
        return (int)(d * 255.0) << 16 | (int)(d2 * 255.0) << 8 | (int)(d3 * 255.0);
    }

    public static int turnToFace(EnumFacing enumFacing, EnumFacing enumFacing2) {
        return BaseUtils.turnToFaceEast(enumFacing) - BaseUtils.turnToFaceEast(enumFacing2) & 3;
    }

    public static int turnToFaceEast(EnumFacing enumFacing) {
        switch (enumFacing) {
            case SOUTH: {
                return 1;
            }
            case WEST: {
                return 2;
            }
            case NORTH: {
                return 3;
            }
        }
        return 0;
    }

    public static MinecraftServer getMinecraftServer() {
        return DimensionManager.getWorld((int)0).func_73046_m();
    }

    public static WorldServer getWorldForDimension(int n) {
        return BaseUtils.getMinecraftServer().func_71218_a(n);
    }

    public static <T extends WorldSavedData> T getWorldData(World world, Class<T> clazz, String string) {
        MapStorage mapStorage = world.getPerWorldStorage();
        WorldSavedData worldSavedData = mapStorage.func_75742_a(clazz, string);
        if (worldSavedData == null) {
            try {
                worldSavedData = (WorldSavedData)clazz.getConstructor(String.class).newInstance(string);
                mapStorage.func_75745_a(string, worldSavedData);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return (T)worldSavedData;
    }
}

