/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import gcewing.architecture.BaseBlockUtils;
import gcewing.architecture.BaseMod;
import gcewing.architecture.BaseReflectionUtils;
import gcewing.architecture.Trans3;
import gcewing.architecture.Vector3;
import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeChunkManager;

public class BaseTileEntity
extends TileEntity
implements BaseMod.ITileEntity {
    public byte side;
    public byte turn;
    public ForgeChunkManager.Ticket chunkTicket;
    protected boolean updateChunk;
    protected static Field changedSectionFilter = BaseReflectionUtils.getFieldDef(BaseReflectionUtils.classForName("net.minecraft.server.management.PlayerChunkMapEntry"), "changedSectionFilter", "field_187288_h");

    public int getX() {
        return this.field_174879_c.func_177958_n();
    }

    public int getY() {
        return this.field_174879_c.func_177956_o();
    }

    public int getZ() {
        return this.field_174879_c.func_177952_p();
    }

    public void setSide(int n) {
        this.side = (byte)n;
    }

    public void setTurn(int n) {
        this.turn = (byte)n;
    }

    public Trans3 localToGlobalRotation() {
        return this.localToGlobalTransformation(Vector3.zero);
    }

    public Trans3 localToGlobalTransformation() {
        return this.localToGlobalTransformation(Vector3.blockCenter(this.field_174879_c));
    }

    public Trans3 localToGlobalTransformation(Vector3 vector3) {
        IBlockState iBlockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        Block block = iBlockState.func_177230_c();
        if (block instanceof BaseMod.IBlock) {
            return ((BaseMod.IBlock)block).localToGlobalTransformation((IBlockAccess)this.field_145850_b, this.field_174879_c, iBlockState, vector3);
        }
        System.out.printf("BaseTileEntity.localToGlobalTransformation: Wrong block type at %s\n", this.field_174879_c);
        return new Trans3(vector3);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        if (this.syncWithClient()) {
            this.func_189515_b(nBTTagCompound);
        }
        return nBTTagCompound;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        if (this.syncWithClient()) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            this.func_189515_b(nBTTagCompound);
            if (this.updateChunk) {
                nBTTagCompound.func_74757_a("updateChunk", true);
                this.updateChunk = false;
            }
            return new SPacketUpdateTileEntity(this.field_174879_c, 0, nBTTagCompound);
        }
        return null;
    }

    public void onDataPacket(NetworkManager networkManager, SPacketUpdateTileEntity sPacketUpdateTileEntity) {
        NBTTagCompound nBTTagCompound = sPacketUpdateTileEntity.func_148857_g();
        this.func_145839_a(nBTTagCompound);
        if (nBTTagCompound.func_74767_n("updateChunk")) {
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        }
    }

    boolean syncWithClient() {
        return true;
    }

    public void markBlockForUpdate() {
        this.updateChunk = true;
        BaseBlockUtils.markBlockForUpdate(this.field_145850_b, this.field_174879_c);
    }

    public void markForUpdate() {
        if (!this.field_145850_b.field_72995_K) {
            int n = this.field_174879_c.func_177958_n();
            int n2 = this.field_174879_c.func_177956_o();
            int n3 = this.field_174879_c.func_177952_p();
            PlayerChunkMap playerChunkMap = ((WorldServer)this.field_145850_b).func_184164_w();
            PlayerChunkMapEntry playerChunkMapEntry = playerChunkMap.func_187301_b(n >> 4, n3 >> 4);
            if (playerChunkMapEntry != null) {
                int n4 = BaseReflectionUtils.getIntField(playerChunkMapEntry, changedSectionFilter);
                playerChunkMapEntry.func_187265_a(n & 0xF, n2, n3 & 0xF);
                BaseReflectionUtils.setIntField(playerChunkMapEntry, changedSectionFilter, n4);
            }
        }
    }

    public void playSoundEffect(SoundEvent soundEvent, float f, float f2) {
        this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, soundEvent, SoundCategory.BLOCKS, f, f2);
    }

    @Override
    public void onAddedToWorld() {
    }

    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.side = nBTTagCompound.func_74771_c("side");
        this.turn = nBTTagCompound.func_74771_c("turn");
        this.readContentsFromNBT(nBTTagCompound);
    }

    public void readFromItemStack(ItemStack itemStack) {
        NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
        if (nBTTagCompound != null) {
            this.readFromItemStackNBT(nBTTagCompound);
        }
    }

    public void readFromItemStackNBT(NBTTagCompound nBTTagCompound) {
        this.readContentsFromNBT(nBTTagCompound);
    }

    public void readContentsFromNBT(NBTTagCompound nBTTagCompound) {
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nBTTagCompound) {
        super.func_189515_b(nBTTagCompound);
        if (this.side != 0) {
            nBTTagCompound.func_74774_a("side", this.side);
        }
        if (this.turn != 0) {
            nBTTagCompound.func_74774_a("turn", this.turn);
        }
        this.writeContentsToNBT(nBTTagCompound);
        return nBTTagCompound;
    }

    public void writeToItemStackNBT(NBTTagCompound nBTTagCompound) {
        this.writeContentsToNBT(nBTTagCompound);
    }

    public void writeContentsToNBT(NBTTagCompound nBTTagCompound) {
    }

    public void markChanged() {
        this.func_70296_d();
        this.markForUpdate();
    }

    public void markBlockChanged() {
        this.func_70296_d();
        this.markBlockForUpdate();
    }

    public void func_145843_s() {
        this.releaseChunkTicket();
        super.func_145843_s();
    }

    public void releaseChunkTicket() {
        if (this.chunkTicket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
            this.chunkTicket = null;
        }
    }

    public static ItemStack blockStackWithTileEntity(Block block, int n, BaseTileEntity baseTileEntity) {
        return BaseTileEntity.blockStackWithTileEntity(block, n, 0, baseTileEntity);
    }

    public static ItemStack blockStackWithTileEntity(Block block, int n, int n2, BaseTileEntity baseTileEntity) {
        ItemStack itemStack = new ItemStack(block, n, n2);
        if (baseTileEntity != null) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            baseTileEntity.writeToItemStackNBT(nBTTagCompound);
            itemStack.func_77982_d(nBTTagCompound);
        }
        return itemStack;
    }

    public ItemStack newItemStack(int n) {
        return BaseTileEntity.blockStackWithTileEntity(this.func_145838_q(), n, this);
    }
}

