/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class BaseReflectionUtils {
    public static Class classForName(String string) {
        try {
            return Class.forName(string);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static Field getFieldDef(Class clazz, String string, String string2) {
        try {
            Field field;
            try {
                field = clazz.getDeclaredField(string);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                field = clazz.getDeclaredField(string2);
            }
            field.setAccessible(true);
            return field;
        }
        catch (Exception exception) {
            throw new RuntimeException(String.format("Cannot find field %s or %s of %s", string, string2, clazz.getName()), exception);
        }
    }

    public static Object getField(Object object, String string, String string2) {
        Field field = BaseReflectionUtils.getFieldDef(object.getClass(), string, string2);
        return BaseReflectionUtils.getField(object, field);
    }

    public static Object getField(Object object, Field field) {
        try {
            return field.get(object);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static int getIntField(Object object, Field field) {
        try {
            return field.getInt(object);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void setField(Object object, String string, String string2, Object object2) {
        Field field = BaseReflectionUtils.getFieldDef(object.getClass(), string, string2);
        BaseReflectionUtils.setField(object, field, object2);
    }

    public static void setField(Object object, Field field, Object object2) {
        try {
            field.set(object, object2);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void setIntField(Object object, Field field, int n) {
        try {
            field.setInt(object, n);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static Method getMethodDef(Class clazz, String string, String string2, Class ... classArray) {
        try {
            Method method;
            try {
                method = clazz.getDeclaredMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                method = clazz.getDeclaredMethod(string2, classArray);
            }
            method.setAccessible(true);
            return method;
        }
        catch (Exception exception) {
            throw new RuntimeException(String.format("Cannot find method %s or %s of %s", string, string2, clazz.getName()), exception);
        }
    }

    public static Object invokeMethod(Object object, Method method, Object ... objectArray) {
        try {
            return method.invoke(object, objectArray);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

