/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import gcewing.architecture.BaseMod;
import gcewing.architecture.BaseModClient;
import gcewing.architecture.BaseUtils;
import gcewing.architecture.Trans3;
import gcewing.architecture.Vector3;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BaseBlock<TE extends TileEntity>
extends BlockContainer
implements BaseMod.IBlock {
    public static boolean debugState = false;
    public static IOrientationHandler orient1Way = new Orient1Way();
    protected MapColor mapColor;
    protected IProperty[] properties;
    protected Object[][] propertyValues;
    protected int numProperties;
    protected EnumBlockRenderType renderID = EnumBlockRenderType.MODEL;
    protected Class<? extends TileEntity> tileEntityClass = null;
    protected IOrientationHandler orientationHandler = orient1Way;
    protected String[] textureNames;
    protected BaseMod.ModelSpec modelSpec;
    protected BaseMod mod;
    protected AxisAlignedBB boxHit;
    protected ThreadLocal<TileEntity> harvestingTileEntity = new ThreadLocal();

    public BaseBlock(Material material) {
        this(material, null, null, null);
    }

    public BaseBlock(Material material, IOrientationHandler iOrientationHandler) {
        this(material, iOrientationHandler, null, null);
    }

    public BaseBlock(Material material, Class<TE> clazz) {
        this(material, null, clazz, null);
    }

    public BaseBlock(Material material, IOrientationHandler iOrientationHandler, Class<TE> clazz) {
        this(material, iOrientationHandler, clazz, null);
    }

    public BaseBlock(Material material, Class<TE> clazz, String string) {
        this(material, null, clazz, string);
    }

    public BaseBlock(Material material, IOrientationHandler iOrientationHandler, Class<TE> clazz, String string) {
        super(material);
        if (iOrientationHandler == null) {
            iOrientationHandler = orient1Way;
        }
        this.orientationHandler = iOrientationHandler;
        this.tileEntityClass = clazz;
        if (clazz != null) {
            if (string == null) {
                string = clazz.getName();
            }
            try {
                GameRegistry.registerTileEntity(clazz, (String)string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public IOrientationHandler getOrientationHandler() {
        return orient1Way;
    }

    protected void defineProperties() {
        this.properties = new IProperty[4];
        this.propertyValues = new Object[4][];
        this.getOrientationHandler().defineProperties(this);
    }

    protected void addProperty(IProperty iProperty) {
        if (debugState) {
            System.out.printf("BaseBlock.addProperty: %s to %s\n", iProperty, this.getClass().getName());
        }
        if (this.numProperties >= 4) {
            throw new IllegalStateException("Block " + this.getClass().getName() + " has too many properties");
        }
        int n = this.numProperties++;
        this.properties[n] = iProperty;
        Object[] objectArray = BaseUtils.arrayOf(iProperty.func_177700_c());
        this.propertyValues[n] = objectArray;
        if (debugState) {
            System.out.printf("BaseBlock.addProperty: %s now has %s properties\n", this.getClass().getName(), this.numProperties);
        }
    }

    protected BlockStateContainer func_180661_e() {
        if (debugState) {
            System.out.printf("BaseBlock.createBlockState: Defining properties\n", new Object[0]);
        }
        this.defineProperties();
        if (debugState) {
            this.dumpProperties();
        }
        this.checkProperties();
        IProperty[] iPropertyArray = Arrays.copyOf(this.properties, this.numProperties);
        if (debugState) {
            System.out.printf("BaseBlock.createBlockState: Creating BlockState with %s properties\n", iPropertyArray.length);
        }
        return new BlockStateContainer((Block)this, iPropertyArray);
    }

    private void dumpProperties() {
        System.out.printf("BaseBlock: Properties of %s:\n", this.getClass().getName());
        for (int i = 0; i < this.numProperties; ++i) {
            System.out.printf("%s: %s\n", i, this.properties[i]);
            Object[] objectArray = this.propertyValues[i];
            for (int j = 0; j < objectArray.length; ++j) {
                System.out.printf("   %s: %s\n", j, objectArray[j]);
            }
        }
    }

    protected void checkProperties() {
        int n = 1;
        for (int i = 0; i < this.numProperties; ++i) {
            n *= this.propertyValues[i].length;
        }
        if (n > 16) {
            throw new IllegalStateException(String.format("Block %s has %s combinations of property values (16 allowed)", this.getClass().getName(), n));
        }
    }

    public int func_176201_c(IBlockState iBlockState) {
        int n = 0;
        for (int i = this.numProperties - 1; i >= 0; --i) {
            int n2;
            Comparable comparable = iBlockState.func_177229_b(this.properties[i]);
            Object[] objectArray = this.propertyValues[i];
            for (n2 = objectArray.length - 1; n2 > 0 && !objectArray[n2].equals(comparable); --n2) {
            }
            if (debugState) {
                System.out.printf("BaseBlock.getMetaFromState: property %s value %s --> %s of %s\n", i, comparable, n2, objectArray.length);
            }
            n = n * objectArray.length + n2;
        }
        if (debugState) {
            System.out.printf("BaseBlock.getMetaFromState: %s --> %s\n", iBlockState, n);
        }
        return n & 0xF;
    }

    public IBlockState func_176203_a(int n) {
        IBlockState iBlockState = this.func_176223_P();
        int n2 = n;
        for (int i = this.numProperties - 1; i >= 0; --i) {
            Object[] objectArray = this.propertyValues[i];
            int n3 = objectArray.length;
            int n4 = n2 % n3;
            n2 /= n3;
            iBlockState = iBlockState.func_177226_a(this.properties[i], (Comparable)objectArray[n4]);
        }
        if (debugState) {
            System.out.printf("BaseBlock.getStateFromMeta: %s --> %s\n", n, iBlockState);
        }
        return iBlockState;
    }

    @Override
    public int getNumSubtypes() {
        return 1;
    }

    public void func_180657_a(World world, EntityPlayer entityPlayer, BlockPos blockPos, IBlockState iBlockState, TileEntity tileEntity, ItemStack itemStack) {
        this.harvestingTileEntity.set(tileEntity);
        super.func_180657_a(world, entityPlayer, blockPos, iBlockState, tileEntity, itemStack);
        this.harvestingTileEntity.set(null);
    }

    public List<ItemStack> getDrops(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, int n) {
        TileEntity tileEntity = iBlockAccess.func_175625_s(blockPos);
        if (tileEntity == null) {
            tileEntity = this.harvestingTileEntity.get();
        }
        return this.getDropsFromTileEntity(iBlockAccess, blockPos, iBlockState, tileEntity, n);
    }

    protected List<ItemStack> getDropsFromTileEntity(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, TileEntity tileEntity, int n) {
        return super.getDrops(iBlockAccess, blockPos, iBlockState, n);
    }

    public EnumBlockRenderType func_149645_b(IBlockState iBlockState) {
        return this.renderID;
    }

    @Override
    public String getQualifiedRendererClassName() {
        String string = this.getRendererClassName();
        if (string != null) {
            string = this.getClass().getPackage().getName() + "." + string;
        }
        return string;
    }

    protected String getRendererClassName() {
        return null;
    }

    public void setModelAndTextures(String string, String ... stringArray) {
        this.textureNames = stringArray;
        this.modelSpec = new BaseMod.ModelSpec(string, stringArray);
    }

    public void setModelAndTextures(String string, Vector3 vector3, String ... stringArray) {
        this.textureNames = stringArray;
        this.modelSpec = new BaseMod.ModelSpec(string, vector3, stringArray);
    }

    @Override
    public String[] getTextureNames() {
        return this.textureNames;
    }

    @Override
    public BaseMod.ModelSpec getModelSpec(IBlockState iBlockState) {
        return this.modelSpec;
    }

    public Trans3 localToGlobalRotation(IBlockAccess iBlockAccess, BlockPos blockPos) {
        return this.localToGlobalRotation(iBlockAccess, blockPos, iBlockAccess.func_180495_p(blockPos));
    }

    public Trans3 localToGlobalRotation(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState) {
        return this.localToGlobalTransformation(iBlockAccess, blockPos, iBlockState, Vector3.zero);
    }

    public Trans3 localToGlobalTransformation(IBlockAccess iBlockAccess, BlockPos blockPos) {
        return this.localToGlobalTransformation(iBlockAccess, blockPos, iBlockAccess.func_180495_p(blockPos));
    }

    public Trans3 localToGlobalTransformation(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState) {
        return this.localToGlobalTransformation(iBlockAccess, blockPos, iBlockState, Vector3.blockCenter(blockPos));
    }

    @Override
    public Trans3 localToGlobalTransformation(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, Vector3 vector3) {
        IOrientationHandler iOrientationHandler = this.getOrientationHandler();
        return iOrientationHandler.localToGlobalTransformation(iBlockAccess, blockPos, iBlockState, vector3);
    }

    @Override
    public Trans3 itemTransformation() {
        return Trans3.ident;
    }

    public boolean hasTileEntity(IBlockState iBlockState) {
        return this.tileEntityClass != null;
    }

    public TE getTileEntity(IBlockAccess iBlockAccess, BlockPos blockPos) {
        TileEntity tileEntity;
        if (this.func_149716_u() && this.tileEntityClass.isInstance(tileEntity = iBlockAccess.func_175625_s(blockPos))) {
            return (TE)tileEntity;
        }
        return null;
    }

    public TileEntity func_149915_a(World world, int n) {
        if (this.tileEntityClass != null) {
            try {
                return this.tileEntityClass.newInstance();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return null;
    }

    public IBlockState func_180642_a(World world, BlockPos blockPos, EnumFacing enumFacing, float f, float f2, float f3, int n, EntityLivingBase entityLivingBase) {
        IBlockState iBlockState = this.getOrientationHandler().onBlockPlaced((Block)this, world, blockPos, enumFacing, f, f2, f3, this.func_176203_a(n), entityLivingBase);
        return iBlockState;
    }

    public void func_176213_c(World world, BlockPos blockPos, IBlockState iBlockState) {
        TE TE;
        super.func_176213_c(world, blockPos, iBlockState);
        if (this.hasTileEntity(iBlockState) && (TE = this.getTileEntity((IBlockAccess)world, blockPos)) instanceof BaseMod.ITileEntity) {
            ((BaseMod.ITileEntity)TE).onAddedToWorld();
        }
    }

    public void func_180663_b(World world, BlockPos blockPos, IBlockState iBlockState) {
        TileEntity tileEntity;
        if (this.hasTileEntity(iBlockState) && (tileEntity = world.func_175625_s(blockPos)) instanceof IInventory) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)blockPos, (IInventory)((IInventory)tileEntity));
        }
    }

    public boolean addLandingEffects(IBlockState iBlockState, WorldServer worldServer, BlockPos blockPos, IBlockState iBlockState2, EntityLivingBase entityLivingBase, int n) {
        IBlockState iBlockState3 = this.getParticleState((IBlockAccess)worldServer, blockPos);
        worldServer.func_175739_a(EnumParticleTypes.BLOCK_DUST, entityLivingBase.field_70165_t, entityLivingBase.field_70163_u, entityLivingBase.field_70161_v, n, 0.0, 0.0, 0.0, 0.15, new int[]{Block.func_176210_f((IBlockState)iBlockState3)});
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState iBlockState, World world, RayTraceResult rayTraceResult, ParticleManager particleManager) {
        BlockPos blockPos = rayTraceResult.func_178782_a();
        IBlockState iBlockState2 = this.getParticleState((IBlockAccess)world, blockPos);
        int n = blockPos.func_177958_n();
        int n2 = blockPos.func_177956_o();
        int n3 = blockPos.func_177952_p();
        AxisAlignedBB axisAlignedBB = iBlockState.func_185900_c((IBlockAccess)world, blockPos);
        float f = 0.1f;
        double d = (double)n + RANDOM.nextDouble() * (axisAlignedBB.field_72336_d - axisAlignedBB.field_72340_a - (double)(f * 2.0f)) + (double)f + axisAlignedBB.field_72340_a;
        double d2 = (double)n2 + RANDOM.nextDouble() * (axisAlignedBB.field_72337_e - axisAlignedBB.field_72338_b - (double)(f * 2.0f)) + (double)f + axisAlignedBB.field_72338_b;
        double d3 = (double)n3 + RANDOM.nextDouble() * (axisAlignedBB.field_72334_f - axisAlignedBB.field_72339_c - (double)(f * 2.0f)) + (double)f + axisAlignedBB.field_72339_c;
        switch (rayTraceResult.field_178784_b) {
            case DOWN: {
                d2 = (double)n2 + axisAlignedBB.field_72338_b - (double)f;
                break;
            }
            case UP: {
                d2 = (double)n2 + axisAlignedBB.field_72337_e + (double)f;
                break;
            }
            case NORTH: {
                d3 = (double)n3 + axisAlignedBB.field_72339_c - (double)f;
                break;
            }
            case SOUTH: {
                d3 = (double)n3 + axisAlignedBB.field_72334_f + (double)f;
                break;
            }
            case WEST: {
                d = (double)n + axisAlignedBB.field_72340_a - (double)f;
                break;
            }
            case EAST: {
                d = (double)n + axisAlignedBB.field_72336_d + (double)f;
            }
        }
        DiggingFX diggingFX = new DiggingFX(world, d, d2, d3, 0.0, 0.0, 0.0, iBlockState2);
        particleManager.func_78873_a(diggingFX.func_174846_a(blockPos).func_70543_e(0.2f).func_70541_f(0.6f));
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos blockPos, ParticleManager particleManager) {
        IBlockState iBlockState = this.getParticleState((IBlockAccess)world, blockPos);
        int n = 4;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < n; ++k) {
                    double d = (double)blockPos.func_177958_n() + ((double)i + 0.5) / (double)n;
                    double d2 = (double)blockPos.func_177956_o() + ((double)j + 0.5) / (double)n;
                    double d3 = (double)blockPos.func_177952_p() + ((double)k + 0.5) / (double)n;
                    DiggingFX diggingFX = new DiggingFX(world, d, d2, d3, d - (double)blockPos.func_177958_n() - 0.5, d2 - (double)blockPos.func_177956_o() - 0.5, d3 - (double)blockPos.func_177952_p() - 0.5, iBlockState);
                    particleManager.func_78873_a((Particle)diggingFX.func_174846_a(blockPos));
                }
            }
        }
        return true;
    }

    @Override
    public IBlockState getParticleState(IBlockAccess iBlockAccess, BlockPos blockPos) {
        IBlockState iBlockState = iBlockAccess.func_180495_p(blockPos);
        return this.func_176221_a(iBlockState, iBlockAccess, blockPos);
    }

    public RayTraceResult func_180636_a(IBlockState iBlockState, World world, BlockPos blockPos, Vec3d vec3d, Vec3d vec3d2) {
        int n;
        this.boxHit = null;
        RayTraceResult rayTraceResult = null;
        double d = 0.0;
        List<AxisAlignedBB> list = this.getGlobalCollisionBoxes((IBlockAccess)world, blockPos, iBlockState, null);
        if (list != null) {
            n = list.size();
            for (int i = 0; i < n; ++i) {
                AxisAlignedBB axisAlignedBB = list.get(i);
                RayTraceResult rayTraceResult2 = axisAlignedBB.func_72327_a(vec3d, vec3d2);
                if (rayTraceResult2 == null) continue;
                rayTraceResult2.subHit = i;
                double d2 = vec3d.func_72436_e(rayTraceResult2.field_72307_f);
                if (rayTraceResult != null && !(d2 < d)) continue;
                rayTraceResult = rayTraceResult2;
                d = d2;
            }
        }
        if (rayTraceResult != null) {
            n = rayTraceResult.subHit;
            this.boxHit = list.get(n).func_72317_d((double)(-blockPos.func_177958_n()), (double)(-blockPos.func_177956_o()), (double)(-blockPos.func_177952_p()));
            rayTraceResult = new RayTraceResult(rayTraceResult.field_72307_f, rayTraceResult.field_178784_b, blockPos);
            rayTraceResult.subHit = n;
        }
        return rayTraceResult;
    }

    public AxisAlignedBB func_185496_a(IBlockState iBlockState, IBlockAccess iBlockAccess, BlockPos blockPos) {
        AxisAlignedBB axisAlignedBB = this.boxHit;
        if (axisAlignedBB == null) {
            axisAlignedBB = this.getLocalBounds(iBlockAccess, blockPos, iBlockState, null);
        }
        if (axisAlignedBB != null) {
            return axisAlignedBB;
        }
        return super.func_185496_a(iBlockState, iBlockAccess, blockPos);
    }

    public AxisAlignedBB func_180646_a(IBlockState iBlockState, World world, BlockPos blockPos) {
        return this.func_185496_a(iBlockState, (IBlockAccess)world, blockPos);
    }

    protected AxisAlignedBB getLocalBounds(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, Entity entity) {
        BaseMod.ModelSpec modelSpec = this.getModelSpec(iBlockState);
        if (modelSpec != null) {
            BaseModClient.IModel iModel = this.mod.getModel(modelSpec.modelName);
            Trans3 trans3 = this.localToGlobalTransformation(iBlockAccess, blockPos, iBlockState, Vector3.blockCenter).translate(modelSpec.origin);
            return trans3.t(iModel.getBounds());
        }
        return null;
    }

    public void func_185477_a(IBlockState iBlockState, World world, BlockPos blockPos, AxisAlignedBB axisAlignedBB, List list, Entity entity) {
        List<AxisAlignedBB> list2 = this.getGlobalCollisionBoxes((IBlockAccess)world, blockPos, iBlockState, entity);
        if (list2 != null) {
            for (AxisAlignedBB axisAlignedBB2 : list2) {
                if (axisAlignedBB.func_72326_a(axisAlignedBB2)) {
                    list.add(axisAlignedBB2);
                    continue;
                }
                super.func_185477_a(iBlockState, world, blockPos, axisAlignedBB, list, entity);
            }
        }
    }

    protected List<AxisAlignedBB> getGlobalCollisionBoxes(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, Entity entity) {
        Trans3 trans3 = this.localToGlobalTransformation(iBlockAccess, blockPos, iBlockState);
        return this.getCollisionBoxes(iBlockAccess, blockPos, iBlockState, trans3, entity);
    }

    protected List<AxisAlignedBB> getLocalCollisionBoxes(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, Entity entity) {
        Trans3 trans3 = this.localToGlobalTransformation(iBlockAccess, blockPos, iBlockState, Vector3.zero);
        return this.getCollisionBoxes(iBlockAccess, blockPos, iBlockState, trans3, entity);
    }

    protected List<AxisAlignedBB> getCollisionBoxes(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, Trans3 trans3, Entity entity) {
        BaseMod.ModelSpec modelSpec = this.getModelSpec(iBlockState);
        if (modelSpec != null) {
            BaseModClient.IModel iModel = this.mod.getModel(modelSpec.modelName);
            ArrayList<AxisAlignedBB> arrayList = new ArrayList<AxisAlignedBB>();
            iModel.addBoxesToList(trans3.translate(modelSpec.origin), arrayList);
            return arrayList;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static class DiggingFX
    extends ParticleDigging {
        public DiggingFX(World world, double d, double d2, double d3, double d4, double d5, double d6, IBlockState iBlockState) {
            super(world, d, d2, d3, d4, d5, d6, iBlockState);
        }
    }

    public static class Orient1Way
    implements IOrientationHandler {
        @Override
        public void defineProperties(BaseBlock baseBlock) {
        }

        @Override
        public IBlockState onBlockPlaced(Block block, World world, BlockPos blockPos, EnumFacing enumFacing, float f, float f2, float f3, IBlockState iBlockState, EntityLivingBase entityLivingBase) {
            return iBlockState;
        }

        @Override
        public Trans3 localToGlobalTransformation(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, Vector3 vector3) {
            return new Trans3(vector3);
        }
    }

    public static interface IOrientationHandler {
        public void defineProperties(BaseBlock var1);

        public IBlockState onBlockPlaced(Block var1, World var2, BlockPos var3, EnumFacing var4, float var5, float var6, float var7, IBlockState var8, EntityLivingBase var9);

        public Trans3 localToGlobalTransformation(IBlockAccess var1, BlockPos var2, IBlockState var3, Vector3 var4);
    }
}

