/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import gcewing.architecture.BaseRenderTarget;
import gcewing.architecture.Vector3;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import net.minecraft.client.renderer.block.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import org.lwjgl.util.vector.Vector3f;

public class BaseBakedRenderTarget
extends BaseRenderTarget {
    protected static VertexFormat theFormat = new VertexFormat();
    protected static List<BakedQuad> emptyQuads;
    protected static Map<EnumFacing, List<BakedQuad>> faceQuads;
    protected VertexFormat format = theFormat;
    protected int bytesPerVertex = this.format.func_177338_f();
    protected int intsPerVertex = this.bytesPerVertex / 4;
    protected ByteBuffer buf = ByteBuffer.allocate(this.bytesPerVertex * 4);
    protected List<BakedQuad> quads = new ArrayList<BakedQuad>();
    protected static ItemTransformVec3f transThirdPerson;
    protected static ItemTransformVec3f transFirstPerson;
    protected static ItemTransformVec3f transOnHead;
    protected static ItemTransformVec3f transInGui;
    protected static ItemTransformVec3f transOnGround;
    protected static ItemTransformVec3f transFixed;
    protected static ItemCameraTransforms transforms;

    public BaseBakedRenderTarget() {
        this(0.0, 0.0, 0.0, null);
    }

    public BaseBakedRenderTarget(BlockPos blockPos) {
        this(blockPos, null);
    }

    public BaseBakedRenderTarget(TextureAtlasSprite textureAtlasSprite) {
        this(0.0, 0.0, 0.0, textureAtlasSprite);
    }

    public BaseBakedRenderTarget(BlockPos blockPos, TextureAtlasSprite textureAtlasSprite) {
        this(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), textureAtlasSprite);
    }

    public BaseBakedRenderTarget(double d, double d2, double d3, TextureAtlasSprite textureAtlasSprite) {
        super(d, d2, d3, textureAtlasSprite);
    }

    @Override
    protected void setMode(int n) {
        super.setMode(n);
        this.buf.clear();
    }

    @Override
    public void endFace() {
        int n;
        super.endFace();
        this.buf.flip();
        int n2 = this.intsPerVertex * 4;
        int[] nArray = new int[n2];
        IntBuffer intBuffer = this.buf.asIntBuffer();
        intBuffer.get(nArray, 0, n);
        for (n = intBuffer.limit(); n < n2; ++n) {
            nArray[n] = nArray[n - this.intsPerVertex];
        }
        this.prescrambleVertexColors(nArray);
        this.quads.add(new BakedQuad(nArray, 0, EnumFacing.UP, null));
    }

    protected void dumpVertexData(int[] nArray, int n) {
        System.out.printf("BaseBakedRenderTarget.endFace: Vertex data:\n", new Object[0]);
        for (int i = 0; i < 4; ++i) {
            int n2 = i * this.intsPerVertex;
            System.out.printf("[%s] coords (%.3f,%.3f,%.3f) color %08x\n", i, Float.valueOf(Float.intBitsToFloat(nArray[n2])), Float.valueOf(Float.intBitsToFloat(nArray[n2 + 1])), Float.valueOf(Float.intBitsToFloat(nArray[n2 + 2])), nArray[n2 + 3]);
        }
    }

    protected void prescrambleVertexColors(int[] nArray) {
        int n;
        int[] nArray2 = new int[4];
        for (n = 0; n < 4; ++n) {
            nArray2[n] = nArray[n * this.intsPerVertex + 3];
        }
        for (n = 0; n < 4; ++n) {
            nArray[n * this.intsPerVertex + 3] = nArray2[3 - n];
        }
    }

    public IBakedModel getBakedModel() {
        return this.getBakedModel(null);
    }

    public IBakedModel getBakedModel(TextureAtlasSprite textureAtlasSprite) {
        if (this.verticesPerFace != 0) {
            throw new IllegalStateException("Rendering ended with incomplete face");
        }
        return new SimpleBakedModel(this.quads, faceQuads, false, true, textureAtlasSprite, transforms, ItemOverrideList.field_188022_a);
    }

    @Override
    protected void rawAddVertex(Vector3 vector3, double d, double d2) {
        block6: for (VertexFormatElement vertexFormatElement : this.format.func_177343_g()) {
            switch (vertexFormatElement.func_177375_c()) {
                case POSITION: {
                    this.putElement(vertexFormatElement, vector3.x, vector3.y, vector3.z);
                    continue block6;
                }
                case COLOR: {
                    this.putElement(vertexFormatElement, Float.valueOf(this.alpha), Float.valueOf(this.blue), Float.valueOf(this.green), Float.valueOf(this.red));
                    continue block6;
                }
                case NORMAL: {
                    this.putElement(vertexFormatElement, this.normal.x, this.normal.y, this.normal.z);
                    continue block6;
                }
                case UV: {
                    this.putElement(vertexFormatElement, d, d2);
                    continue block6;
                }
            }
            this.putElement(vertexFormatElement, new Number[0]);
        }
    }

    protected void putElement(VertexFormatElement vertexFormatElement, Number ... numberArray) {
        block9: for (int i = 0; i < vertexFormatElement.func_177370_d(); ++i) {
            Number number = i < numberArray.length ? (Number)numberArray[i] : (Number)0;
            switch (vertexFormatElement.func_177367_b()) {
                case BYTE: {
                    this.buf.put((byte)(number.floatValue() * 127.0f));
                    continue block9;
                }
                case UBYTE: {
                    this.buf.put((byte)(number.floatValue() * 255.0f));
                    continue block9;
                }
                case SHORT: {
                    this.buf.putShort((short)(number.floatValue() * 32767.0f));
                    continue block9;
                }
                case USHORT: {
                    this.buf.putShort((short)(number.floatValue() * 65535.0f));
                    continue block9;
                }
                case INT: {
                    this.buf.putInt((int)(number.doubleValue() * 2.147483647E9));
                    continue block9;
                }
                case UINT: {
                    this.buf.putInt((int)(number.doubleValue() * -1.0));
                    continue block9;
                }
                case FLOAT: {
                    this.buf.putFloat(number.floatValue());
                }
            }
        }
    }

    static {
        theFormat.func_181721_a(DefaultVertexFormats.field_181713_m);
        theFormat.func_181721_a(DefaultVertexFormats.field_181714_n);
        theFormat.func_181721_a(DefaultVertexFormats.field_181715_o);
        theFormat.func_181721_a(DefaultVertexFormats.field_181718_r);
        theFormat.func_181721_a(DefaultVertexFormats.field_181717_q);
        emptyQuads = new ArrayList<BakedQuad>();
        faceQuads = new HashMap<EnumFacing, List<BakedQuad>>();
        for (EnumFacing enumFacing : EnumFacing.field_82609_l) {
            faceQuads.put(enumFacing, emptyQuads);
        }
        transThirdPerson = new ItemTransformVec3f(new Vector3f(75.0f, -45.0f, 0.0f), new Vector3f(0.0f, 0.15625f, 0.0f), new Vector3f(0.375f, 0.375f, 0.375f));
        transFirstPerson = new ItemTransformVec3f(new Vector3f(0.0f, -45.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.4f, 0.4f, 0.4f));
        transOnHead = new ItemTransformVec3f(new Vector3f(0.0f, 180.0f, 0.0f), new Vector3f(0.0f, 0.8125f, 0.4375f), new Vector3f(1.0f, 1.0f, 1.0f));
        transInGui = new ItemTransformVec3f(new Vector3f(30.0f, -45.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.625f, 0.625f, 0.625f));
        transOnGround = new ItemTransformVec3f(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.1875f, 0.0f), new Vector3f(0.25f, 0.25f, 0.25f));
        transFixed = new ItemTransformVec3f(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.5f, 0.5f, 0.5f));
        transforms = new ItemCameraTransforms(transThirdPerson, transThirdPerson, transFirstPerson, transFirstPerson, transOnHead, transInGui, transOnGround, transFixed);
    }
}

