/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import gcewing.architecture.BaseBakedRenderTarget;
import gcewing.architecture.BaseModClient;
import gcewing.architecture.BaseReflectionUtils;
import gcewing.architecture.BaseRenderingManager;
import gcewing.architecture.BaseWorldRenderTarget;
import gcewing.architecture.Trans3;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.MinecraftForgeClient;

public class BaseAORenderingManager
extends BaseRenderingManager {
    public BaseAORenderingManager(BaseModClient baseModClient) {
        super(baseModClient);
    }

    @Override
    protected void enableCustomRendering() {
        super.enableCustomRendering();
        Minecraft minecraft = Minecraft.func_71410_x();
        this.blockRendererDispatcher = new CustomBlockRendererDispatcher(this.blockRendererDispatcher);
        BaseReflectionUtils.setField(minecraft, "blockRenderDispatcher", "field_175618_aM", this.blockRendererDispatcher);
    }

    protected class CustomBlockRendererDispatcher
    extends BlockRendererDispatcher {
        protected BlockRendererDispatcher base;

        public CustomBlockRendererDispatcher(BlockRendererDispatcher blockRendererDispatcher) {
            super(null, null);
            this.base = blockRendererDispatcher;
        }

        public BlockModelShapes func_175023_a() {
            return this.base.func_175023_a();
        }

        public BlockModelRenderer func_175019_b() {
            return this.base.func_175019_b();
        }

        public IBakedModel func_184389_a(IBlockState iBlockState) {
            return this.base.func_184389_a(iBlockState);
        }

        public void func_175016_a(IBlockState iBlockState, float f) {
            this.base.func_175016_a(iBlockState, f);
        }

        public void func_175020_a(IBlockState iBlockState, BlockPos blockPos, TextureAtlasSprite textureAtlasSprite, IBlockAccess iBlockAccess) {
            BaseModClient.ICustomRenderer iCustomRenderer = BaseAORenderingManager.this.getCustomRenderer(iBlockAccess, blockPos, iBlockState);
            if (iCustomRenderer != null) {
                BaseBakedRenderTarget baseBakedRenderTarget = new BaseBakedRenderTarget(blockPos, textureAtlasSprite);
                Trans3 trans3 = Trans3.blockCenter;
                Block block = iBlockState.func_177230_c();
                for (BlockRenderLayer blockRenderLayer : BlockRenderLayer.values()) {
                    if (!block.canRenderInLayer(blockRenderLayer)) continue;
                    iCustomRenderer.renderBlock(iBlockAccess, blockPos, iBlockState, baseBakedRenderTarget, blockRenderLayer, trans3);
                }
                IBakedModel iBakedModel = baseBakedRenderTarget.getBakedModel();
                VertexBuffer vertexBuffer = Tessellator.func_178181_a().func_178180_c();
                this.func_175019_b().func_178267_a(iBlockAccess, iBakedModel, iBlockState, blockPos, vertexBuffer, false);
            } else {
                this.base.func_175020_a(iBlockState, blockPos, textureAtlasSprite, iBlockAccess);
            }
        }

        public boolean func_175018_a(IBlockState iBlockState, BlockPos blockPos, IBlockAccess iBlockAccess, VertexBuffer vertexBuffer) {
            BaseModClient.ICustomRenderer iCustomRenderer = BaseAORenderingManager.this.getCustomRenderer(iBlockAccess, blockPos, iBlockState);
            if (iCustomRenderer != null) {
                return this.customRenderBlockToWorld(iBlockAccess, blockPos, iBlockState, vertexBuffer, null, iCustomRenderer);
            }
            return this.base.func_175018_a(iBlockState, blockPos, iBlockAccess, vertexBuffer);
        }

        protected boolean customRenderBlockToWorld(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, VertexBuffer vertexBuffer, TextureAtlasSprite textureAtlasSprite, BaseModClient.ICustomRenderer iCustomRenderer) {
            BaseWorldRenderTarget baseWorldRenderTarget = new BaseWorldRenderTarget(iBlockAccess, blockPos, vertexBuffer, textureAtlasSprite);
            BlockRenderLayer blockRenderLayer = MinecraftForgeClient.getRenderLayer();
            iCustomRenderer.renderBlock(iBlockAccess, blockPos, iBlockState, baseWorldRenderTarget, blockRenderLayer, Trans3.blockCenter(blockPos));
            return baseWorldRenderTarget.end();
        }
    }
}

