/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.item;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class NameMapper {
    private final Table<String, Integer, NameData> table = HashBasedTable.create();
    private final String modId;

    public NameMapper(String modId) {
        this.modId = modId.toLowerCase().trim();
    }

    public void add(String nameId, int damage, ResourceLocation location, String unlocalized) {
        this.add(nameId, damage, location.func_110624_b(), "", location.func_110623_a(), unlocalized);
    }

    public void add(String nameId, int damage, String directory, String model, String unlocalized) {
        this.add(nameId, damage, this.modId, directory, model, unlocalized);
    }

    public void add(String nameId, int damage, String modId, String directory, String model, String unlocalized) {
        this.add(nameId, damage, new NameData(modId + ":" + directory, model, unlocalized));
    }

    public void add(String nameId, int damage, NameData data) {
        nameId = nameId.toLowerCase().trim();
        this.table.put((Object)nameId, (Object)damage, (Object)data);
    }

    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation[] getAllModelsFor(String name) {
        if (this.table.containsRow((Object)(name = name.toLowerCase().trim()))) {
            ArrayList<ModelResourceLocation> names = new ArrayList<ModelResourceLocation>();
            for (NameData data : this.table.row((Object)name).values()) {
                names.add(data.getResource());
            }
            return names.toArray(new ModelResourceLocation[names.size()]);
        }
        return new ModelResourceLocation[0];
    }

    public Map<Integer, NameData> getAllDataFor(String name) {
        if (this.table.containsRow((Object)(name = name.toLowerCase().trim()))) {
            return this.table.row((Object)name);
        }
        return Collections.emptyMap();
    }

    public String getUnlocalizedNameFor(String name, int damage) {
        if (this.table.contains((Object)(name = name.toLowerCase().trim()), (Object)damage)) {
            return ((NameData)this.table.get((Object)name, (Object)damage)).getUnlocalizedName();
        }
        return "info.shetiphian.unused";
    }

    public static class NameData {
        private final String directory;
        private final String model;
        private final String unlocalized;

        public NameData(String directory, String model, String unlocalized) {
            this.directory = directory.toLowerCase().trim();
            this.model = model.toLowerCase().trim();
            this.unlocalized = unlocalized.toLowerCase().trim();
        }

        public String getModel() {
            return this.directory + this.model;
        }

        public String getModelName() {
            return this.model;
        }

        public String getUnlocalizedName() {
            return this.unlocalized;
        }

        @SideOnly(value=Side.CLIENT)
        public ModelResourceLocation getResource() {
            String name = this.getModel();
            if (name.contains("#")) {
                return new ModelResourceLocation(name);
            }
            return new ModelResourceLocation(name, "inventory");
        }
    }
}

