/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import shetiphian.core.ShetiPhianCore;
import shetiphian.core.internal.modintegration.ftblib.FTBLib_Base;

public class Function {
    public static final String[] dyeNamesWB = new String[]{"dyeWhite", "dyeOrange", "dyeMagenta", "dyeLightBlue", "dyeYellow", "dyeLime", "dyePink", "dyeGray", "dyeLightGray", "dyeCyan", "dyePurple", "dyeBlue", "dyeBrown", "dyeGreen", "dyeRed", "dyeBlack"};
    public static final String[] dyeNamesBW = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};
    private static final HashMap<String, List<ItemStack>> cache = new HashMap();
    public static Random random = new Random();

    public static boolean setBlock(World world, BlockPos pos, IBlockState state, boolean notify) {
        int update = notify ? 3 : 2;
        return world.func_180501_a(pos, state, update);
    }

    public static void removeBlock(World world, BlockPos pos, boolean notify) {
        if (notify) {
            world.func_175698_g(pos);
        } else {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
        }
        world.func_175713_t(pos);
    }

    public static void syncTile(TileEntity tile) {
        tile.func_70296_d();
        IBlockState state = tile.func_145838_q().func_176203_a(tile.func_145832_p());
        Function.sync(tile.func_145831_w(), tile.func_174877_v(), state);
    }

    public static void sync(World world, BlockPos pos, IBlockState state) {
        world.func_184138_a(pos, state, state, 3);
    }

    public static void updateLighting(TileEntity tile) {
        tile.func_145831_w().func_180500_c(EnumSkyBlock.BLOCK, tile.func_174877_v());
        IBlockState state = tile.func_145838_q().func_176203_a(tile.func_145832_p());
        Function.sync(tile.func_145831_w(), tile.func_174877_v(), state);
    }

    public static Block getBlockDown(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_177230_c();
    }

    public static int[] getBlockXZ(double posX, double posZ) {
        int blockX = (int)posX;
        int blockZ = (int)posZ;
        if (posX - (double)((int)posX) < 0.0) {
            --blockX;
        }
        if (posZ - (double)((int)posZ) < 0.0) {
            // empty if block
        }
        return new int[]{blockX, --blockZ};
    }

    public static boolean giveItem(EntityPlayer player, ItemStack stack) {
        return Function.giveItem(player, stack, SoundEvents.field_187638_cR);
    }

    public static boolean giveItem(EntityPlayer player, ItemStack stack, SoundEvent sound) {
        if (!player.field_71071_by.func_70441_a(stack)) {
            Function.dropItem(player.field_70170_p, new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v), stack);
            return false;
        }
        if (sound != null) {
            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, sound, player.func_184176_by(), 0.2f, ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
        return true;
    }

    public static void dropItem(World world, BlockPos pos, ItemStack stack) {
        if (!world.field_72995_K && stack != null) {
            double rndX = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            double rndY = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            double rndZ = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + rndX, (double)pos.func_177956_o() + rndY, (double)pos.func_177952_p() + rndZ, stack);
            entityItem.func_174867_a(10);
            if (stack.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d(stack.func_77978_p().func_74737_b());
            }
            world.func_72838_d((Entity)entityItem);
        }
    }

    public static ItemStack findItemStack(String modId, String name, int stackSize) {
        ItemStack foundStack = Function.findItemStack(modId, name);
        if (foundStack != null && foundStack.func_77973_b() != null) {
            ItemStack stack = foundStack.func_77946_l();
            stack.field_77994_a = Math.min(stackSize, stack.func_77976_d());
            return stack;
        }
        return null;
    }

    public static ItemStack findItemStack(String modId, String name) {
        Item item = GameRegistry.findItem((String)modId, (String)name);
        if (item != null) {
            return new ItemStack(item, 1, 0);
        }
        Block block = GameRegistry.findBlock((String)modId, (String)name);
        if (block != null) {
            ItemStack stack = new ItemStack(block, 1, Short.MAX_VALUE);
            return stack.func_77973_b() != null ? stack : null;
        }
        return null;
    }

    public static boolean areItemStacksEqual(ItemStack stackA, ItemStack stackB) {
        return Function.areItemStacksEqual(stackA, stackB, false);
    }

    public static boolean areItemStacksEqual(ItemStack stackA, ItemStack stackB, boolean excludeNBT) {
        boolean areEqual;
        if (stackA == null && stackB == null) {
            return true;
        }
        if (stackA == null || stackB == null) {
            return false;
        }
        boolean bl = areEqual = stackA.func_77973_b() == stackB.func_77973_b() && (stackA.func_77952_i() == stackB.func_77952_i() || stackA.func_77952_i() == Short.MAX_VALUE || stackB.func_77952_i() == Short.MAX_VALUE);
        return excludeNBT ? areEqual : areEqual && ItemStack.func_77970_a((ItemStack)stackA, (ItemStack)stackB);
    }

    public static boolean areFluidStacksEqual(FluidStack stackA, FluidStack stackB) {
        return stackA == null && stackB == null || stackA != null && stackB != null && stackA.isFluidEqual(stackB);
    }

    public static List<ItemStack> getOres(String name) {
        if (!cache.containsKey(name)) {
            cache.put(name, OreDictionary.getOres((String)name));
        }
        return cache.get(name);
    }

    public static ItemStack getOre(String name, int ... stackSize) {
        List<ItemStack> results;
        int amount;
        int n = amount = stackSize != null && stackSize.length > 0 ? stackSize[0] : 1;
        if (amount > 0 && (results = Function.getOres(name)) != null && !results.isEmpty()) {
            ItemStack stack = results.get(0);
            stack.field_77994_a = amount;
            return stack;
        }
        return null;
    }

    public static void attemptAdd(List<ItemStack> list, ItemStack itemStack) {
        if (itemStack != null && itemStack.field_77994_a > 0) {
            list.add(itemStack);
        }
    }

    public static String getEntityName(EntityLivingBase entity) {
        return entity.func_145748_c_().func_150260_c();
    }

    public static String getEntityName(ICommandSender sender) {
        return sender.func_145748_c_().func_150260_c();
    }

    public static boolean isOP(EntityPlayer player) {
        MinecraftServer server = player.field_70170_p.func_73046_m();
        if (server == null) {
            server = FMLCommonHandler.instance().getMinecraftServerInstance();
        }
        if (server == null) {
            return ShetiPhianCore.proxy.isClientOp(player);
        }
        if (server.func_71264_H() && player.field_71075_bZ.field_75098_d) {
            return true;
        }
        String[] ops = null;
        try {
            ops = server.func_184103_al().func_152603_m().func_152685_a();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ops != null) {
            for (String op : ops) {
                if (!op.equals(player.getDisplayNameString())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isCreativeOP(EntityPlayer player) {
        return player.field_71075_bZ.field_75098_d && Function.isOP(player);
    }

    public static String getPlayerTeamID(EntityPlayer player) {
        if (player != null) {
            Team team;
            String teamID = FTBLib_Base.INSTANCE.getPlayerTeamID(player);
            if (Strings.isNullOrEmpty((String)teamID) && (team = player.func_96124_cp()) != null) {
                return team.func_96661_b();
            }
            return teamID;
        }
        return "";
    }

    public static String getTeamDisplayName(String teamID) {
        if (!Strings.isNullOrEmpty((String)teamID)) {
            Scoreboard scoreboard;
            String teamName = FTBLib_Base.INSTANCE.getTeamName(teamID);
            if (Strings.isNullOrEmpty((String)teamName) && (scoreboard = ShetiPhianCore.proxy.getScoreboard()) != null) {
                for (ScorePlayerTeam team : scoreboard.func_96525_g()) {
                    if (team == null || !team.func_96661_b().equalsIgnoreCase(teamID)) continue;
                    return team.func_96669_c();
                }
            }
            return teamName;
        }
        return teamID;
    }

    public static RayTraceResult fakeMOP(World world, BlockPos pos, EnumFacing face) {
        Vec3d vec3 = new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        return new RayTraceResult(vec3, face, pos);
    }

    public static RayTraceResult rayTrace(EntityPlayer player, double blockReachDistance, float partialTicks) {
        Vec3d vecStart;
        if (partialTicks == 1.0f) {
            vecStart = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        } else {
            double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTicks;
            double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTicks + (double)player.func_70047_e();
            double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTicks;
            vecStart = new Vec3d(d0, d1, d2);
        }
        Vec3d vecLook = player.func_70676_i(partialTicks);
        Vec3d vecEnd = vecStart.func_72441_c(vecLook.field_72450_a * blockReachDistance, vecLook.field_72448_b * blockReachDistance, vecLook.field_72449_c * blockReachDistance);
        return player.field_70170_p.func_147447_a(vecStart, vecEnd, false, false, true);
    }

    public static Entity getEntityInFront(World world, EntityPlayer player, double distance) {
        if (player == null || world == null || distance < 1.0) {
            return null;
        }
        Vec3d vecStart = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        Vec3d vecLook = player.func_70676_i(1.0f);
        Vec3d vecEnd = vecStart.func_72441_c(vecLook.field_72450_a * distance, vecLook.field_72448_b * distance, vecLook.field_72449_c * distance);
        EntityLiving theTarget = null;
        float closestHit = Float.POSITIVE_INFINITY;
        List entityList = player.field_70170_p.func_72872_a(EntityLiving.class, new AxisAlignedBB(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70165_t + 1.0, player.field_70163_u + 1.0, player.field_70161_v + 1.0).func_72314_b(distance, distance, distance));
        if (entityList.isEmpty()) {
            return null;
        }
        for (EntityLiving entity : entityList) {
            float currentHit;
            RayTraceResult intercept;
            AxisAlignedBB boundingBox;
            if (!entity.func_70067_L() || (boundingBox = entity.func_174813_aQ()) == null || (intercept = boundingBox.func_72327_a(vecStart, vecEnd)) == null || !((currentHit = (float)intercept.field_72307_f.func_72438_d(vecStart)) < closestHit) && currentHit != 0.0f) continue;
            closestHit = currentHit;
            theTarget = entity;
        }
        return theTarget;
    }

    public static BlockInfo getBlockInfront(World world, EntityPlayer player, double reach) {
        RayTraceResult mop = Function.getMovingObjectPositionFromPlayer(world, player, true, reach);
        if (mop != null && mop.field_72313_a == RayTraceResult.Type.BLOCK) {
            return new BlockInfo(world, mop);
        }
        return null;
    }

    private static RayTraceResult getMovingObjectPositionFromPlayer(World world, EntityPlayer player, boolean includeLiquids, double reach) {
        if (player == null || world == null || reach < 1.0) {
            return null;
        }
        Vec3d vecStart = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        Vec3d vecLook = player.func_70676_i(1.0f);
        Vec3d vecEnd = vecStart.func_72441_c(vecLook.field_72450_a * reach, vecLook.field_72448_b * reach, vecLook.field_72449_c * reach);
        return world.func_147447_a(vecStart, vecEnd, includeLiquids, false, true);
    }

    public static class BlockInfo {
        public final BlockPos pos;
        public final IBlockState state;
        public final Block block;
        public final EnumFacing face;
        public final int sub;
        public final Vec3d vec;

        public BlockInfo(World world, RayTraceResult mop) {
            this.pos = mop.func_178782_a();
            this.state = world.func_180495_p(this.pos);
            this.block = this.state.func_177230_c();
            this.face = mop.field_178784_b;
            this.sub = mop.subHit;
            this.vec = mop.field_72307_f;
        }

        public String toString() {
            return "POS: " + this.pos + " -State: " + this.state + " -SideHit: " + this.face + " -SubHit: " + this.sub + " -HitVec: " + this.vec;
        }
    }
}

