/*
 * Decompiled with CFR 0.152.
 */
package mcjty.intwheel.varia;

import java.util.Map;
import java.util.Optional;
import java.util.Random;
import mcjty.lib.tools.ItemStackList;
import mcjty.lib.tools.ItemStackTools;
import mcjty.lib.tools.WorldTools;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class InventoryHelper {
    private final TileEntity tileEntity;
    private ItemStackList stacks;
    private int count;
    private static final Random random = new Random();

    public InventoryHelper(TileEntity tileEntity, int count) {
        this.tileEntity = tileEntity;
        this.stacks = ItemStackList.create((int)count);
        this.count = count;
    }

    public static Optional<IInventory> getInventory(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IInventory) {
            return Optional.of((IInventory)te);
        }
        return Optional.empty();
    }

    public static void giveItemToPlayer(EntityPlayer player, ItemStack stack) {
        ItemStack heldItem = player.func_184586_b(EnumHand.MAIN_HAND);
        if (ItemStackTools.isEmpty((ItemStack)heldItem)) {
            player.func_184611_a(EnumHand.MAIN_HAND, stack);
            player.field_71070_bA.func_75142_b();
            return;
        }
        if (InventoryHelper.isItemStackConsideredEqual(heldItem, stack) && ItemStackTools.getStackSize((ItemStack)heldItem) < heldItem.func_77976_d()) {
            int itemsToAdd = Math.min(ItemStackTools.getStackSize((ItemStack)stack), heldItem.func_77976_d() - ItemStackTools.getStackSize((ItemStack)heldItem));
            ItemStackTools.incStackSize((ItemStack)heldItem, (int)itemsToAdd);
            ItemStackTools.incStackSize((ItemStack)stack, (int)(-itemsToAdd));
            if (ItemStackTools.isEmpty((ItemStack)stack)) {
                player.field_71070_bA.func_75142_b();
                return;
            }
        }
        if (player.field_71071_by.func_70441_a(stack)) {
            player.field_71070_bA.func_75142_b();
            return;
        }
        InventoryHelper.spawnItemStack(player.func_130014_f_(), player.func_180425_c(), stack);
    }

    public static void emptyInventoryInWorld(World world, BlockPos pos, Block block, IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemstack = inventory.func_70301_a(i);
            InventoryHelper.spawnItemStack(world, pos, itemstack);
            inventory.func_70299_a(i, ItemStackTools.getEmptyStack());
        }
        world.func_175666_e(pos, block);
    }

    public static void spawnItemStack(World world, BlockPos c, ItemStack itemStack) {
        InventoryHelper.spawnItemStack(world, c.func_177958_n(), c.func_177956_o(), c.func_177952_p(), itemStack);
    }

    public static void spawnItemStack(World world, int x, int y, int z, ItemStack itemstack) {
        if (ItemStackTools.isValid((ItemStack)itemstack)) {
            float f = random.nextFloat() * 0.8f + 0.1f;
            float f1 = random.nextFloat() * 0.8f + 0.1f;
            float f2 = random.nextFloat() * 0.8f + 0.1f;
            while (ItemStackTools.isValid((ItemStack)itemstack)) {
                int j = random.nextInt(21) + 10;
                if (j > ItemStackTools.getStackSize((ItemStack)itemstack)) {
                    j = ItemStackTools.getStackSize((ItemStack)itemstack);
                }
                ItemStack toSpawn = itemstack.func_77979_a(j);
                EntityItem entityitem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), toSpawn);
                float f3 = 0.05f;
                entityitem.field_70159_w = (float)random.nextGaussian() * f3;
                entityitem.field_70181_x = (float)random.nextGaussian() * f3 + 0.2f;
                entityitem.field_70179_y = (float)random.nextGaussian() * f3;
                WorldTools.spawnEntity((World)world, (Entity)entityitem);
            }
        }
    }

    public void setNewCount(int newcount) {
        this.count = newcount;
        ItemStackList newstacks = ItemStackList.create((int)newcount);
        for (int i = 0; i < Math.min(this.stacks.size(), newstacks.size()); ++i) {
            newstacks.add(this.stacks.get(i));
        }
        this.stacks = newstacks;
    }

    public static int mergeItemStackSafe(IInventory inventory, EnumFacing side, ItemStack result, int start, int stop, Map<Integer, ItemStack> undo) {
        if (inventory instanceof ISidedInventory) {
            return InventoryHelper.mergeItemStackInternal(inventory, (ISidedInventory)inventory, side, result, start, stop, undo);
        }
        return InventoryHelper.mergeItemStackInternal(inventory, null, side, result, start, stop, undo);
    }

    public static int mergeItemStack(IInventory inventory, ItemStack result, int start, int stop, Map<Integer, ItemStack> undo) {
        return InventoryHelper.mergeItemStackInternal(inventory, null, null, result, start, stop, undo);
    }

    private static int mergeItemStackInternal(IInventory inventory, ISidedInventory sidedInventory, EnumFacing side, ItemStack result, int start, int stop, Map<Integer, ItemStack> undo) {
        int k;
        ItemStack itemstack1 = ItemStackTools.getEmptyStack();
        int itemsToPlace = ItemStackTools.getStackSize((ItemStack)result);
        if (result.func_77985_e()) {
            for (k = start; itemsToPlace > 0 && k < stop; ++k) {
                itemstack1 = inventory.func_70301_a(k);
                if (!InventoryHelper.isItemStackConsideredEqual(result, itemstack1) || sidedInventory != null && !sidedInventory.func_180462_a(k, result, side)) continue;
                int l = ItemStackTools.getStackSize((ItemStack)itemstack1) + itemsToPlace;
                if (l <= result.func_77976_d()) {
                    if (undo != null && !undo.containsKey(k)) {
                        undo.put(k, itemstack1.func_77946_l());
                    }
                    itemsToPlace = 0;
                    ItemStackTools.setStackSize((ItemStack)itemstack1, (int)l);
                    inventory.func_70296_d();
                    continue;
                }
                if (ItemStackTools.getStackSize((ItemStack)itemstack1) >= result.func_77976_d()) continue;
                if (undo != null && !undo.containsKey(k)) {
                    undo.put(k, itemstack1.func_77946_l());
                }
                itemsToPlace -= result.func_77976_d() - ItemStackTools.getStackSize((ItemStack)itemstack1);
                ItemStackTools.setStackSize((ItemStack)itemstack1, (int)result.func_77976_d());
                inventory.func_70296_d();
            }
        }
        if (itemsToPlace > 0) {
            for (k = start; k < stop; ++k) {
                itemstack1 = inventory.func_70301_a(k);
                if (!ItemStackTools.isEmpty((ItemStack)itemstack1) || sidedInventory != null && !sidedInventory.func_180462_a(k, result, side)) continue;
                if (undo != null && !undo.containsKey(k)) {
                    undo.put(k, ItemStackTools.getEmptyStack());
                }
                ItemStack copy = result.func_77946_l();
                ItemStackTools.setStackSize((ItemStack)copy, (int)itemsToPlace);
                inventory.func_70299_a(k, copy);
                inventory.func_70296_d();
                itemsToPlace = 0;
                break;
            }
        }
        return itemsToPlace;
    }

    public static boolean isItemStackConsideredEqual(ItemStack result, ItemStack itemstack1) {
        return ItemStackTools.isValid((ItemStack)itemstack1) && itemstack1.func_77973_b() == result.func_77973_b() && (!result.func_77981_g() || result.func_77952_i() == itemstack1.func_77952_i()) && ItemStack.func_77970_a((ItemStack)result, (ItemStack)itemstack1);
    }

    public int getCount() {
        return this.count;
    }

    public boolean hasStack(int index) {
        if (index >= this.stacks.size()) {
            return false;
        }
        return ItemStackTools.isValid((ItemStack)((ItemStack)this.stacks.get(index)));
    }

    public ItemStack getStackInSlot(int index) {
        if (index >= this.stacks.size()) {
            return ItemStackTools.getEmptyStack();
        }
        return (ItemStack)this.stacks.get(index);
    }

    public void setStackInSlot(int index, ItemStack stack) {
        if (index >= this.stacks.size()) {
            return;
        }
        this.stacks.set(index, (Object)stack);
    }

    public boolean containsItem(int index) {
        if (index >= this.stacks.size()) {
            return false;
        }
        return ItemStackTools.isValid((ItemStack)((ItemStack)this.stacks.get(index)));
    }

    public boolean isGhostSlot(int index) {
        return false;
    }

    public boolean isGhostOutputSlot(int index) {
        return false;
    }

    public ItemStack decrStackSize(int index, int amount) {
        if (index >= this.stacks.size()) {
            return ItemStackTools.getEmptyStack();
        }
        if (this.isGhostSlot(index) || this.isGhostOutputSlot(index)) {
            ItemStack old = (ItemStack)this.stacks.get(index);
            this.stacks.set(index, (Object)ItemStackTools.getEmptyStack());
            if (ItemStackTools.isEmpty((ItemStack)old)) {
                return ItemStackTools.getEmptyStack();
            }
            ItemStackTools.makeEmpty((ItemStack)old);
            return old;
        }
        if (ItemStackTools.isValid((ItemStack)((ItemStack)this.stacks.get(index)))) {
            if (ItemStackTools.getStackSize((ItemStack)((ItemStack)this.stacks.get(index))) <= amount) {
                ItemStack old = (ItemStack)this.stacks.get(index);
                this.stacks.set(index, (Object)ItemStackTools.getEmptyStack());
                this.tileEntity.func_70296_d();
                return old;
            }
            ItemStack its = ((ItemStack)this.stacks.get(index)).func_77979_a(amount);
            if (ItemStackTools.isEmpty((ItemStack)((ItemStack)this.stacks.get(index)))) {
                this.stacks.set(index, (Object)ItemStackTools.getEmptyStack());
            }
            this.tileEntity.func_70296_d();
            return its;
        }
        return ItemStackTools.getEmptyStack();
    }

    public void setInventorySlotContents(int stackLimit, int index, ItemStack stack) {
        if (index >= this.stacks.size()) {
            return;
        }
        if (this.isGhostSlot(index)) {
            if (ItemStackTools.isValid((ItemStack)stack)) {
                this.stacks.set(index, (Object)stack.func_77946_l());
                if (index < 9) {
                    ItemStackTools.setStackSize((ItemStack)((ItemStack)this.stacks.get(index)), (int)1);
                }
            } else {
                this.stacks.set(index, (Object)ItemStackTools.getEmptyStack());
            }
        } else if (this.isGhostOutputSlot(index)) {
            if (ItemStackTools.isValid((ItemStack)stack)) {
                this.stacks.set(index, (Object)stack.func_77946_l());
            } else {
                this.stacks.set(index, (Object)ItemStackTools.getEmptyStack());
            }
        } else {
            this.stacks.set(index, (Object)stack);
            if (ItemStackTools.isValid((ItemStack)stack) && ItemStackTools.getStackSize((ItemStack)stack) > stackLimit) {
                ItemStackTools.setStackSize((ItemStack)stack, (int)stackLimit);
            }
            this.tileEntity.func_70296_d();
        }
    }

    public static void compactStacks(InventoryHelper helper, int start, int max) {
        InventoryHelper.compactStacks(helper.stacks, start, max);
    }

    public static void compactStacks(ItemStackList stacks, int start, int max) {
        ItemStack stack;
        int i;
        InventoryBasic inv = new InventoryBasic("temp", true, max);
        for (i = 0; i < max; ++i) {
            stack = (ItemStack)stacks.get(i + start);
            if (!ItemStackTools.isValid((ItemStack)stack)) continue;
            InventoryHelper.mergeItemStack((IInventory)inv, stack, 0, max, null);
        }
        for (i = 0; i < max; ++i) {
            stack = inv.func_70301_a(i);
            if (ItemStackTools.isValid((ItemStack)stack) && ItemStackTools.getStackSize((ItemStack)stack) == 0) {
                stack = ItemStackTools.getEmptyStack();
            }
            stacks.set(i + start, (Object)stack);
        }
    }
}

