/*
 * Decompiled with CFR 0.152.
 */
package mcjty.intwheel.network;

import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Set;
import mcjty.intwheel.InteractionWheel;
import mcjty.intwheel.RenderHandler;
import mcjty.intwheel.network.NetworkTools;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PackedInventoriesToClient
implements IMessage {
    private Set<BlockPos> positions;

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        this.positions = new HashSet<BlockPos>(size);
        for (int i = 0; i < size; ++i) {
            this.positions.add(NetworkTools.readPos(buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.positions.size());
        for (BlockPos pos : this.positions) {
            NetworkTools.writePos(buf, pos);
        }
    }

    public PackedInventoriesToClient() {
    }

    public PackedInventoriesToClient(Set<BlockPos> positions) {
        this.positions = new HashSet<BlockPos>(positions);
    }

    public static class Handler
    implements IMessageHandler<PackedInventoriesToClient, IMessage> {
        public IMessage onMessage(PackedInventoriesToClient message, MessageContext ctx) {
            InteractionWheel.proxy.addScheduledTaskClient(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PackedInventoriesToClient message, MessageContext ctx) {
            RenderHandler.foundPositions = message.positions;
            RenderHandler.time = System.currentTimeMillis() + 5000L;
        }
    }
}

