/*
 * Decompiled with CFR 0.152.
 */
package mcjty.intwheel.apiimp;

import java.util.HashSet;
import java.util.Set;
import mcjty.intwheel.api.IWheelAction;
import mcjty.intwheel.api.StandardWheelActions;
import mcjty.intwheel.api.WheelActionElement;
import mcjty.intwheel.varia.InventoryHelper;
import mcjty.lib.tools.ItemStackTools;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;

public class DumpSimilarInventoryAction
implements IWheelAction {
    @Override
    public String getId() {
        return "std.dumpsimilarinv";
    }

    @Override
    public boolean performClient(EntityPlayer player, World world, BlockPos pos, boolean extended) {
        return true;
    }

    @Override
    public WheelActionElement createElement() {
        return StandardWheelActions.DUMPSIMILARINV.createElement();
    }

    @Override
    public boolean isDefaultEnabled() {
        return true;
    }

    private boolean isSimilar(IItemHandler handler, ItemStack stack) {
        Set<Integer> ores = this.getOres(stack);
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack s = handler.getStackInSlot(i);
            if (!this.matchStack(stack, ores, s)) continue;
            return true;
        }
        return false;
    }

    private boolean isSimilar(IInventory handler, ItemStack stack) {
        Set<Integer> ores = this.getOres(stack);
        for (int i = 0; i < handler.func_70302_i_(); ++i) {
            ItemStack s = handler.func_70301_a(i);
            if (!this.matchStack(stack, ores, s)) continue;
            return true;
        }
        return false;
    }

    private Set<Integer> getOres(ItemStack stack) {
        HashSet<Integer> ores = new HashSet<Integer>();
        for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
            ores.add(id);
        }
        return ores;
    }

    private boolean matchStack(ItemStack stack, Set<Integer> ores, ItemStack s) {
        if (ItemStackTools.isValid((ItemStack)s)) {
            if (s.func_77973_b() == stack.func_77973_b()) {
                return true;
            }
            if (!ores.isEmpty()) {
                int[] iDs;
                for (int d : iDs = OreDictionary.getOreIDs((ItemStack)s)) {
                    if (!ores.contains(d)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void performServer(EntityPlayer player, World world, BlockPos pos, boolean extended) {
        block4: {
            TileEntity te;
            block3: {
                te = world.func_175625_s(pos);
                if (te == null || !te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) break block3;
                IItemHandler inventory = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                    ItemStack stack = player.field_71071_by.func_70301_a(i);
                    if (!ItemStackTools.isValid((ItemStack)stack) || !this.isSimilar(inventory, stack)) continue;
                    stack = ItemHandlerHelper.insertItem((IItemHandler)inventory, (ItemStack)stack, (boolean)false);
                    player.field_71071_by.func_70299_a(i, stack);
                }
                break block4;
            }
            if (!(te instanceof IInventory)) break block4;
            IInventory inventory = (IInventory)te;
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (!ItemStackTools.isValid((ItemStack)stack) || !this.isSimilar(inventory, stack)) continue;
                int failed = InventoryHelper.mergeItemStackSafe(inventory, null, stack, 0, inventory.func_70302_i_(), null);
                if (failed > 0) {
                    ItemStack putBack = stack.func_77946_l();
                    ItemStackTools.setStackSize((ItemStack)putBack, (int)failed);
                    player.field_71071_by.func_70299_a(i, putBack);
                    continue;
                }
                player.field_71071_by.func_70299_a(i, ItemStackTools.getEmptyStack());
            }
        }
    }
}

