/*
 * Decompiled with CFR 0.152.
 */
package QuantumStorage.tile;

import QuantumStorage.config.ConfigQuantumStorage;
import QuantumStorage.init.ModBlocks;
import QuantumStorage.tile.prefab.TileQuantumStorage;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import reborncore.api.IListInfoProvider;
import reborncore.common.network.INetworkPacket;
import reborncore.common.network.packet.CustomDescriptionPacket;
import reborncore.common.util.Inventory;
import reborncore.common.util.Tank;

public class TileQuantumTank
extends TileQuantumStorage
implements IInventory,
IListInfoProvider,
ITickable,
IItemHandler {
    public int storage = ConfigQuantumStorage.tankMaxStorage;
    public Tank tank = new Tank("TileQuantumTank", this.storage, (TileEntity)this);
    public Inventory inventory = new Inventory(3, "TileQuantumTank", 1, (TileEntity)this);

    public void func_145839_a(NBTTagCompound tagCompound) {
        this.readFromNBTWithoutCoords(tagCompound);
        super.func_145839_a(tagCompound);
    }

    public void readFromNBTWithoutCoords(NBTTagCompound tagCompound) {
        this.tank.readFromNBT(tagCompound);
        this.inventory.readFromNBT(tagCompound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        this.writeToNBTWithoutCoords(compound);
        return super.func_189515_b(compound);
    }

    public void writeToNBTWithoutCoords(NBTTagCompound tagCompound) {
        this.tank.writeToNBT(tagCompound);
        this.inventory.writeToNBT(tagCompound);
    }

    public Packet getDescriptionPacket() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_189515_b(nbtTag);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            this.emptyContainer();
            this.fillContainer();
            this.tank.compareAndUpdate();
        }
    }

    public void emptyContainer() {
        if (FluidUtil.tryEmptyContainerAndStow((ItemStack)this.func_70301_a(0), (IFluidHandler)this.tank, (IItemHandler)this, (int)1000, null)) {
            this.moveStack(0, 1);
            this.syncWithAll();
        }
    }

    public void fillContainer() {
        if (FluidUtil.tryFillContainerAndStow((ItemStack)this.func_70301_a(0), (IFluidHandler)this.tank, (IItemHandler)this, (int)1000, null)) {
            this.moveStack(0, 1);
            this.syncWithAll();
        }
    }

    public boolean moveStack(int from, int to) {
        ItemStack stackToMove = this.func_70301_a(from).func_77946_l();
        if (stackToMove != null && this.func_70301_a(to) == null) {
            this.func_70299_a(from, null);
            this.func_70299_a(to, stackToMove);
            return true;
        }
        return false;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tank;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)new InvWrapper((IInventory)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public int getSlots() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        return null;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return null;
    }

    public ItemStack func_70298_a(int slotId, int count) {
        ItemStack stack = this.inventory.func_70298_a(slotId, count);
        this.syncWithAll();
        return stack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory.func_70299_a(slot, stack);
        this.syncWithAll();
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.inventory.func_70300_a(player);
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return this.inventory.func_94041_b(slot, stack);
    }

    public ItemStack getDropWithNBT() {
        NBTTagCompound tileEntity = new NBTTagCompound();
        ItemStack dropStack = new ItemStack(ModBlocks.QuantumTank, 1);
        this.writeToNBTWithoutCoords(tileEntity);
        dropStack.func_77982_d(new NBTTagCompound());
        dropStack.func_77978_p().func_74782_a("tileEntity", (NBTBase)tileEntity);
        return dropStack;
    }

    public void addInfo(List<String> info, boolean isRealTile) {
        if (isRealTile) {
            if (this.tank.getFluid() != null) {
                info.add(this.tank.getFluidAmount() + " of " + this.tank.getFluidType().getName());
            } else {
                info.add("Empty");
            }
        }
        info.add("Capacity " + this.tank.getCapacity() + " mb");
    }

    @Override
    public void addWailaInfo(List<String> info) {
        if (this.tank.getFluid() != null) {
            info.add(this.tank.getFluidAmount() + " of " + this.tank.getFluidType().getName());
        } else {
            info.add("Empty");
        }
        info.add("Capacity " + this.tank.getCapacity() + " mb");
    }

    public void syncWithAll() {
        if (!this.field_145850_b.field_72995_K) {
            reborncore.common.network.NetworkManager.sendToAllAround((INetworkPacket)new CustomDescriptionPacket((TileEntity)this), (NetworkRegistry.TargetPoint)new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 20.0));
        }
    }

    public String func_70005_c_() {
        return this.inventory.func_70005_c_();
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public ITextComponent func_145748_c_() {
        return this.inventory.func_145748_c_();
    }

    public ItemStack func_70304_b(int index) {
        return this.inventory.func_70304_b(index);
    }

    public void func_174889_b(EntityPlayer player) {
        this.inventory.func_174889_b(player);
    }

    public void func_174886_c(EntityPlayer player) {
        this.inventory.func_174886_c(player);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
        this.inventory.func_174887_a_(id);
    }

    public int func_174890_g() {
        return this.inventory.func_174890_g();
    }

    public void func_174888_l() {
    }
}

