/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.wct.util;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import p455w0rd.wct.api.IWirelessCraftingTerminalItem;
import p455w0rd.wct.init.ModGlobals;
import p455w0rd.wct.integration.Baubles;
import p455w0rd.wct.items.ItemMagnet;

public class WCTUtils {
    public static ItemStack getWirelessTerm(InventoryPlayer playerInv) {
        if (playerInv.field_70458_d.func_184614_ca() != null && playerInv.field_70458_d.func_184614_ca().func_77973_b() instanceof IWirelessCraftingTerminalItem) {
            return playerInv.field_70458_d.func_184614_ca();
        }
        ItemStack wirelessTerm = null;
        if (ModGlobals.Mods.BAUBLES.isLoaded()) {
            wirelessTerm = Baubles.getWCTBauble(playerInv.field_70458_d);
        }
        if (wirelessTerm == null) {
            int invSize = playerInv.func_70302_i_();
            if (invSize <= 0) {
                return null;
            }
            for (int i = 0; i < invSize; ++i) {
                ItemStack item = playerInv.func_70301_a(i);
                if (item == null || !(item.func_77973_b() instanceof IWirelessCraftingTerminalItem)) continue;
                wirelessTerm = item;
                break;
            }
        }
        return wirelessTerm;
    }

    public static ItemStack getMagnet(InventoryPlayer playerInv) {
        NBTTagList magnetSlot;
        ItemStack magnetItem;
        NBTTagCompound nbtTC;
        if (playerInv.field_70458_d.func_184614_ca() != null && playerInv.field_70458_d.func_184614_ca().func_77973_b() instanceof ItemMagnet) {
            return playerInv.field_70458_d.func_184614_ca();
        }
        ItemStack wirelessTerm = WCTUtils.getWirelessTerm(playerInv);
        if (wirelessTerm != null && wirelessTerm.func_77973_b() instanceof IWirelessCraftingTerminalItem && (nbtTC = wirelessTerm.func_77978_p()).func_74764_b("MagnetSlot") && (magnetItem = ItemStack.func_77949_a((NBTTagCompound)(magnetSlot = nbtTC.func_150295_c("MagnetSlot", 10)).func_150305_b(0))) != null && magnetItem.func_77973_b() instanceof ItemMagnet) {
            return magnetItem;
        }
        int invSize = playerInv.func_70302_i_();
        ItemStack magnetItem2 = null;
        if (invSize <= 0) {
            return null;
        }
        for (int i = 0; i < invSize; ++i) {
            ItemStack item = playerInv.func_70301_a(i);
            if (item == null || !(item.func_77973_b() instanceof ItemMagnet)) continue;
            magnetItem2 = item;
            break;
        }
        return magnetItem2;
    }

    public static boolean isMagnetInitialized(ItemStack magnetItem) {
        if (magnetItem != null && magnetItem.func_77973_b() instanceof ItemMagnet) {
            if (!magnetItem.func_77942_o()) {
                magnetItem.func_77982_d(new NBTTagCompound());
            }
            if (!magnetItem.func_77978_p().func_74764_b("Initialized")) {
                magnetItem.func_77978_p().func_74757_a("Initialized", true);
            }
        }
        return magnetItem.func_77978_p().func_74767_n("Initialized");
    }

    public static boolean isMagnetInstalled(InventoryPlayer ip) {
        ItemStack magnetItem;
        NBTTagCompound magnetNBTForm;
        return WCTUtils.getWirelessTerm(ip) != null && WCTUtils.getWirelessTerm(ip).func_77942_o() && WCTUtils.getWirelessTerm(ip).func_77978_p().func_74764_b("MagnetSlot") && (magnetNBTForm = WCTUtils.getWirelessTerm(ip).func_77978_p().func_150295_c("MagnetSlot", 10).func_150305_b(0)) != null && (magnetItem = ItemStack.func_77949_a((NBTTagCompound)magnetNBTForm)) != null && magnetItem.func_77973_b() instanceof ItemMagnet;
    }

    public static void removeTimerTags(ItemStack is) {
        if (is == null || is.func_77978_p() == null) {
            return;
        }
        if (is.func_77978_p().func_74764_b("WCTReset")) {
            is.func_77982_d(null);
        }
        if (is.func_77978_p() != null && is.func_77978_p().func_74764_b("WCTPickupTimer")) {
            is.func_77978_p().func_82580_o("WCTPickupTimer");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static String color(String color) {
        switch (color) {
            case "white": {
                return TextFormatting.WHITE.toString();
            }
            case "black": {
                return TextFormatting.BLACK.toString();
            }
            case "green": {
                return TextFormatting.GREEN.toString();
            }
            case "red": {
                return TextFormatting.RED.toString();
            }
            case "yellow": {
                return TextFormatting.YELLOW.toString();
            }
            case "aqua": {
                return TextFormatting.AQUA.toString();
            }
            case "blue": {
                return TextFormatting.BLUE.toString();
            }
            case "italics": {
                return TextFormatting.ITALIC.toString();
            }
            case "bold": {
                return TextFormatting.BOLD.toString();
            }
        }
        return TextFormatting.GRAY.toString();
    }

    @SideOnly(value=Side.CLIENT)
    public static EntityPlayer player() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public static EntityPlayer player(InventoryPlayer playerInv) {
        return playerInv.field_70458_d;
    }

    @SideOnly(value=Side.CLIENT)
    public static World world() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    public static World world(EntityPlayer player) {
        return player.func_130014_f_();
    }

    public static void chatMessage(EntityPlayer player, ITextComponent message) {
        player.func_145747_a(message);
    }
}

