/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.wct.sync.packets;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import p455w0rd.wct.init.ModGlobals;
import p455w0rd.wct.integration.Baubles;
import p455w0rd.wct.items.ItemMagnet;
import p455w0rd.wct.sync.WCTPacket;
import p455w0rd.wct.sync.network.INetworkInfo;
import p455w0rd.wct.sync.network.NetworkHandler;
import p455w0rd.wct.sync.packets.PacketMagnetFilter;
import p455w0rd.wct.util.WCTUtils;

public class PacketSetMagnet
extends WCTPacket {
    int magnetDamage;
    ItemStack magnetStack = null;

    public PacketSetMagnet(ByteBuf stream) {
        this.magnetDamage = stream.readInt();
        this.magnetStack = ByteBufUtils.readItemStack((ByteBuf)stream);
    }

    public PacketSetMagnet(int itemDamage) {
        this(itemDamage, null);
    }

    public PacketSetMagnet(int itemDamage, ItemStack stackIn) {
        this.magnetDamage = itemDamage;
        this.magnetStack = stackIn;
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        data.writeInt(this.magnetDamage);
        ByteBufUtils.writeItemStack((ByteBuf)data, (ItemStack)this.magnetStack);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, WCTPacket packet, EntityPlayer player) {
        ItemStack magnetItem;
        ItemStack itemStack = magnetItem = this.magnetStack == null ? WCTUtils.getMagnet(player.field_71071_by) : this.magnetStack;
        if (magnetItem == null || !(magnetItem.func_77973_b() instanceof ItemMagnet)) {
            return;
        }
        if (!magnetItem.func_77942_o()) {
            NetworkHandler.instance().sendToServer(new PacketMagnetFilter(0, true));
        }
        if (WCTUtils.isMagnetInstalled(player.field_71071_by)) {
            NBTTagList magnetNBTForm;
            ItemStack wct = WCTUtils.getWirelessTerm(player.field_71071_by);
            if (ModGlobals.Mods.BAUBLES.isLoaded()) {
                ItemStack itemStack2 = wct = Baubles.getWCTBauble(player) != null ? Baubles.getWCTBauble(player) : wct;
            }
            if ((magnetNBTForm = wct.func_77978_p().func_150295_c("MagnetSlot", 10)).func_150305_b(0) != null) {
                ItemStack.func_77949_a((NBTTagCompound)magnetNBTForm.func_150305_b(0)).func_77978_p().func_74768_a("MagnetMode", this.magnetDamage);
                magnetNBTForm.func_150304_a(0, (NBTBase)magnetItem.serializeNBT());
            }
            if (ModGlobals.Mods.BAUBLES.isLoaded() && Baubles.getWCTBauble(player) != null) {
                int slotIndex = Baubles.getWCTBaubleSlotIndex(player);
                Baubles.setBaublesItemStack(player, slotIndex, wct);
            }
        }
    }

    @Override
    public void clientPacketData(INetworkInfo network, WCTPacket packet, EntityPlayer player) {
    }
}

