/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.wct.sync.packets;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.player.EntityPlayer;
import p455w0rd.wct.container.ContainerWCT;
import p455w0rd.wct.container.WCTBaseContainer;
import p455w0rd.wct.sync.WCTPacket;
import p455w0rd.wct.sync.network.INetworkInfo;

public class PacketPartialItem
extends WCTPacket {
    private final short pageNum;
    private final byte[] data;

    public PacketPartialItem(ByteBuf stream) {
        this.pageNum = stream.readShort();
        this.data = new byte[stream.readableBytes()];
        stream.readBytes(this.data);
    }

    public PacketPartialItem(int page, int maxPages, byte[] buf) {
        ByteBuf data = Unpooled.buffer();
        this.pageNum = (short)(page | maxPages << 8);
        this.data = buf;
        data.writeInt(this.getPacketID());
        data.writeShort((int)this.pageNum);
        data.writeBytes(buf);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, WCTPacket packet, EntityPlayer player) {
        if (player.field_71070_bA instanceof ContainerWCT) {
            ((ContainerWCT)player.field_71070_bA).postPartial(this);
        } else if (player.field_71070_bA instanceof WCTBaseContainer) {
            ((WCTBaseContainer)player.field_71070_bA).postPartial(this);
        }
    }

    public int getPageCount() {
        return this.pageNum >> 8;
    }

    public int getSize() {
        return this.data.length;
    }

    public int write(byte[] buffer, int cursor) {
        System.arraycopy(this.data, 0, buffer, cursor, this.data.length);
        return cursor + this.data.length;
    }
}

