/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.wct.sync.packets;

import appeng.api.storage.data.IAEItemStack;
import appeng.util.item.AEItemStack;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import p455w0rd.wct.client.gui.GuiCraftConfirm;
import p455w0rd.wct.client.gui.GuiCraftingCPU;
import p455w0rd.wct.client.gui.GuiWCT;
import p455w0rd.wct.sync.WCTPacket;
import p455w0rd.wct.sync.network.INetworkInfo;

public class PacketMEInventoryUpdate
extends WCTPacket {
    private static final int UNCOMPRESSED_PACKET_BYTE_LIMIT = 0x1000000;
    private static final int OPERATION_BYTE_LIMIT = 2048;
    private static final int TEMP_BUFFER_SIZE = 1024;
    private static final int STREAM_MASK = 255;
    @Nullable
    private final List<IAEItemStack> list;
    private final byte ref;
    @Nullable
    private final ByteBuf data;
    @Nullable
    private final GZIPOutputStream compressFrame;
    private int writtenBytes = 0;
    private boolean empty = true;

    public PacketMEInventoryUpdate(final ByteBuf stream) throws IOException {
        this.data = null;
        this.compressFrame = null;
        this.list = new LinkedList<IAEItemStack>();
        this.ref = stream.readByte();
        GZIPInputStream gzReader = new GZIPInputStream(new InputStream(){

            @Override
            public int read() throws IOException {
                if (stream.readableBytes() <= 0) {
                    return -1;
                }
                return stream.readByte() & 0xFF;
            }
        });
        ByteBuf uncompressed = Unpooled.buffer((int)stream.readableBytes());
        byte[] tmp = new byte[1024];
        while (gzReader.available() != 0) {
            int bytes = gzReader.read(tmp);
            if (bytes <= 0) continue;
            uncompressed.writeBytes(tmp, 0, bytes);
        }
        gzReader.close();
        while (uncompressed.readableBytes() > 0) {
            this.list.add(AEItemStack.loadItemStackFromPacket((ByteBuf)uncompressed));
        }
        this.empty = this.list.isEmpty();
    }

    public PacketMEInventoryUpdate() throws IOException {
        this(0);
    }

    public PacketMEInventoryUpdate(byte ref) throws IOException {
        this.ref = ref;
        this.data = Unpooled.buffer((int)2048);
        this.data.writeInt(this.getPacketID());
        this.data.writeByte((int)this.ref);
        this.compressFrame = new GZIPOutputStream(new OutputStream(){

            @Override
            public void write(int value) throws IOException {
                PacketMEInventoryUpdate.this.data.writeByte(value);
            }
        });
        this.list = null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void clientPacketData(INetworkInfo network, WCTPacket packet, EntityPlayer player) {
        GuiScreen gs = Minecraft.func_71410_x().field_71462_r;
        if (gs instanceof GuiCraftConfirm) {
            ((GuiCraftConfirm)gs).postUpdate(this.list, this.ref);
        }
        if (gs instanceof GuiCraftingCPU) {
            ((GuiCraftingCPU)gs).postUpdate(this.list, this.ref);
        }
        if (gs instanceof GuiWCT) {
            ((GuiWCT)gs).postUpdate(this.list);
        }
    }

    @Override
    @Nullable
    public FMLProxyPacket getProxy() {
        try {
            this.compressFrame.close();
            this.configureWrite(this.data);
            return super.getProxy();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void appendItem(IAEItemStack is) throws IOException, BufferOverflowException {
        ByteBuf tmp = Unpooled.buffer((int)2048);
        is.writeToPacket(tmp);
        this.compressFrame.flush();
        if (this.writtenBytes + tmp.readableBytes() > 0x1000000) {
            throw new BufferOverflowException();
        }
        this.writtenBytes += tmp.readableBytes();
        this.compressFrame.write(tmp.array(), 0, tmp.readableBytes());
        this.empty = false;
    }

    public int getLength() {
        return this.data.readableBytes();
    }

    public boolean isEmpty() {
        return this.empty;
    }
}

