/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.wct.sync.network;

import appeng.core.worlddata.WorldData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import p455w0rd.wct.sync.WCTPacket;
import p455w0rd.wct.sync.network.IPacketHandler;
import p455w0rd.wct.sync.network.WCTClientPacketHandler;
import p455w0rd.wct.sync.network.WCTServerPacketHandler;

public class NetworkHandler {
    private static final NetworkHandler INSTANCE = new NetworkHandler();
    private static final String CHANNEL_NAME = "WCT";
    private static final FMLEventChannel CHANNEL = NetworkRegistry.INSTANCE.newEventDrivenChannel("WCT");
    private static final IPacketHandler clientHandler = WCTClientPacketHandler.instance();
    private static final IPacketHandler serverHandler = WCTServerPacketHandler.instance();

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)NetworkHandler.instance());
        NetworkHandler.getEventChannel().register((Object)NetworkHandler.instance());
    }

    public static NetworkHandler instance() {
        return INSTANCE;
    }

    public static FMLEventChannel getEventChannel() {
        return CHANNEL;
    }

    public IPacketHandler getClientHandler() {
        return clientHandler;
    }

    public IPacketHandler getServerHandler() {
        return serverHandler;
    }

    public String getChannel() {
        return CHANNEL_NAME;
    }

    public void sendToAll(WCTPacket message) {
        NetworkHandler.getEventChannel().sendToAll(message.getProxy());
    }

    public void sendTo(WCTPacket message, EntityPlayerMP player) {
        NetworkHandler.getEventChannel().sendTo(message.getProxy(), player);
    }

    public void sendToAllAround(WCTPacket message, NetworkRegistry.TargetPoint point) {
        NetworkHandler.getEventChannel().sendToAllAround(message.getProxy(), point);
    }

    public void sendToDimension(WCTPacket message, int dimensionId) {
        NetworkHandler.getEventChannel().sendToDimension(message.getProxy(), dimensionId);
    }

    public void sendToServer(WCTPacket message) {
        NetworkHandler.getEventChannel().sendToServer(message.getProxy());
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        if (e.player instanceof EntityPlayerMP) {
            WorldData.instance().dimensionData().sendToPlayer(null);
        }
    }

    @SubscribeEvent
    public void newConnection(FMLNetworkEvent.ServerConnectionFromClientEvent ev) {
        WorldData.instance().dimensionData().sendToPlayer(ev.getManager());
    }

    @SubscribeEvent
    public void serverPacket(FMLNetworkEvent.ServerCustomPacketEvent ev) {
        NetHandlerPlayServer srv = (NetHandlerPlayServer)ev.getPacket().handler();
        WCTServerPacketHandler.instance().onPacketData(null, ev.getHandler(), ev.getPacket(), (EntityPlayer)srv.field_147369_b);
    }

    @SubscribeEvent
    public void clientPacket(FMLNetworkEvent.ClientCustomPacketEvent ev) {
        WCTClientPacketHandler.instance().onPacketData(null, ev.getHandler(), ev.getPacket(), null);
    }
}

