/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.wct.items;

import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.util.IConfigManager;
import appeng.core.localization.GuiText;
import appeng.items.tools.powered.powersink.AERootPoweredItem;
import appeng.util.ConfigManager;
import appeng.util.Platform;
import baubles.api.BaubleType;
import java.util.List;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import p455w0rd.wct.api.IBaubleItem;
import p455w0rd.wct.api.IBaubleRender;
import p455w0rd.wct.api.IModelHolder;
import p455w0rd.wct.api.IWirelessCraftingTerminalItem;
import p455w0rd.wct.client.gui.WCTBaseGui;
import p455w0rd.wct.client.render.RenderLayerWCT;
import p455w0rd.wct.handlers.GuiHandler;
import p455w0rd.wct.init.ModConfig;
import p455w0rd.wct.items.ItemInfinityBooster;
import p455w0rd.wct.items.ItemMagnet;
import p455w0rd.wct.util.WCTUtils;

@Optional.Interface(iface="baubles.api.IBauble", modid="Baubles|API")
public class ItemWCT
extends AERootPoweredItem
implements IModelHolder,
IWirelessCraftingTerminalItem,
IBaubleItem {
    private static final String name = "wct";
    public static final String LINK_KEY_STRING = "key";
    public static double GLOBAL_POWER_MULTIPLIER = PowerMultiplier.CONFIG.multiplier;
    private static final String BOOSTER_SLOT_NBT = "BoosterSlot";
    private static final String MAGNET_SLOT_NBT = "MagnetSlot";
    private EntityPlayer entityPlayer;

    public ItemWCT() {
        super((double)ModConfig.WCT_MAX_POWER);
        this.setRegistryName(name);
        this.func_77655_b(name);
        this.func_77625_d(1);
        GameRegistry.register((IForgeRegistryEntry)this);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K && hand == EnumHand.MAIN_HAND) {
            GuiHandler.open(0, player, world, player.func_180425_c());
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        if (world.field_72995_K) {
            WCTBaseGui.memoryText = "";
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
    }

    public boolean func_77645_m() {
        return false;
    }

    public void getCheckedSubItems(Item item, CreativeTabs creativeTab, List<ItemStack> itemList) {
        itemList.add(new ItemStack(item));
        ItemStack is = new ItemStack(item);
        this.injectAEPower(is, ModConfig.WCT_MAX_POWER);
        itemList.add(is);
    }

    public boolean showDurabilityBar(ItemStack is) {
        double aeMaxPower;
        double aeCurrPower = this.getAECurrentPower(is);
        return (int)aeCurrPower < (int)(aeMaxPower = this.getAEMaxPower(is));
    }

    @SideOnly(value=Side.CLIENT)
    public void addCheckedInformation(ItemStack is, EntityPlayer player, List<String> list, boolean displayMore) {
        String encKey = this.getEncryptionKey(is);
        String shift = I18n.func_135052_a((String)"tooltip.press_shift.desc", (Object[])new Object[0]).replace("Shift", TextFormatting.YELLOW + "" + TextFormatting.BOLD + "" + TextFormatting.ITALIC + "Shift" + TextFormatting.GRAY);
        String pctTxtColor = TextFormatting.WHITE + "";
        double aeCurrPower = this.getAECurrentPower(is);
        double aeCurrPowerPct = (double)((int)Math.floor(aeCurrPower / this.getAEMaxPower(is) * 10000.0)) / 100.0;
        if ((int)aeCurrPowerPct >= 75) {
            pctTxtColor = TextFormatting.GREEN + "";
        }
        if ((int)aeCurrPowerPct <= 5) {
            pctTxtColor = TextFormatting.RED + "";
        }
        list.add(TextFormatting.AQUA + "==============================");
        list.add(GuiText.StoredEnergy + ": " + pctTxtColor + (int)aeCurrPower + " AE - " + aeCurrPowerPct + "%");
        String linked = TextFormatting.RED + GuiText.Unlinked.getLocal();
        if (encKey != null && !encKey.isEmpty()) {
            linked = TextFormatting.BLUE + GuiText.Linked.getLocal();
        }
        list.add("Link Status: " + linked);
        if (ItemWCT.isShiftKeyDown()) {
            String boosterStatus = (this.checkForBooster(is) ? TextFormatting.GREEN + "" : TextFormatting.RED + "" + I18n.func_135052_a((String)"tooltip.not.desc", (Object[])new Object[0])) + " " + I18n.func_135052_a((String)"tooltip.installed.desc", (Object[])new Object[0]);
            String magnetStatus = (this.isMagnetInstalled(is) ? TextFormatting.GREEN + "" : TextFormatting.RED + "" + I18n.func_135052_a((String)"tooltip.not.desc", (Object[])new Object[0])) + " " + I18n.func_135052_a((String)"tooltip.installed.desc", (Object[])new Object[0]);
            if (ModConfig.WCT_BOOSTER_ENABLED) {
                list.add(I18n.func_135052_a((String)"item.infinity_booster_card.name", (Object[])new Object[0]) + ": " + boosterStatus);
            }
            list.add(I18n.func_135052_a((String)"item.magnet_card.name", (Object[])new Object[0]) + ": " + magnetStatus);
        } else {
            list.add(shift);
        }
    }

    @Override
    public boolean isWirelessCraftingEnabled(ItemStack wirelessTerminal) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isShiftKeyDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public boolean usePower(EntityPlayer player, double amount, ItemStack is) {
        return this.extractAEPower(is, amount) >= amount - 0.5;
    }

    public boolean hasPower(EntityPlayer player, double amt, ItemStack is) {
        return this.getAECurrentPower(is) >= amt;
    }

    public IConfigManager getConfigManager(ItemStack target) {
        ConfigManager out = new ConfigManager((manager, settingName, newValue) -> {
            NBTTagCompound data = Platform.openNbtData((ItemStack)target);
            manager.writeToNBT(data);
        });
        out.registerSetting(Settings.SORT_BY, (Enum)SortOrder.NAME);
        out.registerSetting(Settings.VIEW_MODE, (Enum)ViewItems.ALL);
        out.registerSetting(Settings.SORT_DIRECTION, (Enum)SortDir.ASCENDING);
        out.readFromNBT(Platform.openNbtData((ItemStack)target).func_74737_b());
        return out;
    }

    public String getEncryptionKey(ItemStack item) {
        NBTTagCompound tag = Platform.openNbtData((ItemStack)item);
        return tag.func_74779_i("encryptionKey");
    }

    public void setEncryptionKey(ItemStack item, String encKey, String name) {
        NBTTagCompound tag = Platform.openNbtData((ItemStack)item);
        tag.func_74778_a("encryptionKey", encKey);
        tag.func_74778_a("name", name);
    }

    public boolean canHandle(ItemStack is) {
        return is.func_77973_b().getRegistryName().toString().equals(this.getRegistryName().toString());
    }

    private double injectPower(PowerUnits inputUnit, ItemStack is, double amount, boolean simulate) {
        if (simulate) {
            int requiredExt = (int)PowerUnits.AE.convertTo(inputUnit, this.getAEMaxPower(is) - this.getAECurrentPower(is));
            if (amount < (double)requiredExt) {
                return 0.0;
            }
            return amount - (double)requiredExt;
        }
        double powerRemainder = this.injectAEPower(is, inputUnit.convertTo(PowerUnits.AE, amount));
        return PowerUnits.AE.convertTo(inputUnit, powerRemainder);
    }

    @Override
    public int receiveEnergy(ItemStack is, int maxReceive, boolean simulate) {
        return maxReceive - (int)this.injectPower(PowerUnits.RF, is, maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public int getEnergyStored(ItemStack is) {
        return (int)PowerUnits.AE.convertTo(PowerUnits.RF, this.getAECurrentPower(is));
    }

    @Override
    public int getMaxEnergyStored(ItemStack is) {
        return (int)PowerUnits.AE.convertTo(PowerUnits.RF, this.getAEMaxPower(is));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack is) {
        return this.checkForBooster(is);
    }

    @Override
    public boolean checkForBooster(ItemStack wirelessTerminal) {
        ItemStack boosterCard;
        NBTTagCompound boosterTagCompound;
        NBTTagList boosterNBTList;
        if (wirelessTerminal.func_77942_o() && (boosterNBTList = wirelessTerminal.func_77978_p().func_150295_c(BOOSTER_SLOT_NBT, 10)) != null && (boosterTagCompound = boosterNBTList.func_150305_b(0)) != null && (boosterCard = ItemStack.func_77949_a((NBTTagCompound)boosterTagCompound)) != null) {
            return boosterCard.func_77973_b() instanceof ItemInfinityBooster && ModConfig.WCT_BOOSTER_ENABLED;
        }
        return false;
    }

    private boolean isMagnetInstalled(ItemStack wirelessTerminal) {
        ItemStack magnetCard;
        NBTTagCompound magnetTagCompound;
        NBTTagList magnetNBTList;
        if (wirelessTerminal.func_77942_o() && (magnetNBTList = wirelessTerminal.func_77978_p().func_150295_c(MAGNET_SLOT_NBT, 10)) != null && (magnetTagCompound = magnetNBTList.func_150305_b(0)) != null && (magnetCard = ItemStack.func_77949_a((NBTTagCompound)magnetTagCompound)) != null) {
            return magnetCard.func_77973_b() instanceof ItemMagnet;
        }
        return false;
    }

    public void func_77663_a(ItemStack is, World w, Entity e, int i, boolean f) {
        if (!(e instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer p = (EntityPlayer)e;
        if (this.entityPlayer == null) {
            this.entityPlayer = p;
        }
        ItemStack wirelessTerminal = null;
        InventoryPlayer inv = p.field_71071_by;
        wirelessTerminal = WCTUtils.getWirelessTerm(inv);
        if (wirelessTerminal == null || !(wirelessTerminal.func_77973_b() instanceof IWirelessCraftingTerminalItem)) {
            return;
        }
        this.checkForBooster(wirelessTerminal);
    }

    @Override
    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.HEAD;
    }

    @Override
    public IBaubleRender getRender() {
        return RenderLayerWCT.getInstance();
    }

    @Override
    public boolean willAutoSync(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }
}

