/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.wct.integration;

import appeng.util.Platform;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredientBlacklist;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.Loader;
import p455w0rd.wct.container.ContainerWCT;
import p455w0rd.wct.container.slot.SlotCraftingMatrix;
import p455w0rd.wct.container.slot.SlotFakeCraftingMatrix;
import p455w0rd.wct.init.ModConfig;
import p455w0rd.wct.init.ModItems;
import p455w0rd.wct.sync.network.NetworkHandler;
import p455w0rd.wct.sync.packets.PacketJEIRecipe;

@JEIPlugin
public class JEI
implements IModPlugin {
    public static final String MODID = "JEI";

    public void register(@Nonnull IModRegistry registry) {
        IJeiHelpers helpers = registry.getJeiHelpers();
        IIngredientBlacklist blackList = helpers.getIngredientBlacklist();
        if (!ModConfig.WCT_BOOSTER_ENABLED) {
            blackList.addIngredientToBlacklist((Object)new ItemStack((Item)ModItems.BOOSTER_CARD));
        }
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(new RecipeTransferHandler<ContainerWCT>(ContainerWCT.class), "minecraft.crafting");
        registry.addDescription(new ItemStack((Item)ModItems.WCT), new String[]{"jei.test.desc"});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
    }

    public void registerIngredients(IModIngredientRegistration registry) {
    }

    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
    }

    public static boolean isLoaded() {
        return Loader.isModLoaded((String)MODID);
    }

    public class RecipeTransferHandler<T extends Container>
    implements IRecipeTransferHandler<T> {
        private final Class<T> containerClass;

        RecipeTransferHandler(Class<T> containerClass) {
            this.containerClass = containerClass;
        }

        public Class<T> getContainerClass() {
            return this.containerClass;
        }

        public String getRecipeCategoryUid() {
            return "minecraft.crafting";
        }

        @Nullable
        public IRecipeTransferError transferRecipe(T container, IRecipeLayout recipeLayout, EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
            if (!doTransfer) {
                return null;
            }
            Map ingredients = recipeLayout.getItemStacks().getGuiIngredients();
            NBTTagCompound recipe = new NBTTagCompound();
            int slotIndex = 0;
            for (Map.Entry ingredientEntry : ingredients.entrySet()) {
                IGuiIngredient ingredient = (IGuiIngredient)ingredientEntry.getValue();
                if (!ingredient.isInput()) continue;
                for (Slot slot : ((Container)container).field_75151_b) {
                    if (!(slot instanceof SlotCraftingMatrix) && !(slot instanceof SlotFakeCraftingMatrix) && !(slot.field_75224_c instanceof InventoryCrafting) || slot.getSlotIndex() != slotIndex) continue;
                    NBTTagList tags = new NBTTagList();
                    LinkedList<ItemStack> list = new LinkedList<ItemStack>();
                    for (ItemStack stack : ingredient.getAllIngredients()) {
                        if (Platform.isRecipePrioritized((ItemStack)stack)) {
                            list.add(0, stack);
                            continue;
                        }
                        list.add(stack);
                    }
                    for (ItemStack is : list) {
                        NBTTagCompound tag = new NBTTagCompound();
                        is.func_77955_b(tag);
                        tags.func_74742_a((NBTBase)tag);
                    }
                    recipe.func_74782_a("#" + slot.getSlotIndex(), (NBTBase)tags);
                    break;
                }
                ++slotIndex;
            }
            try {
                NetworkHandler.instance().sendToServer(new PacketJEIRecipe(recipe));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
    }
}

