/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.wct.init;

import appeng.tile.networking.TileController;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import p455w0rd.wct.WCT;
import p455w0rd.wct.api.IWirelessCraftingTerminalItem;
import p455w0rd.wct.client.render.BaubleRenderDispatcher;
import p455w0rd.wct.container.ContainerMagnet;
import p455w0rd.wct.container.ContainerWCT;
import p455w0rd.wct.init.ModConfig;
import p455w0rd.wct.init.ModGlobals;
import p455w0rd.wct.init.ModItems;
import p455w0rd.wct.init.ModKeybindings;
import p455w0rd.wct.items.ItemMagnet;
import p455w0rd.wct.sync.network.NetworkHandler;
import p455w0rd.wct.sync.packets.PacketConfigSync;
import p455w0rd.wct.sync.packets.PacketMagnetFilter;
import p455w0rd.wct.sync.packets.PacketOpenGui;
import p455w0rd.wct.util.WCTUtils;
import p455w0rdslib.capabilities.CapabilityChunkLoader;
import p455w0rdslib.util.ChunkUtils;

public class ModEvents {
    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new ModEvents());
        ChunkUtils.register((Object)WCT.INSTANCE);
    }

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<TileEntity> event) {
        if (event.getObject() instanceof TileController && ModConfig.WCT_ENABLE_CONTROLLER_CHUNKLOADER) {
            TileController controller = (TileController)event.getObject();
            event.addCapability(new ResourceLocation("wct", "chunkloader"), (ICapabilityProvider)new CapabilityChunkLoader.ProviderTE((TileEntity)controller));
        }
    }

    @SubscribeEvent
    public void onPlace(BlockEvent.PlaceEvent e) {
        TileEntity tile;
        World world = e.getWorld();
        BlockPos pos = e.getPos();
        if (world != null && pos != null && world.func_175625_s(pos) != null && !world.field_72995_K && ModConfig.WCT_ENABLE_CONTROLLER_CHUNKLOADER && world.func_175625_s(pos) instanceof TileController && (tile = world.func_175625_s(pos)).hasCapability(CapabilityChunkLoader.CAPABILITY_CHUNKLOADER_TE, null)) {
            ((CapabilityChunkLoader.ICLTEHandler)tile.getCapability(CapabilityChunkLoader.CAPABILITY_CHUNKLOADER_TE, null)).attachChunkLoader((Object)WCT.INSTANCE);
        }
    }

    @SubscribeEvent
    public void onBreak(BlockEvent.BreakEvent e) {
        TileEntity tile;
        World world = e.getWorld();
        BlockPos pos = e.getPos();
        if (world != null && pos != null && world.func_175625_s(pos) != null && !world.field_72995_K && ModConfig.WCT_ENABLE_CONTROLLER_CHUNKLOADER && world.func_175625_s(pos) instanceof TileController && (tile = world.func_175625_s(pos)).hasCapability(CapabilityChunkLoader.CAPABILITY_CHUNKLOADER_TE, null)) {
            ((CapabilityChunkLoader.ICLTEHandler)tile.getCapability(CapabilityChunkLoader.CAPABILITY_CHUNKLOADER_TE, null)).detachChunkLoader((Object)WCT.INSTANCE);
        }
    }

    @SubscribeEvent
    public void tickEvent(TickEvent.PlayerTickEvent e) {
        ItemStack magnetItem;
        NBTTagCompound magCompound;
        NBTTagCompound nbtTC;
        NBTTagList tagList;
        EntityPlayer player = e.player;
        InventoryPlayer playerInv = player.field_71071_by;
        ItemStack wirelessTerm = WCTUtils.getWirelessTerm(playerInv);
        int invSize = playerInv.func_70302_i_();
        if (invSize <= 0) {
            return;
        }
        if (wirelessTerm != null && wirelessTerm.func_77942_o() && (tagList = (nbtTC = wirelessTerm.func_77978_p()).func_150295_c("MagnetSlot", 10)) != null && (magCompound = tagList.func_150305_b(0)) != null && (magnetItem = ItemStack.func_77949_a((NBTTagCompound)magCompound)) != null) {
            ((ItemMagnet)magnetItem.func_77973_b()).setItemStack(magnetItem);
            if (magnetItem.func_77973_b() instanceof ItemMagnet) {
                ((ItemMagnet)magnetItem.func_77973_b()).doMagnet(magnetItem, WCTUtils.world(e.player), e.player, wirelessTerm);
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        ItemStack magnetItem;
        EntityPlayer p = WCTUtils.player();
        if (p.field_71070_bA == null) {
            return;
        }
        if (ModKeybindings.openTerminal.func_151463_i() != 0 && ModKeybindings.openTerminal.func_151468_f()) {
            ItemStack is = WCTUtils.getWirelessTerm(p.field_71071_by);
            if (is == null) {
                return;
            }
            IWirelessCraftingTerminalItem wirelessTerm = (IWirelessCraftingTerminalItem)is.func_77973_b();
            if (wirelessTerm != null && wirelessTerm.isWirelessCraftingEnabled(is)) {
                if (!(p.field_71070_bA instanceof ContainerWCT)) {
                    NetworkHandler.instance().sendToServer(new PacketOpenGui(0));
                } else {
                    p.func_71053_j();
                }
            }
        } else if (ModKeybindings.openMagnetFilter.func_151463_i() != 0 && ModKeybindings.openMagnetFilter.func_151468_f()) {
            ItemStack magnetItem2 = WCTUtils.getMagnet(p.field_71071_by);
            if (magnetItem2 != null) {
                if (!WCTUtils.isMagnetInitialized(magnetItem2)) {
                    if (magnetItem2.func_77978_p() == null) {
                        magnetItem2.func_77982_d(new NBTTagCompound());
                    }
                    NetworkHandler.instance().sendToServer(new PacketMagnetFilter(0, true));
                }
                if (!(p.field_71070_bA instanceof ContainerMagnet)) {
                    NetworkHandler.instance().sendToServer(new PacketOpenGui(4));
                }
            }
        } else if (ModKeybindings.changeMagnetMode.func_151463_i() != 0 && ModKeybindings.changeMagnetMode.func_151468_f() && (magnetItem = WCTUtils.getMagnet(p.field_71071_by)) != null) {
            if (!WCTUtils.isMagnetInitialized(magnetItem)) {
                if (!magnetItem.func_77942_o()) {
                    magnetItem.func_77982_d(new NBTTagCompound());
                }
                NetworkHandler.instance().sendToServer(new PacketMagnetFilter(0, true));
            }
            ItemMagnet.switchMagnetMode(magnetItem, p);
        }
    }

    @SubscribeEvent
    public void onMobDrop(LivingDropsEvent event) {
        ItemStack stack = new ItemStack((Item)ModItems.BOOSTER_CARD);
        EntityItem drop = new EntityItem(event.getEntityLiving().func_130014_f_(), event.getEntity().field_70165_t, event.getEntity().field_70163_u, event.getEntity().field_70161_v, stack);
        if (event.getEntity() instanceof EntityDragon && ModConfig.WCT_BOOSTER_ENABLED && ModConfig.WCT_DRAGON_DROPS_BOOSTER) {
            event.getDrops().add(drop);
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        if (e.player instanceof EntityPlayerMP) {
            PacketConfigSync p = new PacketConfigSync(ModConfig.WCT_MAX_POWER, ModConfig.WCT_BOOSTER_ENABLED, ModConfig.WCT_MINETWEAKER_OVERRIDE, ModConfig.WCT_ENABLE_CONTROLLER_CHUNKLOADER, ModConfig.WCT_DRAGON_DROPS_BOOSTER);
            NetworkHandler.instance().sendTo(p, (EntityPlayerMP)e.player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPlayerRenderPre(RenderPlayerEvent.Pre event) {
        if (ModGlobals.Mods.BAUBLES.isLoaded() && !BaubleRenderDispatcher.getRegistry().containsKey(event.getRenderer())) {
            event.getRenderer().func_177094_a((LayerRenderer)new BaubleRenderDispatcher(event.getRenderer()));
            BaubleRenderDispatcher.getRegistry().put(event.getRenderer(), null);
        }
    }
}

