/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.wct.container;

import appeng.api.AEApi;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.core.Api;
import appeng.helpers.ICustomNameObject;
import appeng.helpers.InventoryAction;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.BufferOverflowException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import p455w0rd.wct.api.IWirelessCraftingTermHandler;
import p455w0rd.wct.api.networking.security.WCTIActionHost;
import p455w0rd.wct.api.networking.security.WCTPlayerSource;
import p455w0rd.wct.client.me.InternalSlotME;
import p455w0rd.wct.client.me.SlotME;
import p455w0rd.wct.container.ContainerOpenContext;
import p455w0rd.wct.container.guisync.GuiSync;
import p455w0rd.wct.container.guisync.SyncData;
import p455w0rd.wct.container.slot.AppEngSlot;
import p455w0rd.wct.container.slot.SlotCraftingMatrix;
import p455w0rd.wct.container.slot.SlotDisabled;
import p455w0rd.wct.container.slot.SlotFake;
import p455w0rd.wct.container.slot.SlotInaccessible;
import p455w0rd.wct.container.slot.SlotPlayerHotBar;
import p455w0rd.wct.container.slot.SlotPlayerInv;
import p455w0rd.wct.helpers.WCTGuiObject;
import p455w0rd.wct.sync.network.NetworkHandler;
import p455w0rd.wct.sync.packets.PacketInventoryAction;
import p455w0rd.wct.sync.packets.PacketMEInventoryUpdate;
import p455w0rd.wct.sync.packets.PacketPartialItem;
import p455w0rd.wct.sync.packets.PacketValueConfig;

public abstract class WCTBaseContainer
extends Container {
    protected final InventoryPlayer inventoryPlayer;
    protected BaseActionSource mySrc;
    protected final HashSet<Integer> locked = new HashSet();
    public final WCTGuiObject obj;
    protected final List<PacketPartialItem> dataChunks = new LinkedList<PacketPartialItem>();
    protected final HashMap<Integer, SyncData> syncData = new HashMap();
    private boolean isContainerValid = true;
    protected String customName;
    protected ContainerOpenContext openContext;
    protected IMEInventoryHandler<IAEItemStack> cellInv;
    protected IEnergySource powerSrc;
    protected boolean sentCustomName;
    protected int ticksSinceCheck = 900;
    protected IAEItemStack clientRequestedTargetItem = null;
    protected IMEMonitor<IAEItemStack> monitor;

    public WCTBaseContainer(InventoryPlayer ip, Object anchor) {
        this.inventoryPlayer = ip;
        WCTGuiObject wCTGuiObject = this.obj = anchor instanceof WCTGuiObject ? (WCTGuiObject)anchor : null;
        if (this.obj == null) {
            this.setValidContainer(false);
        } else {
            this.mySrc = new WCTPlayerSource(ip.field_70458_d, WCTBaseContainer.getActionHost(this.obj));
        }
        this.prepareSync();
    }

    protected static WCTGuiObject getGuiObject(ItemStack it, EntityPlayer player, World w, int x, int y, int z) {
        IWirelessCraftingTermHandler wh;
        if (it != null && (wh = (IWirelessCraftingTermHandler)AEApi.instance().registries().wireless().getWirelessTerminalHandler(it)) != null) {
            return new WCTGuiObject(wh, it, player, w, x, y, z);
        }
        return null;
    }

    protected static WCTIActionHost getActionHost(Object object) {
        if (object instanceof WCTIActionHost) {
            return (WCTIActionHost)object;
        }
        return null;
    }

    public void prepareSync() {
        for (Field f : ((Object)((Object)this)).getClass().getFields()) {
            GuiSync annotation;
            if (!f.isAnnotationPresent(GuiSync.class) || this.syncData.containsKey((annotation = f.getAnnotation(GuiSync.class)).value())) continue;
            this.syncData.put(annotation.value(), new SyncData(this, f, annotation));
        }
    }

    protected void queueInventory(IContainerListener c) {
        if (Platform.isServer() && c instanceof EntityPlayerMP && this.monitor != null) {
            try {
                PacketMEInventoryUpdate piu = new PacketMEInventoryUpdate();
                IItemList monitorCache = this.monitor.getStorageList();
                for (IAEItemStack send : monitorCache) {
                    try {
                        piu.appendItem(send);
                    }
                    catch (BufferOverflowException boe) {
                        NetworkHandler.instance().sendTo(piu, (EntityPlayerMP)c);
                        piu = new PacketMEInventoryUpdate();
                        piu.appendItem(send);
                    }
                }
                if (piu != null && c != null) {
                    NetworkHandler.instance().sendTo(piu, (EntityPlayerMP)c);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void postPartial(PacketPartialItem packetPartialItem) {
        this.dataChunks.add(packetPartialItem);
        if (packetPartialItem.getPageCount() == this.dataChunks.size()) {
            this.parsePartials();
        }
    }

    private void parsePartials() {
        int total = 0;
        for (PacketPartialItem ppi : this.dataChunks) {
            total += ppi.getSize();
        }
        byte[] buffer = new byte[total];
        int cursor = 0;
        for (PacketPartialItem ppi : this.dataChunks) {
            cursor = ppi.write(buffer, cursor);
        }
        try {
            NBTTagCompound data = CompressedStreamTools.func_74796_a((InputStream)new ByteArrayInputStream(buffer));
            if (data != null) {
                this.setTargetStack(AEApi.instance().storage().createItemStack(ItemStack.func_77949_a((NBTTagCompound)data)));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.dataChunks.clear();
    }

    public IAEItemStack getTargetStack() {
        return this.clientRequestedTargetItem;
    }

    public void setTargetStack(IAEItemStack stack) {
        if (Platform.isClient()) {
            ItemStack b;
            ItemStack a = stack == null ? null : stack.getItemStack();
            ItemStack itemStack = b = this.clientRequestedTargetItem == null ? null : this.clientRequestedTargetItem.getItemStack();
            if (Platform.itemComparisons().isSameItem(a, b)) {
                return;
            }
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            NBTTagCompound item = new NBTTagCompound();
            if (stack != null) {
                stack.writeToNBT(item);
            }
            try {
                CompressedStreamTools.func_74799_a((NBTTagCompound)item, (OutputStream)stream);
                int maxChunkSize = 30000;
                LinkedList<byte[]> miniPackets = new LinkedList<byte[]>();
                byte[] data = stream.toByteArray();
                ByteArrayInputStream bis = new ByteArrayInputStream(data, 0, stream.size());
                while (bis.available() > 0) {
                    int nextBLock = bis.available() > 30000 ? 30000 : bis.available();
                    byte[] nextSegment = new byte[nextBLock];
                    bis.read(nextSegment);
                    miniPackets.add(nextSegment);
                }
                bis.close();
                stream.close();
                int page = 0;
                for (byte[] packet : miniPackets) {
                    PacketPartialItem ppi = new PacketPartialItem(page, miniPackets.size(), packet);
                    ++page;
                    NetworkHandler.instance().sendToServer(ppi);
                }
            }
            catch (IOException e) {
                return;
            }
        }
        this.clientRequestedTargetItem = stack == null ? null : stack.copy();
    }

    public BaseActionSource getActionSource() {
        return this.mySrc;
    }

    public void verifyPermissions(SecurityPermissions security, boolean requirePower) {
        if (Platform.isClient()) {
            return;
        }
        ++this.ticksSinceCheck;
        if (this.ticksSinceCheck < 20) {
            return;
        }
        this.ticksSinceCheck = 0;
        this.setValidContainer(this.isValidContainer() && this.hasAccess(security, requirePower));
    }

    protected boolean hasAccess(SecurityPermissions perm, boolean requirePower) {
        IEnergyGrid eg;
        IGrid grid = this.obj.getTargetGrid();
        if (grid != null && !(eg = (IEnergyGrid)grid.getCache(IEnergyGrid.class)).isNetworkPowered()) {
            return false;
        }
        ISecurityGrid sg = (ISecurityGrid)grid.getCache(ISecurityGrid.class);
        return sg.hasPermission(this.getInventoryPlayer().field_70458_d, perm);
    }

    public void lockPlayerInventorySlot(int idx) {
        this.locked.add(idx);
    }

    public Object getTarget() {
        if (this.obj != null) {
            return this.obj;
        }
        return null;
    }

    public InventoryPlayer getPlayerInv() {
        return this.getInventoryPlayer();
    }

    public final void updateFullProgressBar(int idx, long value) {
        if (this.syncData.containsKey(idx)) {
            this.syncData.get(idx).update(value);
            return;
        }
        this.func_75137_b(idx, (int)value);
    }

    public void stringSync(int idx, String value) {
        if (this.syncData.containsKey(idx)) {
            this.syncData.get(idx).update(value);
        }
    }

    protected void bindPlayerInventory(InventoryPlayer inventoryPlayer, int offsetX, int offsetY) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (this.locked.contains(j + i * 9 + 9)) {
                    this.func_75146_a(new SlotDisabled((IInventory)inventoryPlayer, j + i * 9 + 9, 8 + j * 18 + offsetX, offsetY + i * 18));
                    continue;
                }
                this.func_75146_a(new SlotPlayerInv((IInventory)inventoryPlayer, j + i * 9 + 9, 8 + j * 18 + offsetX, offsetY + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            if (this.locked.contains(i)) {
                this.func_75146_a(new SlotDisabled((IInventory)inventoryPlayer, i, 8 + i * 18 + offsetX, 58 + offsetY));
                continue;
            }
            this.func_75146_a(new SlotPlayerHotBar((IInventory)inventoryPlayer, i, 8 + i * 18 + offsetX, 58 + offsetY));
        }
    }

    public Slot func_75146_a(Slot newSlot) {
        if (newSlot instanceof AppEngSlot) {
            ((AppEngSlot)newSlot).setContainer(this);
        }
        return super.func_75146_a(newSlot);
    }

    public void func_75142_b() {
        this.sendCustomName();
        for (IContainerListener listener : this.field_75149_d) {
            for (SyncData sd : this.syncData.values()) {
                sd.tick(listener);
            }
        }
        super.func_75142_b();
    }

    public ItemStack func_82846_b(EntityPlayer p, int idx) {
        if (Platform.isClient()) {
            return null;
        }
        boolean hasMETiles = false;
        for (Object is : this.field_75151_b) {
            if (!(is instanceof InternalSlotME)) continue;
            hasMETiles = true;
            break;
        }
        if (hasMETiles && Platform.isClient()) {
            return null;
        }
        AppEngSlot clickSlot = (AppEngSlot)((Object)this.field_75151_b.get(idx));
        if (clickSlot instanceof SlotDisabled || clickSlot instanceof SlotInaccessible) {
            return null;
        }
        if (clickSlot != null && clickSlot.func_75216_d()) {
            AppEngSlot cs;
            ItemStack tis = clickSlot.func_75211_c();
            if (tis == null) {
                return null;
            }
            ArrayList<AppEngSlot> selectedSlots = new ArrayList<AppEngSlot>();
            if (clickSlot.isPlayerSide()) {
                tis = this.shiftStoreItem(tis);
                for (Object e : this.field_75151_b) {
                    cs = (AppEngSlot)((Object)e);
                    if (cs.isPlayerSide() || cs instanceof SlotFake || cs instanceof SlotCraftingMatrix || !cs.func_75214_a(tis)) continue;
                    selectedSlots.add(cs);
                }
            } else {
                for (Object e : this.field_75151_b) {
                    cs = (AppEngSlot)((Object)e);
                    if (!cs.isPlayerSide() || cs instanceof SlotFake || cs instanceof SlotCraftingMatrix || !cs.func_75214_a(tis)) continue;
                    selectedSlots.add(cs);
                }
            }
            if (selectedSlots.isEmpty() && clickSlot.isPlayerSide() && tis != null) {
                for (Object e : this.field_75151_b) {
                    cs = (AppEngSlot)((Object)e);
                    ItemStack destination = cs.func_75211_c();
                    if (cs.isPlayerSide() || !(cs instanceof SlotFake)) continue;
                    if (Platform.itemComparisons().isSameItem(destination, tis)) {
                        return null;
                    }
                    if (destination != null) continue;
                    cs.func_75215_d(tis.func_77946_l());
                    cs.func_75218_e();
                    this.updateSlot(cs);
                    return null;
                }
            }
            if (tis != null) {
                int placeAble;
                for (Slot slot : selectedSlots) {
                    if (slot instanceof SlotDisabled || slot instanceof SlotME || !slot.func_75214_a(tis) || !slot.func_75216_d()) continue;
                    ItemStack t = slot.func_75211_c();
                    if (!Platform.itemComparisons().isSameItem(tis, t)) continue;
                    int maxSize = t.func_77976_d();
                    if (maxSize > slot.func_75219_a()) {
                        maxSize = slot.func_75219_a();
                    }
                    if (tis.field_77994_a < (placeAble = maxSize - t.field_77994_a)) {
                        placeAble = tis.field_77994_a;
                    }
                    t.field_77994_a += placeAble;
                    tis.field_77994_a -= placeAble;
                    if (tis.field_77994_a <= 0) {
                        clickSlot.func_75215_d(null);
                        slot.func_75218_e();
                        this.updateSlot(clickSlot);
                        this.updateSlot(slot);
                        return null;
                    }
                    this.updateSlot(slot);
                }
                for (Slot slot : selectedSlots) {
                    if (slot instanceof SlotDisabled || slot instanceof SlotME || !slot.func_75214_a(tis)) continue;
                    if (slot.func_75216_d()) {
                        ItemStack t = slot.func_75211_c();
                        if (!Platform.itemComparisons().isSameItem(t, tis)) continue;
                        int maxSize = t.func_77976_d();
                        if (slot.func_75219_a() < maxSize) {
                            maxSize = slot.func_75219_a();
                        }
                        if (tis.field_77994_a < (placeAble = maxSize - t.field_77994_a)) {
                            placeAble = tis.field_77994_a;
                        }
                        t.field_77994_a += placeAble;
                        tis.field_77994_a -= placeAble;
                        if (tis.field_77994_a <= 0) {
                            clickSlot.func_75215_d(null);
                            slot.func_75218_e();
                            this.updateSlot(clickSlot);
                            this.updateSlot(slot);
                            return null;
                        }
                        this.updateSlot(slot);
                        continue;
                    }
                    int maxSize = tis.func_77976_d();
                    if (maxSize > slot.func_75219_a()) {
                        maxSize = slot.func_75219_a();
                    }
                    ItemStack tmp = tis.func_77946_l();
                    if (tmp.field_77994_a > maxSize) {
                        tmp.field_77994_a = maxSize;
                    }
                    tis.field_77994_a -= tmp.field_77994_a;
                    slot.func_75215_d(tmp);
                    if (tis.field_77994_a <= 0) {
                        clickSlot.func_75215_d(null);
                        slot.func_75218_e();
                        this.updateSlot(clickSlot);
                        this.updateSlot(slot);
                        return null;
                    }
                    this.updateSlot(slot);
                }
            }
            clickSlot.func_75215_d(tis != null ? tis.func_77946_l() : null);
        }
        this.updateSlot(clickSlot);
        return null;
    }

    public final void func_75137_b(int idx, int value) {
        if (this.syncData.containsKey(idx)) {
            this.syncData.get(idx).update(value);
        }
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        return this.isValidContainer();
    }

    public boolean func_94531_b(Slot s) {
        return ((AppEngSlot)s).isDraggable();
    }

    public abstract void doAction(EntityPlayerMP var1, InventoryAction var2, int var3, long var4);

    protected void updateHeld(EntityPlayerMP p) {
        if (Platform.isServer()) {
            try {
                NetworkHandler.instance().sendTo(new PacketInventoryAction(InventoryAction.UPDATE_HAND, 0, (IAEItemStack)AEItemStack.create((ItemStack)p.field_71071_by.func_70445_o())), p);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private ItemStack shiftStoreItem(ItemStack input) {
        if (this.getPowerSource() == null || this.getCellInventory() == null) {
            return input;
        }
        IAEItemStack ais = Api.INSTANCE.storage().poweredInsert(this.getPowerSource(), this.getCellInventory(), AEApi.instance().storage().createItemStack(input), this.getActionSource());
        if (ais == null) {
            return null;
        }
        return ais.getItemStack();
    }

    private void updateSlot(Slot clickSlot) {
        this.func_75142_b();
    }

    private void sendCustomName() {
        if (!this.sentCustomName) {
            this.sentCustomName = true;
            if (Platform.isServer()) {
                ICustomNameObject name = null;
                if (this.obj instanceof ICustomNameObject) {
                    name = (ICustomNameObject)this.obj;
                }
                if (this instanceof ICustomNameObject) {
                    name = (ICustomNameObject)this;
                }
                if (name != null) {
                    if (name.hasCustomName()) {
                        this.setCustomName(name.getCustomName());
                    }
                    if (this.getCustomName() != null) {
                        try {
                            NetworkHandler.instance().sendTo(new PacketValueConfig("CustomName", this.getCustomName()), (EntityPlayerMP)this.getInventoryPlayer().field_70458_d);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    public void swapSlotContents(int slotA, int slotB) {
        ItemStack testB;
        Slot a = this.func_75139_a(slotA);
        Slot b = this.func_75139_a(slotB);
        if (a == null || b == null) {
            return;
        }
        ItemStack isA = a.func_75211_c();
        ItemStack isB = b.func_75211_c();
        if (isA == null && isB == null) {
            return;
        }
        if (isA != null && !a.func_82869_a(this.getInventoryPlayer().field_70458_d)) {
            return;
        }
        if (isB != null && !b.func_82869_a(this.getInventoryPlayer().field_70458_d)) {
            return;
        }
        if (isB != null && !a.func_75214_a(isB)) {
            return;
        }
        if (isA != null && !b.func_75214_a(isA)) {
            return;
        }
        ItemStack testA = isB == null ? null : isB.func_77946_l();
        ItemStack itemStack = testB = isA == null ? null : isA.func_77946_l();
        if (testA != null && testA.field_77994_a > a.func_75219_a()) {
            if (testB != null) {
                return;
            }
            int totalA = testA.field_77994_a;
            testA.field_77994_a = a.func_75219_a();
            testB = testA.func_77946_l();
            testB.field_77994_a = totalA - testA.field_77994_a;
        }
        if (testB != null && testB.field_77994_a > b.func_75219_a()) {
            if (testA != null) {
                return;
            }
            int totalB = testB.field_77994_a;
            testB.field_77994_a = b.func_75219_a();
            testA = testB.func_77946_l();
            testA.field_77994_a = totalB - testA.field_77994_a;
        }
        a.func_75215_d(testA);
        b.func_75215_d(testB);
    }

    public void onUpdate(String field, Object oldValue, Object newValue) {
    }

    public void onSlotChange(Slot s) {
    }

    public boolean isValidForSlot(Slot s, ItemStack i) {
        return true;
    }

    public IMEInventoryHandler<IAEItemStack> getCellInventory() {
        return this.cellInv;
    }

    public void setCellInventory(IMEInventoryHandler<IAEItemStack> cellInv) {
        this.cellInv = cellInv;
    }

    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public InventoryPlayer getInventoryPlayer() {
        return this.inventoryPlayer;
    }

    public boolean isValidContainer() {
        return this.isContainerValid;
    }

    public void setValidContainer(boolean isContainerValid) {
        this.isContainerValid = isContainerValid;
    }

    public ContainerOpenContext getOpenContext() {
        return this.openContext;
    }

    public void setOpenContext(ContainerOpenContext openContext) {
        this.openContext = openContext;
    }

    public IEnergySource getPowerSource() {
        return this.powerSrc;
    }

    public void setPowerSource(IEnergySource powerSrc) {
        this.powerSrc = powerSrc;
    }
}

