/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.utils.datastructures;

import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.backend.entries.IItemStackMaker;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.items.itemmatching.IMatcher;
import com.rwtema.extrautils2.items.itemmatching.IMatcherMaker;
import com.rwtema.extrautils2.network.XUPacketBuffer;
import com.rwtema.extrautils2.utils.helpers.NBTCopyHelper;
import com.rwtema.extrautils2.utils.helpers.NullHelper;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class ItemRef
implements IMatcher,
IItemStackMaker,
IMatcherMaker {
    public static final ItemRef NULL = new NullRef();
    private static final LoadingCache<Item, ItemRef> loadingCache = CacheBuilder.newBuilder().maximumSize(200L).build(CacheLoader.from(t -> {
        if (t == null) {
            return NULL;
        }
        return new Simple((Item)t);
    }));

    private ItemRef() {
    }

    public static ItemRef read(XUPacketBuffer buffer) {
        byte b = buffer.readByte();
        switch (b) {
            default: {
                return NULL;
            }
            case 1: {
                return Simple.readFromPacket(buffer);
            }
            case 2: {
                return Meta.readFromPacket(buffer);
            }
            case 3: {
                return SimpleNBT.readFromPacket(buffer);
            }
            case 4: 
        }
        return MetaNBT.readFromPacket(buffer);
    }

    public static ItemRef wrapCrafting(ItemStack stack) {
        if (StackHelper.isNull(stack)) {
            return NULL;
        }
        Item item = ItemRef.getItem(stack);
        if (item == null) {
            return NULL;
        }
        if (item.func_77614_k() && stack.func_77960_j() != Short.MAX_VALUE) {
            return new Meta(item, stack.func_77952_i());
        }
        return ItemRef.createSimpleItem(item);
    }

    public static ItemRef wrapNoNBT(ItemStack stack) {
        if (StackHelper.isNull(stack)) {
            return NULL;
        }
        Item item = ItemRef.getItem(stack);
        if (item == null) {
            return NULL;
        }
        if (item.func_77614_k() || item.func_77645_m()) {
            return new Meta(item, stack.func_77952_i());
        }
        return ItemRef.createSimpleItem(item);
    }

    @Nullable
    public static Item getItem(ItemStack stack) {
        return NullHelper.nullable(stack.func_77973_b());
    }

    public static ItemRef wrap(ItemStack stack) {
        if (StackHelper.isNull(stack)) {
            return NULL;
        }
        Item item = ItemRef.getItem(stack);
        if (item == null) {
            return NULL;
        }
        if (item.func_77614_k() || item.func_77645_m()) {
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt == null) {
                return new Meta(item, stack.func_77952_i());
            }
            return new MetaNBT(item, stack.func_77952_i(), nbt);
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            return ItemRef.createSimpleItem(item);
        }
        return new SimpleNBT(item, nbt);
    }

    @Nonnull
    private static ItemRef createSimpleItem(@Nonnull Item item) {
        return (ItemRef)loadingCache.getUnchecked((Object)item);
    }

    public static ItemRef wrap(Item item) {
        return ItemRef.createSimpleItem(item);
    }

    public static ItemRef wrap(Block block) {
        Item item = Item.func_150898_a((Block)block);
        if (item == StackHelper.nullItem()) {
            return NULL;
        }
        return ItemRef.createSimpleItem(item);
    }

    @Override
    public ItemStack newStack() {
        return this.createItemStack(1);
    }

    public ItemRef toCraftingVersion() {
        return this;
    }

    public ItemRef toNoMetaVersion() {
        return this;
    }

    @Override
    public boolean matchesItemStack(@Nullable ItemStack input) {
        return StackHelper.isNonNull(input) && this.equalsItemStack(input);
    }

    public ItemStack createItemStack(int amount) {
        ItemStack itemStack = new ItemStack(this.getItem(), amount, this.getMeta());
        itemStack.func_77982_d(this.getTagCompound());
        return itemStack;
    }

    public abstract Item getItem();

    public abstract int getMeta();

    public abstract NBTTagCompound getTagCompound();

    public abstract int getTagHash();

    public void write(XUPacketBuffer buffer) {
        this.writeToPacket(buffer);
    }

    protected abstract void writeToPacket(XUPacketBuffer var1);

    public abstract boolean equalsItemStack(ItemStack var1);

    public abstract boolean hasMeta();

    public String getDisplayName() {
        ItemStack itemStack = this.createItemStack(1);
        return itemStack.func_82833_r();
    }

    public int getMaxStackSize() {
        return this.createItemStack(1).func_77976_d();
    }

    @Override
    @Nonnull
    public Collection<ItemStack> getSubItems() {
        return ImmutableList.of((Object)this.createItemStack(1));
    }

    @Override
    public ItemStack getMainStack() {
        return this.newStack();
    }

    private static class NullRef
    extends ItemRef {
        private NullRef() {
        }

        @Override
        public boolean matchesItemStack(@Nullable ItemStack input) {
            return StackHelper.isNull(input) || super.matchesItemStack(input);
        }

        @Override
        public int getMaxStackSize() {
            return 0;
        }

        @Override
        @Nonnull
        public Collection<ItemStack> getSubItems() {
            return Collections.emptyList();
        }

        @Override
        public ItemStack createItemStack(int amount) {
            return StackHelper.empty();
        }

        @Override
        public String getDisplayName() {
            return "[Null]";
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public Item getItem() {
            return null;
        }

        @Override
        public int getMeta() {
            return 0;
        }

        @Override
        public NBTTagCompound getTagCompound() {
            return null;
        }

        @Override
        public int getTagHash() {
            return 0;
        }

        @Override
        protected void writeToPacket(XUPacketBuffer buffer) {
            buffer.writeByte(0);
        }

        @Override
        public boolean equalsItemStack(ItemStack stack) {
            return StackHelper.isNull(stack) || NullRef.getItem(stack) == null;
        }

        @Override
        public boolean hasMeta() {
            return false;
        }
    }

    private static final class MetaNBT
    extends SimpleNBT {
        private final int meta;

        public MetaNBT(@Nonnull Item item, int meta, @Nonnull NBTTagCompound tag) {
            super(item, tag);
            this.meta = meta;
        }

        public MetaNBT(@Nonnull Item item, int meta, @Nonnull NBTTagCompound tag, int tagHash) {
            super(item, tag, tagHash);
            this.meta = meta;
        }

        public static ItemRef readFromPacket(XUPacketBuffer buffer) {
            Item item = NullHelper.nullable(Item.func_150899_d((int)buffer.readUnsignedShort()));
            short meta = buffer.readShort();
            int tagHash = buffer.readInt();
            NBTTagCompound nbt = buffer.readNBT();
            if (item == null) {
                return NULL;
            }
            if (nbt == null) {
                return new Meta(item, meta);
            }
            return new MetaNBT(item, meta, nbt, tagHash);
        }

        @Override
        public ItemRef toNoMetaVersion() {
            return ItemRef.createSimpleItem(this.item);
        }

        @Override
        public ItemRef toCraftingVersion() {
            if (!this.item.func_77614_k()) {
                return ItemRef.createSimpleItem(this.item);
            }
            return new Meta(this.item, this.meta);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (MetaNBT.class != o.getClass()) {
                return false;
            }
            MetaNBT metaNBT = (MetaNBT)o;
            return this.meta == metaNBT.meta && this.tagHash == metaNBT.tagHash && this.item == metaNBT.item && this.tagEquals(metaNBT.tag);
        }

        @Override
        public int getMeta() {
            return this.meta;
        }

        @Override
        public int hashCode() {
            int result = System.identityHashCode(this.item) + 1;
            result = 31 * result + this.tagHash;
            result = 31 * result + this.meta;
            return result;
        }

        @Override
        public boolean equalsItemStack(ItemStack stack) {
            return StackHelper.isNonNull(stack) && this.item == MetaNBT.getItem(stack) && this.meta == stack.func_77952_i() && stack.func_77942_o() && this.tagEquals(stack.func_77978_p());
        }

        @Override
        protected void writeToPacket(XUPacketBuffer buffer) {
            buffer.writeByte(4);
            buffer.writeShort(Item.func_150891_b((Item)this.item));
            buffer.writeShort(this.meta);
            this.writeNBT(buffer);
        }
    }

    private static class SimpleNBT
    extends ItemRef {
        @Nonnull
        protected final Item item;
        @Nonnull
        protected final NBTTagCompound tag;
        protected final int tagHash;
        byte[] packetBytes = null;

        public SimpleNBT(@Nonnull Item item, @Nonnull NBTTagCompound tag) {
            this.item = item;
            NBTCopyHelper.ResultNBT resultNBT = NBTCopyHelper.copyAndHashNBT(tag);
            this.tag = resultNBT.copy;
            this.tagHash = resultNBT.hash;
        }

        public SimpleNBT(@Nonnull Item item, @Nonnull NBTTagCompound tag, int tagHash) {
            this.item = item;
            this.tag = tag;
            this.tagHash = tagHash;
        }

        public static ItemRef readFromPacket(XUPacketBuffer buffer) {
            Item item = NullHelper.nullable(Item.func_150899_d((int)buffer.readUnsignedShort()));
            int tagHash = buffer.readInt();
            NBTTagCompound nbt = buffer.readNBT();
            if (item == null) {
                return NULL;
            }
            if (nbt == null) {
                return ItemRef.wrap(item);
            }
            return new SimpleNBT(item, nbt, tagHash);
        }

        @Override
        public ItemRef toCraftingVersion() {
            return ItemRef.createSimpleItem(this.item);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (SimpleNBT.class != o.getClass()) {
                return false;
            }
            SimpleNBT simpleNbt = (SimpleNBT)o;
            if (this.item == simpleNbt.item && this.tagHash == simpleNbt.tagHash && this.tagEquals(simpleNbt.tag)) {
                if (this.packetBytes == null) {
                    this.packetBytes = simpleNbt.packetBytes;
                } else if (simpleNbt.packetBytes == null) {
                    simpleNbt.packetBytes = this.packetBytes;
                }
                return true;
            }
            return false;
        }

        public boolean tagEquals(NBTTagCompound otherTag) {
            return this.tag == otherTag || NBTCopyHelper.equalNBT(this.tag, otherTag);
        }

        public int hashCode() {
            return System.identityHashCode(this.item) * 31 + this.tagHash;
        }

        @Override
        public boolean equalsItemStack(ItemStack stack) {
            return StackHelper.isNonNull(stack) && this.item == SimpleNBT.getItem(stack) && stack.func_77942_o() && this.tagEquals(stack.func_77978_p());
        }

        @Override
        public boolean hasMeta() {
            return false;
        }

        @Override
        @Nonnull
        public Item getItem() {
            return this.item;
        }

        @Override
        public int getMeta() {
            return 0;
        }

        @Override
        public NBTTagCompound getTagCompound() {
            return this.tag;
        }

        @Override
        public int getTagHash() {
            return this.tagHash;
        }

        @Override
        protected void writeToPacket(XUPacketBuffer buffer) {
            buffer.writeByte(3);
            buffer.writeShort(Item.func_150891_b((Item)this.item));
            this.writeNBT(buffer);
        }

        protected void writeNBT(XUPacketBuffer buffer) {
            buffer.writeInt(this.tagHash);
            if (this.packetBytes == null) {
                if (this.item.func_77651_p() || this.item.func_77645_m()) {
                    ItemStack stack = new ItemStack(this.item);
                    stack.func_77982_d(this.tag);
                    NBTTagCompound shareTag = NullHelper.nullable(this.item.getNBTShareTag(stack));
                    if (shareTag == null) {
                        this.packetBytes = new byte[0];
                    } else {
                        try {
                            this.packetBytes = XUPacketBuffer.compress(shareTag);
                        }
                        catch (IOException e) {
                            throw Throwables.propagate((Throwable)e);
                        }
                    }
                } else {
                    this.packetBytes = new byte[0];
                }
                if (this.packetBytes == null) {
                    buffer.writeShort(0);
                    return;
                }
            }
            buffer.writeShort(this.packetBytes.length);
            buffer.writeBytes(this.packetBytes);
        }
    }

    private static final class Meta
    extends ItemRef {
        @Nonnull
        private final Item item;
        private final int meta;

        public Meta(@Nonnull Item item, int meta) {
            this.item = item;
            this.meta = meta;
        }

        public static ItemRef readFromPacket(XUPacketBuffer buffer) {
            Item item = NullHelper.nullable(Item.func_150899_d((int)buffer.readShort()));
            short damage = buffer.readShort();
            if (item == null) {
                return NULL;
            }
            return new Meta(item, damage);
        }

        @Override
        public ItemRef toCraftingVersion() {
            if (!this.item.func_77614_k()) {
                return ItemRef.createSimpleItem(this.item);
            }
            return this;
        }

        @Override
        public ItemRef toNoMetaVersion() {
            return ItemRef.createSimpleItem(this.item);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (Meta.class != o.getClass()) {
                return false;
            }
            Meta meta = (Meta)o;
            return this.meta == meta.meta && this.item == meta.item;
        }

        public int hashCode() {
            int result = System.identityHashCode(this.item);
            result = 31 * result + this.meta;
            return result;
        }

        @Override
        public boolean equalsItemStack(ItemStack stack) {
            return StackHelper.isNonNull(stack) && this.item == Meta.getItem(stack) && this.meta == stack.func_77952_i() && !stack.func_77942_o();
        }

        @Override
        public boolean hasMeta() {
            return true;
        }

        @Override
        @Nonnull
        public Item getItem() {
            return this.item;
        }

        @Override
        public int getMeta() {
            return this.meta;
        }

        @Override
        public NBTTagCompound getTagCompound() {
            return null;
        }

        @Override
        public int getTagHash() {
            return 0;
        }

        @Override
        protected void writeToPacket(XUPacketBuffer buffer) {
            buffer.writeByte(2);
            buffer.writeShort(Item.func_150891_b((Item)this.item));
            buffer.writeShort(this.meta);
        }
    }

    private static final class Simple
    extends ItemRef {
        @Nonnull
        private final Item item;

        public Simple(@Nonnull Item item) {
            this.item = item;
        }

        public static ItemRef readFromPacket(XUPacketBuffer buffer) {
            Item item = NullHelper.nullable(Item.func_150899_d((int)buffer.readUnsignedShort()));
            if (item == null) {
                return NULL;
            }
            return ItemRef.createSimpleItem(item);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (Simple.class != o.getClass()) {
                return false;
            }
            Simple simple = (Simple)o;
            return this.item == simple.item;
        }

        public int hashCode() {
            return System.identityHashCode(this.item);
        }

        @Override
        @Nonnull
        public Item getItem() {
            return this.item;
        }

        @Override
        public int getMeta() {
            return 0;
        }

        @Override
        public NBTTagCompound getTagCompound() {
            return null;
        }

        @Override
        public int getTagHash() {
            return 0;
        }

        @Override
        protected void writeToPacket(XUPacketBuffer buffer) {
            buffer.writeByte(1);
            buffer.writeShort(Item.func_150891_b((Item)this.item));
        }

        @Override
        public boolean equalsItemStack(ItemStack stack) {
            return StackHelper.isNonNull(stack) && this.item == Simple.getItem(stack) && !stack.func_77942_o();
        }

        @Override
        public boolean hasMeta() {
            return false;
        }

        @Override
        @Nonnull
        public Collection<ItemStack> getSubItems() {
            return ExtraUtils2.proxy.getSubItems(this.item);
        }
    }
}

