/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.transfernodes;

import com.google.common.collect.ImmutableList;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.gui.backend.IDynamicHandler;
import com.rwtema.extrautils2.transfernodes.GrocketPipeFilter;
import com.rwtema.extrautils2.transfernodes.GrocketType;
import com.rwtema.extrautils2.transfernodes.IBuffer;
import com.rwtema.extrautils2.transfernodes.ItemGrocket;
import com.rwtema.extrautils2.transfernodes.TileTransferHolder;
import com.rwtema.extrautils2.utils.CapGetter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;

public abstract class Grocket
implements ITickable {
    public TileTransferHolder holder;
    public EnumFacing side;
    @Nullable
    private HashMap<String, INBTSerializable> nbtHandlers;

    public void func_73660_a() {
    }

    @Nonnull
    public BoxModel getWorldModel(EnumFacing facing) {
        GrocketType type = this.getType();
        BoxModel model = type.cache[facing.ordinal()];
        if (model == null) {
            type.cache[facing.ordinal()] = model = type.createBaseModel(facing);
        }
        return model;
    }

    public abstract GrocketType getType();

    public boolean onActivated(EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this instanceof IDynamicHandler) {
            if (!this.holder.func_145831_w().field_72995_K) {
                this.holder.openGui(playerIn, this);
            }
            return true;
        }
        return false;
    }

    public void validate() {
    }

    public void invalidate() {
    }

    public List<ItemStack> getDrops() {
        return ImmutableList.of((Object)this.getBaseDrop());
    }

    public <T> T getInterface(TileEntity tileEntity, CapGetter<T> capability) {
        return capability.getInterface((ICapabilityProvider)tileEntity, this.side.func_176734_d());
    }

    public <T> boolean hasInterface(TileEntity tileEntity, CapGetter<T> capability) {
        return tileEntity != null && capability.hasInterface((ICapabilityProvider)tileEntity, this.side.func_176734_d());
    }

    public void writeToNBT(NBTTagCompound tag) {
        if (this.nbtHandlers != null) {
            for (Map.Entry<String, INBTSerializable> entry2 : this.nbtHandlers.entrySet()) {
                tag.func_74782_a(entry2.getKey(), entry2.getValue().serializeNBT());
            }
        }
    }

    public void readFromNBT(NBTTagCompound tag) {
        if (this.nbtHandlers != null) {
            for (Map.Entry<String, INBTSerializable> entry2 : this.nbtHandlers.entrySet()) {
                NBTBase subTag = tag.func_74781_a(entry2.getKey());
                if (subTag == null) continue;
                entry2.getValue().deserializeNBT(subTag);
            }
        }
    }

    public void onPlaced(EntityPlayer player) {
    }

    protected <T extends INBTSerializable> T registerNBT(String key, T t) {
        if (this.nbtHandlers == null) {
            this.nbtHandlers = new HashMap();
        }
        this.nbtHandlers.put(key, t);
        return t;
    }

    public void markDirty() {
        if (this.holder != null) {
            this.holder.func_70296_d();
        }
    }

    public abstract float getPower();

    public boolean shouldPipeHaveNozzle(EnumFacing facing) {
        return false;
    }

    public ItemStack getBaseDrop() {
        return new ItemStack((Item)ItemGrocket.instance, 1, this.getType().ordinal());
    }

    public boolean shouldBlock(IBuffer buffer) {
        return false;
    }

    public GrocketPipeFilter.Priority getPriority() {
        return GrocketPipeFilter.Priority.NORMAL;
    }

    public boolean blockPipeConnection() {
        return true;
    }

    public boolean blockTileConnection() {
        return false;
    }
}

