/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.tile;

import com.google.common.collect.HashMultimap;
import com.mojang.realmsclient.gui.ChatFormatting;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.blocks.BlockTerraformer;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.DynamicContainerTile;
import com.rwtema.extrautils2.gui.backend.IDynamicHandler;
import com.rwtema.extrautils2.gui.backend.WidgetEnergyStorage;
import com.rwtema.extrautils2.gui.backend.WidgetProgressArrowBase;
import com.rwtema.extrautils2.gui.backend.WidgetSlotItemHandler;
import com.rwtema.extrautils2.gui.backend.WidgetText;
import com.rwtema.extrautils2.gui.backend.WidgetTextData;
import com.rwtema.extrautils2.itemhandler.ItemHandlerFilterInsertion;
import com.rwtema.extrautils2.itemhandler.SingleStackHandler;
import com.rwtema.extrautils2.items.itemmatching.IMatcherMaker;
import com.rwtema.extrautils2.network.XUPacketBuffer;
import com.rwtema.extrautils2.power.energy.XUEnergyStorage;
import com.rwtema.extrautils2.tile.TilePower;
import com.rwtema.extrautils2.tile.TileTerraformer;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.datastructures.ItemRef;
import com.rwtema.extrautils2.utils.datastructures.NBTSerializable;
import com.rwtema.extrautils2.utils.helpers.CollectionHelper;
import com.rwtema.extrautils2.utils.helpers.ColorHelper;
import com.rwtema.extrautils2.utils.helpers.StringHelper;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class TileTerraformerClimograph
extends TilePower
implements ITickable,
IDynamicHandler {
    public static final HashMultimap<BlockTerraformer.Type, Pair<IMatcherMaker, Integer>> inputTypes = HashMultimap.create();
    public static final int INCREASE_MULTIPLIER = 40;
    static final int POWER_PER_OPERATION = 1000;
    public Boolean hasAntenna;
    public NBTSerializable.Int level = this.registerNBT("level", new NBTSerializable.Int());
    public XUEnergyStorage energy = this.registerNBT("energy", new XUEnergyStorage(20000));
    int sprinkerActive = 0;
    private BlockTerraformer.Type type;
    ItemHandlerFilterInsertion<SingleStackHandler> handler = new ItemHandlerFilterInsertion<SingleStackHandler>((SingleStackHandler)this.registerNBT("contents", new SingleStackHandler(){

        @Override
        protected int getStackLimit(@Nonnull ItemStack stack) {
            if (stack.func_77973_b().hasContainerItem(stack)) {
                return 1;
            }
            return super.getStackLimit(stack);
        }

        @Override
        protected void onContentsChanged() {
            TileTerraformerClimograph.this.func_70296_d();
        }
    })){

        @Override
        public boolean isValid(@Nonnull ItemStack stack) {
            for (Pair pair : inputTypes.get((Object)TileTerraformerClimograph.this.getType())) {
                if (!((IMatcherMaker)pair.getKey()).matchesItemStack(stack)) continue;
                return true;
            }
            return false;
        }
    };
    public static Consumer<ItemStack> lookUpRecipes;

    public static void register(BlockTerraformer.Type type, IMatcherMaker matcher, int amount) {
        inputTypes.put((Object)type, (Object)Pair.of((Object)matcher, (Object)amount));
    }

    private static void registerEntry(BlockTerraformer.Type heater, Pair<IMatcherMaker, Integer> of) {
        inputTypes.put((Object)heater, of);
    }

    @Override
    @Nullable
    public IEnergyStorage getEnergyHandler(EnumFacing facing) {
        return this.energy;
    }

    public BlockTerraformer.Type getType() {
        if (this.type == null) {
            this.type = (BlockTerraformer.Type)((Object)this.getBlockState().func_177229_b((IProperty)BlockTerraformer.TYPE));
        }
        return this.type;
    }

    @Override
    public IItemHandler getItemHandler(EnumFacing facing) {
        return this.handler;
    }

    @Override
    public void onNeighborBlockChange(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        this.hasAntenna = null;
    }

    @Override
    public void addToDescriptionPacket(XUPacketBuffer packet) {
        super.addToDescriptionPacket(packet);
        packet.writeInt(this.sprinkerActive);
    }

    @Override
    public void handleDescriptionPacket(XUPacketBuffer packet) {
        super.handleDescriptionPacket(packet);
        this.sprinkerActive = packet.readInt();
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            if (this.sprinkerActive > 0 && this.hasAntennaAbove()) {
                int[] colors = this.getType().colors;
                if (colors == null || colors.length == 0) {
                    return;
                }
                for (int i = 0; i < 10; ++i) {
                    Random rand = this.field_145850_b.field_73012_v;
                    EnumFacing facing = CollectionHelper.getRandomElementArray(EnumFacing.field_176754_o);
                    double x = (double)this.field_174879_c.func_177958_n() + 0.5 + (double)((float)(facing.func_82601_c() * 5) + rand.nextFloat() * 2.0f - 1.0f) / 16.0;
                    double y = (double)(this.field_174879_c.func_177956_o() + 1) + (5.0 + (double)rand.nextFloat() * 11.5) / 16.0;
                    double z = (double)this.field_174879_c.func_177952_p() + 0.5 + (double)((float)(facing.func_82599_e() * 5) + rand.nextFloat() * 2.0f - 1.0f) / 16.0;
                    int color = colors[rand.nextInt(colors.length)];
                    double r = ColorHelper.getRF(color);
                    double g = ColorHelper.getGF(color);
                    double b = ColorHelper.getBF(color);
                    if (r == 0.0) {
                        r = 1.0E-4;
                    }
                    this.field_145850_b.func_175688_a(EnumParticleTypes.REDSTONE, x, y, z, r, g, b, new int[0]);
                }
            }
            return;
        }
        if (this.sprinkerActive > 0) {
            --this.sprinkerActive;
            this.markForUpdate();
        }
        if (this.hasAntenna == null) {
            this.hasAntenna = this.hasAntennaAbove();
        }
        if (this.hasAntenna == Boolean.FALSE) {
            return;
        }
        ItemStack stack = ((SingleStackHandler)this.handler.original).extractItem(0, 1, true);
        if (StackHelper.isNonNull(stack)) {
            int increase = 0;
            for (Pair pair : inputTypes.get((Object)this.getType())) {
                if (!((IMatcherMaker)pair.getKey()).matchesItemStack(stack)) continue;
                increase = Math.max(increase, (Integer)pair.getValue());
            }
            if (increase > 0) {
                if (this.level.value > (increase *= 40) / 2) {
                    return;
                }
                if (this.energy.extractEnergy(1000, true) != 1000) {
                    return;
                }
                this.energy.extractEnergy(1000, false);
                if (stack.func_77973_b().hasContainerItem(stack)) {
                    ((SingleStackHandler)this.handler.original).setStack(stack.func_77973_b().getContainerItem(stack));
                } else {
                    ((SingleStackHandler)this.handler.original).extractItem(0, 1, false);
                }
                this.level.value += increase;
            }
        }
    }

    private boolean hasAntennaAbove() {
        return this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()) == ((BlockTerraformer)XU2Entries.terraformer.value).func_176223_P().func_177226_a(BlockTerraformer.TYPE, (Comparable)((Object)BlockTerraformer.Type.ANTENNA));
    }

    @Override
    public DynamicContainer getDynamicContainer(int ID2, EntityPlayer player, World world, int x, int y, int z) {
        return new Container(this, player);
    }

    @Override
    public float getPower() {
        return Float.NaN;
    }

    @Override
    public void onPowerChanged() {
    }

    static {
        TileTerraformerClimograph.register(BlockTerraformer.Type.COOLER, ItemRef.wrap(Blocks.field_150432_aD), 8);
        TileTerraformerClimograph.register(BlockTerraformer.Type.COOLER, ItemRef.wrap(Blocks.field_150403_cj), 8);
        TileTerraformerClimograph.register(BlockTerraformer.Type.COOLER, ItemRef.wrap(Items.field_151131_as), 1);
        TileTerraformerClimograph.register(BlockTerraformer.Type.HEATER, ItemRef.wrap(Items.field_151129_at), 4);
        TileTerraformerClimograph.register(BlockTerraformer.Type.HEATER, ItemRef.wrap(Items.field_151072_bj), 8);
        TileTerraformerClimograph.registerEntry(BlockTerraformer.Type.HEATER, (Pair<IMatcherMaker, Integer>)Pair.of((Object)ItemRef.wrap(Items.field_151065_br), (Object)1));
        TileTerraformerClimograph.register(BlockTerraformer.Type.HUMIDIFIER, ItemRef.wrap(Items.field_151131_as), 1);
        TileTerraformerClimograph.register(BlockTerraformer.Type.HUMIDIFIER, new IMatcherMaker.MatcherMakerOreDic("sugarcane"), 4);
        TileTerraformerClimograph.register(BlockTerraformer.Type.HUMIDIFIER, ItemRef.wrap(Blocks.field_150392_bi), 8);
        TileTerraformerClimograph.register(BlockTerraformer.Type.DEHUMIDIFIER, new IMatcherMaker.MatcherMakerOreDic("sand"), 1);
        TileTerraformerClimograph.register(BlockTerraformer.Type.DEHUMIDIFIER, new IMatcherMaker.MatcherMakerOreDic("blockCactus"), 4);
        TileTerraformerClimograph.register(BlockTerraformer.Type.MAGIC_INFUSER, ItemRef.wrap(Items.field_151062_by), 4);
        TileTerraformerClimograph.register(BlockTerraformer.Type.MAGIC_INFUSER, ItemRef.wrap((Item)Items.field_151134_bR), 16);
        TileTerraformerClimograph.register(BlockTerraformer.Type.MAGIC_INFUSER, new IMatcherMaker.MatcherMakerOreDic("gemLapis"), 1);
        TileTerraformerClimograph.register(BlockTerraformer.Type.MAGIC_INFUSER, ItemRef.wrap(XU2Entries.magical_wood.get()), 16);
        TileTerraformerClimograph.register(BlockTerraformer.Type.MAGIC_ABSORBTION, ItemRef.wrap(Items.field_151122_aG), 2);
        TileTerraformerClimograph.register(BlockTerraformer.Type.MAGIC_ABSORBTION, new IMatcherMaker.MatcherMakerOreDic("ingotGold"), 2);
        TileTerraformerClimograph.register(BlockTerraformer.Type.DEHOSTILIFIER, ItemRef.wrap(Items.field_151156_bN), 16);
        lookUpRecipes = null;
    }

    public static class Container
    extends DynamicContainerTile {
        public Container(final TileTerraformerClimograph tile, EntityPlayer player) {
            super(tile);
            this.addTitle(XU2Entries.terraformer.newStack(1, ((BlockTerraformer)XU2Entries.terraformer.value).func_176223_P().func_177226_a(BlockTerraformer.TYPE, (Comparable)((Object)tile.getType()))).func_82833_r());
            int y = 29;
            WidgetProgressArrowBase w = new WidgetProgressArrowBase(74, 30, 0);
            this.addWidget(w);
            this.addWidget(WidgetProgressArrowBase.getJEIWidget(lookUpRecipes != null ? () -> lookUpRecipes.accept(TileTerraformer.getStack(tile.getType())) : null, w));
            this.addWidget(new WidgetSlotItemHandler(tile.handler.getGUIVariant(), 0, w.getX() - 18 - 4, 29));
            this.addWidget(new WidgetTextData(w.getX() + w.getW() + 6, 34, 60, 9, 1, 0x404040){

                @Override
                public void addToDescription(XUPacketBuffer packet) {
                    packet.writeInt(tile.level.value);
                }

                @Override
                protected String constructText(XUPacketBuffer packet) {
                    return StringHelper.format(packet.readInt()) + " TF";
                }
            });
            this.addWidget(new WidgetText(55, 55, 60, 9, 0, 0x600000, ""){

                @Override
                @SideOnly(value=Side.CLIENT)
                public String getMsgClient() {
                    if (!tile.hasAntennaAbove()) {
                        return ChatFormatting.RED + Lang.translate("Missing antenna");
                    }
                    return "";
                }
            });
            this.addWidget(new WidgetEnergyStorage(this.width - 4 - 18, 17, (IEnergyStorage)tile.energy));
            this.cropAndAddPlayerSlots(player.field_71071_by);
            this.validate();
        }
    }
}

