/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.tile;

import com.rwtema.extrautils2.asm.Lighting;
import com.rwtema.extrautils2.lighting.ILight;
import com.rwtema.extrautils2.network.XUPacketBuffer;
import com.rwtema.extrautils2.tile.XUTile;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

public class TileLight
extends XUTile
implements ILight {
    static final int r = 96;
    public boolean active = false;

    @Override
    public World getLightWorld() {
        return this.field_145850_b;
    }

    private void updateLight() {
        this.field_145850_b.func_147458_c(this.field_174879_c.func_177958_n() - 96, this.field_174879_c.func_177956_o() - 96, this.field_174879_c.func_177952_p() - 96, this.field_174879_c.func_177958_n() + 96, this.field_174879_c.func_177956_o() + 96, this.field_174879_c.func_177952_p() + 96);
    }

    @Override
    public void addToDescriptionPacket(XUPacketBuffer packet) {
        packet.writeBoolean(this.active);
    }

    @Override
    public void handleDescriptionPacket(XUPacketBuffer packet) {
        boolean b = packet.readBoolean();
        if (b != this.active) {
            this.active = b;
            this.updateLight();
        }
    }

    @Override
    public float getLightOffset(BlockPos pos, EnumSkyBlock type) {
        if (!this.active) {
            return 0.0f;
        }
        return Math.max(15 - this.getRange(pos) * 15 / 96, 0);
    }

    public int getRange(BlockPos pos) {
        return Math.abs(this.field_174879_c.func_177958_n() - pos.func_177958_n()) + Math.abs(this.field_174879_c.func_177956_o() - pos.func_177956_o()) + Math.abs(this.field_174879_c.func_177952_p() - pos.func_177952_p());
    }

    @Override
    public EnumSkyBlock[] getLightType() {
        return new EnumSkyBlock[]{EnumSkyBlock.BLOCK};
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        Lighting.unregister(this, Lighting.plusLights);
        if (this.field_145850_b.field_72995_K) {
            this.updateLight();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        Lighting.unregister(this, Lighting.plusLights);
        if (this.field_145850_b.field_72995_K) {
            this.updateLight();
        }
    }

    public void onLoad() {
        Lighting.register(this, Lighting.plusLights);
    }
}

