/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.machine;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.rwtema.extrautils2.api.machine.IMachineRecipe;
import com.rwtema.extrautils2.api.machine.MachineSlot;
import com.rwtema.extrautils2.api.machine.MachineSlotFluid;
import com.rwtema.extrautils2.api.machine.MachineSlotItem;
import com.rwtema.extrautils2.api.machine.XUMachineEnchanter;
import com.rwtema.extrautils2.compatibility.CompatHelper;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.utils.XURandom;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Pair;

public class MechEnchantmentRecipe
implements IMachineRecipe {
    public final int processing_time;
    final EnchantType enchantType;
    final MachineSlotItem input;
    final MachineSlotItem input_lapis;
    final MachineSlotItem output;
    final List<ItemStack> ores;

    public MechEnchantmentRecipe(int processing_time, List<ItemStack> ores, EnchantType enchantType) {
        this(enchantType, XUMachineEnchanter.INPUT, XUMachineEnchanter.INPUT_LAPIS, XUMachineEnchanter.OUTPUT, processing_time, ores);
    }

    public MechEnchantmentRecipe(EnchantType enchantType, MachineSlotItem input, MachineSlotItem input_lapis, MachineSlotItem output, int processing_time, List<ItemStack> ores) {
        this.enchantType = enchantType;
        this.input = input;
        this.input_lapis = input_lapis;
        this.output = output;
        this.processing_time = processing_time;
        this.ores = ores;
    }

    @Override
    public List<Pair<Map<MachineSlotItem, List<ItemStack>>, Map<MachineSlotFluid, List<FluidStack>>>> getJEIInputItemExamples() {
        return ImmutableList.of((Object)Pair.of((Object)ImmutableMap.builder().put((Object)this.input, ImmutableList.of((Object)Items.field_151041_m, (Object)Items.field_151038_n, (Object)Items.field_151053_p, (Object)Items.field_151040_l, (Object)Items.field_151037_a, (Object)Items.field_151036_c, (Object)Items.field_151030_Z, (Object)Items.field_151028_Y, (Object)Items.field_151167_ab, (Object)Items.field_151165_aa, (Object)Items.field_151010_B, (Object)Items.field_151011_C, (Object[])new Item[]{Items.field_151006_E, Items.field_151171_ah, Items.field_151169_ag, Items.field_151151_aj, Items.field_151149_ai, Items.field_151048_u, Items.field_151047_v, Items.field_151056_x, Items.field_151163_ad, Items.field_151161_ac, Items.field_151175_af, Items.field_151173_ae}).stream().map(ItemStack::new).collect(Collectors.toList())).put((Object)this.input_lapis, this.ores).build(), (Object)ImmutableMap.of()));
    }

    @Override
    public boolean allowInputItem(MachineSlotItem slot, ItemStack stack, Map<MachineSlotItem, ItemStack> existingItems, Map<MachineSlotFluid, FluidStack> existingFluids) {
        return this.isValidStack(slot, stack);
    }

    private boolean isValidStack(MachineSlotItem slot, ItemStack stack) {
        if (StackHelper.isNull(stack)) {
            return false;
        }
        if (slot == this.input_lapis) {
            for (ItemStack ore : this.ores) {
                if (!OreDictionary.itemMatches((ItemStack)ore, (ItemStack)stack, (boolean)false)) continue;
                return true;
            }
        } else if (slot == this.input) {
            if (stack.func_77973_b() == Items.field_151122_aG) {
                return true;
            }
            if (!stack.func_77956_u() || stack.func_77973_b().getItemEnchantability(stack) <= 0) {
                return false;
            }
            for (Enchantment enchantment : Enchantment.field_185264_b) {
                if (enchantment.func_185261_e() || !enchantment.canApplyAtEnchantingTable(stack)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean allowInputFluid(MachineSlotFluid slot, FluidStack stack, Map<MachineSlotItem, ItemStack> existingItems, Map<MachineSlotFluid, FluidStack> existingFluids) {
        return false;
    }

    @Override
    public boolean matches(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
        return this.isValidStack(this.input_lapis, inputItems.get(this.input_lapis)) && this.isValidStack(this.input, inputItems.get(this.input));
    }

    @Override
    public Map<MachineSlotItem, ItemStack> getItemOutputs(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
        ItemStack stack = inputItems.get(this.input).func_77946_l();
        int level = 1;
        stack = this.enchant(stack, level, XURandom.rand);
        return ImmutableMap.of((Object)this.output, (Object)stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Map<MachineSlotItem, ItemStack> getItemOutputsJEI(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
        ItemStack stack = inputItems.get(this.input).func_77946_l();
        long currentTimeMillis = System.currentTimeMillis() / 20000L + (long)inputItems.get(this.input).hashCode();
        stack = this.enchant(stack, 1, new Random(currentTimeMillis));
        return ImmutableMap.of((Object)this.output, (Object)stack);
    }

    @Nonnull
    private ItemStack enchant(ItemStack stack, int level, Random random) {
        boolean flag;
        List<Enchantment> list = this.buildList(stack, level, random);
        boolean bl = flag = stack.func_77973_b() == Items.field_151122_aG;
        if (flag) {
            stack = new ItemStack((Item)Items.field_151134_bR);
        }
        for (Enchantment enchantment : list) {
            if (flag) {
                Items.field_151134_bR.func_92115_a(stack, new EnchantmentData(enchantment, this.enchantType.getLevel.applyAsInt(enchantment)));
                continue;
            }
            stack.func_77966_a(enchantment, this.enchantType.getLevel.applyAsInt(enchantment));
        }
        return stack;
    }

    @Nonnull
    private List<Enchantment> buildList(ItemStack stack, int level, Random random) {
        ArrayList list = Lists.newArrayList();
        Item item = stack.func_77973_b();
        int i = item.getItemEnchantability(stack);
        if (i <= 0) {
            return list;
        }
        level = level + 1 + random.nextInt(i / 4 + 1) + random.nextInt(i / 4 + 1);
        float mult = (random.nextFloat() + random.nextFloat() - 1.0f) * 0.15f;
        List<EnchantmentEntry> list1 = this.getEnchantmentDatas(stack);
        if (!list1.isEmpty()) {
            Enchantment enchantment = ((EnchantmentEntry)WeightedRandom.func_76271_a((Random)random, list1)).enchantment;
            list.add(enchantment);
            for (level = MathHelper.func_76125_a((int)Math.round((float)level + (float)level * mult), (int)1, (int)Integer.MAX_VALUE); random.nextInt(50) <= level; level /= 2) {
                CompatHelper.removeIncompatibleEnchantments(list1, enchantment);
                if (list1.isEmpty()) break;
                enchantment = ((EnchantmentEntry)WeightedRandom.func_76271_a((Random)random, list1)).enchantment;
                list.add(enchantment);
            }
        }
        return list;
    }

    @Nonnull
    private List<EnchantmentEntry> getEnchantmentDatas(ItemStack stack) {
        ArrayList list = Lists.newArrayList();
        boolean flag = stack.func_77973_b() == Items.field_151122_aG;
        for (Enchantment enchantment : Enchantment.field_185264_b) {
            if (enchantment.func_185261_e() || !enchantment.canApplyAtEnchantingTable(stack) && (!flag || !enchantment.isAllowedOnBooks())) continue;
            list.add(new EnchantmentEntry(enchantment));
        }
        return list;
    }

    @Override
    public Map<MachineSlotFluid, FluidStack> getFluidOutputs(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
        return ImmutableMap.of();
    }

    @Override
    public int getEnergyOutput(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
        return this.processing_time * 2;
    }

    @Override
    public int getProcessingTime(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
        return this.processing_time;
    }

    @Override
    public TObjectIntMap<MachineSlot> getAmountToConsume(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
        TObjectIntHashMap toConsume = new TObjectIntHashMap();
        toConsume.put((Object)this.input, 1);
        toConsume.put((Object)this.input_lapis, 1);
        return toConsume;
    }

    public static class EnchantmentEntry
    extends WeightedRandom.Item {
        public final Enchantment enchantment;

        public EnchantmentEntry(Enchantment enchantment) {
            super(EnchantmentEntry.getRarity(enchantment));
            this.enchantment = enchantment;
        }

        private static int getRarity(Enchantment enchantment) {
            float weight = 100 * enchantment.func_77324_c().func_185270_a();
            float v = 1.0f - MathHelper.func_76131_a((float)((float)(enchantment.func_77321_a(0) - 1) / 30.0f), (float)0.0f, (float)1.0f);
            return Math.max(1, (int)(v * weight));
        }
    }

    public static enum EnchantType {
        LOWEST(Enchantment::func_77319_d),
        HIGHEST(Enchantment::func_77325_b);

        final ToIntFunction<Enchantment> getLevel;

        private EnchantType(ToIntFunction<Enchantment> getLevel) {
            this.getLevel = getLevel;
        }
    }
}

