/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.items;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.realmsclient.gui.ChatFormatting;
import com.rwtema.extrautils2.backend.ModifyingBakedModel;
import com.rwtema.extrautils2.backend.XUItem;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.backend.model.PassthruModelItem;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.compatibility.CompatHelper112;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.datastructures.ThreadLocalBoolean;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BakedQuadRetextured;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.ContainerMerchant;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFakeCopy
extends XUItem {
    static WeakHashMap<ItemStack, Long> lastTooltipTime = new WeakHashMap();

    public ItemFakeCopy() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.func_77627_a(true);
    }

    @Override
    public void registerTextures() {
        Textures.register("cardboard");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getBaseTexture() {
        return Textures.MISSING_SPRITE;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBakedModel createModel(int metadata) {
        return new PassthruModelItem(this){
            ModifyingBakedModel.IQuadReDesigner carboardifier;
            ItemOverrideList list;
            {
                this.carboardifier = new ModifyingBakedModel.IQuadReDesigner(){
                    public Class<?> itemLayerModelClass;
                    {
                        try {
                            this.itemLayerModelClass = Class.forName("net.minecraftforge.client.model.ItemLayerModel$BakedItemModel");
                        }
                        catch (ClassNotFoundException e) {
                            throw Throwables.propagate((Throwable)e);
                        }
                    }

                    @Override
                    @Nonnull
                    public List<BakedQuad> redesign(@Nonnull List<BakedQuad> original, IBakedModel base, IBlockState state, EnumFacing side, long rand) {
                        if (base.getClass() == this.itemLayerModelClass) {
                            if (original.size() == 0) {
                                return original;
                            }
                            TextureAtlasSprite sprite = base.func_177554_e();
                            ArrayList list = Lists.newArrayList();
                            TextureAtlasSprite override = Textures.getSprite("cardboard");
                            for (BakedQuad quad : original) {
                                EnumFacing face = quad.func_178210_d();
                                if (face.func_176740_k() == EnumFacing.Axis.Z) continue;
                                list.add(new BakedQuadRetextured(quad, override));
                            }
                            list.addAll(PassthruModelItem.buildFrontQuads(sprite, override));
                            return list;
                        }
                        ArrayList list = Lists.newArrayListWithExpectedSize((int)original.size());
                        TextureAtlasSprite sprite = Textures.getSprite("cardboard");
                        for (BakedQuad quad : original) {
                            list.add(new BakedQuadRetextured(quad, sprite));
                        }
                        return list;
                    }
                };
                this.list = new ItemOverrideList((List)ImmutableList.of()){
                    ThreadLocalBoolean avoidRecursion;
                    {
                        this.avoidRecursion = new ThreadLocalBoolean(false);
                    }

                    @Nonnull
                    public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, ItemStack stack, @Nonnull World world, @Nonnull EntityLivingBase entity) {
                        if (stack.func_77952_i() == 0) {
                            return overrideList.handleItemState(originalModel, stack, world, entity);
                        }
                        if (((Boolean)this.avoidRecursion.get()).booleanValue()) {
                            return originalModel;
                        }
                        this.avoidRecursion.set(true);
                        ItemStack duplicate = ItemFakeCopy.this.getDuplicate(stack);
                        IBakedModel duplicateModel = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(duplicate);
                        IBakedModel finalModel = duplicateModel.func_188617_f().handleItemState(duplicateModel, duplicate, world, entity);
                        this.avoidRecursion.set(false);
                        if (ItemFakeCopy.this.isInsideInventory(stack) && ItemFakeCopy.this.hasTooltippedRecently(stack)) {
                            return ModifyingBakedModel.create(finalModel, carboardifier);
                        }
                        return finalModel;
                    }
                };
            }

            @Override
            @Nonnull
            public ItemOverrideList func_188617_f() {
                return this.list;
            }
        };
    }

    public boolean hasTooltippedRecently(ItemStack stack) {
        long l;
        Long aLong = lastTooltipTime.get(stack);
        return aLong != null && (l = System.currentTimeMillis() - aLong) <= 1000L;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addQuads(PassthruModelItem.ModelLayer model, ItemStack stack) {
        model.addTintedSprite(Textures.getSprite("cardboard"), true, 0);
    }

    @Override
    public int getMaxMetadata() {
        return 0;
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.getDuplicate(stack).func_77962_s();
    }

    @Nonnull
    public EnumRarity func_77613_e(ItemStack stack) {
        return this.getDuplicate(stack).func_77953_t();
    }

    public ItemStack getDuplicate(ItemStack stack) {
        ItemStack item;
        NBTTagCompound tag;
        if (stack.func_77942_o() && (tag = stack.func_77978_p()).func_150297_b("Item", 10) && StackHelper.isNonNull(item = StackHelper.loadFromNBT(tag.func_74775_l("Item")))) {
            return item;
        }
        int itemDamage = stack.func_77952_i();
        return ItemFakeCopy.getOriginalStack(itemDamage);
    }

    public static ItemStack getOriginalStack(int itemDamage) {
        switch (itemDamage) {
            case 8: {
                return new ItemStack(Items.field_151156_bN);
            }
            case 1: {
                return new ItemStack(Items.field_151045_i);
            }
            case 2: {
                ItemStack itemStack = new ItemStack(Items.field_151046_w);
                itemStack.func_77966_a(Enchantments.field_185308_t, 6);
                itemStack.func_77966_a(Enchantments.field_185305_q, 10);
                return itemStack;
            }
            case 3: {
                return XU2Entries.lawSword.newStack();
            }
            case 4: {
                return new ItemStack(Blocks.field_150340_R);
            }
            case 5: {
                return new ItemStack(Blocks.field_150380_bt);
            }
            case 6: {
                return new ItemStack(Blocks.field_150475_bE);
            }
            case 7: {
                return new ItemStack(Blocks.field_150484_ah);
            }
        }
        return new ItemStack(Items.field_151055_y);
    }

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(@Nonnull ItemStack stack) {
        String displayName = this.getDuplicate(stack).func_82833_r();
        if (this.isInsideInventory(stack) && this.hasTooltippedRecently(stack)) {
            return Lang.translateArgs("%s (Fake)", ChatFormatting.STRIKETHROUGH + displayName + ChatFormatting.RESET);
        }
        return displayName;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        super.func_77624_a(stack, playerIn, tooltip, advanced);
        ItemStack duplicate = this.getDuplicate(stack);
        tooltip.add(Lang.translateArgs("On close inspection, this %s", duplicate.func_82833_r()));
        if (duplicate.func_77962_s()) {
            tooltip.add(Lang.translate("is a fake made out of enchanted cardboard."));
        } else {
            tooltip.add(Lang.translate("is a fake made out of cardboard."));
        }
        tooltip.add(Lang.translate("Hope you got a receipt."));
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void changeToolTip(ItemTooltipEvent event) {
        ItemStack itemStack = event.getItemStack();
        if (StackHelper.isNull(itemStack) || itemStack.func_77973_b() != this) {
            return;
        }
        if (this.isInsideInventory(itemStack)) {
            lastTooltipTime.put(itemStack, System.currentTimeMillis());
            return;
        }
        ItemStack duplicate = this.getDuplicate(itemStack);
        List toolTip = event.getToolTip();
        toolTip.clear();
        toolTip.addAll(CompatHelper112.getTooltip(duplicate, event));
    }

    @SideOnly(value=Side.CLIENT)
    private boolean isInsideInventory(ItemStack itemStack) {
        EntityPlayerSP thePlayer = Minecraft.func_71410_x().field_71439_g;
        if (thePlayer == null) {
            return false;
        }
        if (thePlayer.field_71070_bA instanceof ContainerWorkbench) {
            return true;
        }
        if (thePlayer.field_71070_bA instanceof ContainerMerchant) {
            return false;
        }
        InventoryPlayer inv = thePlayer.field_71071_by;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i) != itemStack) continue;
            return true;
        }
        return false;
    }

    @Override
    public void getSubItemsBase(@Nonnull Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
    }
}

