/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.crafting.jei;

import com.google.common.collect.ImmutableList;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.crafting.jei.XUJEIPlugin;
import com.rwtema.extrautils2.gui.backend.DynamicGui;
import com.rwtema.extrautils2.tile.TileResonator;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.helpers.StringHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;

public class JEIResonatorHandler
extends BlankRecipeCategory<ResonatorWrapper>
implements IRecipeHandler<TileResonator.ResonatorRecipe>,
IRecipeCategory<ResonatorWrapper> {
    public static final String uid = "extrautils2.resonator";
    public static final int recipeWidth = 116;
    public static final int BETWEEN_DIST = 60;
    public static final int slotX1 = 79;
    public static final int slotX0 = 19;
    public static final int arrowX = 47;
    IDrawable slotDrawable = XUJEIPlugin.jeiHelpers.getGuiHelper().getSlotDrawable();
    IDrawable background = XUJEIPlugin.jeiHelpers.getGuiHelper().createBlankDrawable(116, 54);
    IDrawable arrowBack = XUJEIPlugin.jeiHelpers.getGuiHelper().createDrawable(DynamicGui.texWidgets, 98, 0, 22, 16);

    @Nonnull
    public Class<TileResonator.ResonatorRecipe> getRecipeClass() {
        return TileResonator.ResonatorRecipe.class;
    }

    @Nonnull
    public String getRecipeCategoryUid() {
        return uid;
    }

    @Nonnull
    public String getRecipeCategoryUid(@Nonnull TileResonator.ResonatorRecipe recipe) {
        return uid;
    }

    @Nonnull
    public IRecipeWrapper getRecipeWrapper(@Nonnull TileResonator.ResonatorRecipe recipe) {
        return new ResonatorWrapper(recipe);
    }

    public boolean isRecipeValid(@Nonnull TileResonator.ResonatorRecipe recipe) {
        return true;
    }

    @Nonnull
    public String getUid() {
        return uid;
    }

    @Nonnull
    public String getTitle() {
        return Lang.getItemName((Block)XU2Entries.resonator.value);
    }

    public String getModName() {
        return "extrautils2";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return null;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.slotDrawable.draw(minecraft, 19, 0);
        this.slotDrawable.draw(minecraft, 79, 0);
        this.arrowBack.draw(minecraft, 47, 0);
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull ResonatorWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 19, 0);
        guiItemStacks.set(0, ((ResonatorWrapper)recipeWrapper).resonatorRecipe.input);
        guiItemStacks.init(1, false, 79, 0);
        guiItemStacks.set(1, ((ResonatorWrapper)recipeWrapper).resonatorRecipe.output);
    }

    public static class ResonatorWrapper
    extends BlankRecipeWrapper {
        private final TileResonator.ResonatorRecipe resonatorRecipe;
        String energyString;

        public ResonatorWrapper(TileResonator.ResonatorRecipe resonatorRecipe) {
            this.resonatorRecipe = resonatorRecipe;
            this.energyString = Lang.translateArgs("%s GP", StringHelper.niceFormat((double)resonatorRecipe.energy / 100.0));
        }

        public void getIngredients(@Nonnull IIngredients ingredients) {
            ingredients.setInputs(ItemStack.class, (List)ImmutableList.of((Object)this.resonatorRecipe.input));
            ingredients.setOutput(ItemStack.class, (Object)this.resonatorRecipe.output);
        }

        public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        }

        public boolean handleClick(@Nonnull Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
            return false;
        }
    }
}

