/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.blocks;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.backend.IMetaProperty;
import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.backend.XUBlockStatic;
import com.rwtema.extrautils2.backend.model.Box;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.backend.model.MutableModel;
import com.rwtema.extrautils2.backend.model.PassthruModelItem;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.backend.model.Transforms;
import com.rwtema.extrautils2.compatibility.StackHelper;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockEnderLilly
extends XUBlockStatic
implements IPlantable,
IGrowable {
    public static final EnumPlantType ender = EnumPlantType.getPlantType((String)"ender");
    public static final PropertyInteger GROWTH_STATE = PropertyInteger.func_177719_a((String)"growth", (int)0, (int)7);
    public static final HashSet<IBlockState> end_stone_states = Sets.newHashSet((Iterable)Blocks.field_150377_bs.func_176194_O().func_177619_a());
    public static final IMetaProperty<Boolean> READY_TO_GROW = new IMetaProperty.Wrap<Boolean>((IProperty)PropertyBool.func_177716_a((String)"ready_to_grow"), Boolean.valueOf(false)){

        @Override
        public Boolean calculateValue(IBlockAccess worldIn, BlockPos pos, IBlockState originalState) {
            World world;
            int i = (Integer)originalState.func_177229_b((IProperty)GROWTH_STATE);
            if (worldIn instanceof World) {
                world = (World)worldIn;
            } else if (ExtraUtils2.proxy.isClientSide()) {
                world = ExtraUtils2.proxy.getClientWorld();
            } else {
                return false;
            }
            return BlockEnderLilly.isReadyToGrow(world, pos, i);
        }
    };
    static float[] size_w = new float[]{0.125f, 0.1875f, 0.25f, 0.375f, 0.5f, 0.5f, 0.5f, 0.5f};
    static float[] size_h = new float[]{0.25f, 0.4375f, 0.4375f, 0.5f, 0.6875f, 0.75f, 0.75f, 0.875f};
    public final IBlockState FULLY_GROWN_STATE;

    public BlockEnderLilly() {
        super(Material.field_151585_k);
        this.func_149675_a(true);
        this.func_149711_c(0.0f);
        this.FULLY_GROWN_STATE = this.func_176223_P().func_177226_a((IProperty)GROWTH_STATE, (Comparable)Integer.valueOf(7));
    }

    public static boolean isReadyToGrow(World worldIn, BlockPos pos, int metadata) {
        if (metadata >= 7) {
            return false;
        }
        long period = BlockEnderLilly.isEndStoneBlock((IBlockAccess)worldIn, pos) ? 17000L : 57000L;
        long midPeriod = worldIn.func_72820_D() % (2L * period);
        return metadata % 2 == 0 == midPeriod <= period;
    }

    public static boolean isEndStoneBlock(IBlockAccess worldIn, BlockPos pos) {
        return end_stone_states.contains(worldIn.func_180495_p(pos.func_177977_b()));
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        int i = (Integer)state.func_177229_b((IProperty)GROWTH_STATE);
        if (!BlockEnderLilly.isReadyToGrow(worldIn, pos, i)) {
            return;
        }
        if (rand.nextInt(BlockEnderLilly.isEndStoneBlock((IBlockAccess)worldIn, pos) ? 2 : 40) != 0) {
            return;
        }
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)GROWTH_STATE, (Comparable)Integer.valueOf(i + 1)), 2);
    }

    public void func_176474_b(@Nonnull World worldIn, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        int i = (Integer)state.func_177229_b((IProperty)GROWTH_STATE);
        if ((i += MathHelper.func_76136_a((Random)worldIn.field_73012_v, (int)2, (int)5)) >= 7) {
            i = 7;
            if (worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150450_ax) {
                worldIn.func_175656_a(pos.func_177977_b(), Blocks.field_150439_ay.func_176223_P());
            }
        }
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)GROWTH_STATE, (Comparable)Integer.valueOf(i)), 2);
    }

    @Override
    @Nonnull
    protected XUBlockStateCreator createBlockState() {
        return XUBlockStateCreator.builder(this).addWorldProperties(new IProperty[]{GROWTH_STATE}).addMetaProperty(READY_TO_GROW).build();
    }

    @Override
    public BoxModel getModel(IBlockState state) {
        int value = (Integer)state.func_177229_b((IProperty)GROWTH_STATE);
        BoxModel boxes = BoxModel.crossBoxModel().setTexture("plants/ender_lilly_stage_" + value);
        for (Box box : boxes) {
            box.noCollide = true;
            box.setLayer(BlockRenderLayer.CUTOUT);
        }
        boxes.overrideBounds = new Box(0.5f - size_w[value], 0.0f, 0.5f - size_w[value], 0.5f + size_w[value], size_h[value], 0.5f + size_w[value]);
        return boxes;
    }

    public boolean func_176473_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, boolean isClient) {
        return (Integer)state.func_177229_b((IProperty)GROWTH_STATE) < 7;
    }

    public boolean func_180670_a(@Nonnull World worldIn, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        return false;
    }

    @Override
    public void neighborChangedBase(IBlockState state, World worldIn, BlockPos pos, Block neighborBlock) {
        if (!this.validLocation(worldIn, pos)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
            return;
        }
        super.neighborChangedBase(state, worldIn, pos, neighborBlock);
    }

    @Override
    public boolean canReplaceBase(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumFacing side, ItemStack stack) {
        return this.validLocation(worldIn, pos) && super.canReplaceBase(worldIn, pos, side, stack);
    }

    @Override
    @Nonnull
    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
        List<ItemStack> drops = super.getDrops(world, pos, state, fortune);
        if (state == this.FULLY_GROWN_STATE) {
            this.addAdditionalDrops(world, pos, fortune, drops, world instanceof World ? ((World)world).field_73012_v : RANDOM);
        }
        return drops;
    }

    protected List<ItemStack> addAdditionalDrops(IBlockAccess world, BlockPos pos, int fortune, List<ItemStack> drops, Random random) {
        drops.add(new ItemStack(Items.field_151079_bi, 1));
        if (BlockEnderLilly.isEndStoneBlock(world, pos) && random.nextInt(20) <= 1 + fortune) {
            drops.add(new ItemStack((Block)this, 1));
        }
        return drops;
    }

    public boolean validLocation(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        return BlockEnderLilly.isEndStoneBlock((IBlockAccess)world, pos) || block == Blocks.field_150346_d || block == Blocks.field_150349_c;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return ender;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        if (world == null || pos == null) {
            return this.func_176223_P();
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return this.func_176223_P();
        }
        return state;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public MutableModel createInventoryMutableModel() {
        return new PassthruModelItem.ModelLayer(Transforms.itemTransforms);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerTextures() {
        super.registerTextures();
        Textures.register("plants/ender_lilly_seed");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInventoryQuads(MutableModel result, ItemStack stack) {
        PassthruModelItem.ModelLayer layer = (PassthruModelItem.ModelLayer)result;
        layer.addSprite((TextureAtlasSprite)Textures.sprites.get((Object)"plants/ender_lilly_seed"));
    }

    public void func_180655_c(IBlockState state, World worldIn, BlockPos pos, Random rand) {
        if ((Integer)state.func_177229_b((IProperty)GROWTH_STATE) != 7 || rand.nextInt(5) != 0) {
            return;
        }
        int ddx = rand.nextInt(2) * 2 - 1;
        int ddz = rand.nextInt(2) * 2 - 1;
        double dx = rand.nextFloat() * 1.0f * (float)ddx;
        double dy = ((double)rand.nextFloat() - 0.5) * 0.125;
        double dz = rand.nextFloat() * 1.0f * (float)ddz;
        double x = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)ddx;
        double y = (float)pos.func_177956_o() + rand.nextFloat();
        double z = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)ddz;
        worldIn.func_175688_a(EnumParticleTypes.PORTAL, x, y, z, dx, dy, dz, new int[0]);
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if ((Integer)state.func_177229_b((IProperty)GROWTH_STATE) >= 3) {
            if (entityIn instanceof EntityItem) {
                ItemStack item = ((EntityItem)entityIn).func_92059_d();
                if (StackHelper.isNonNull(item) && (item.func_77973_b() == Items.field_151079_bi || item.func_77973_b() == Item.func_150898_a((Block)this))) {
                    return;
                }
                if (worldIn.field_72995_K) {
                    worldIn.func_175688_a(EnumParticleTypes.CRIT, entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
                }
            }
            if (entityIn instanceof EntityEnderman) {
                return;
            }
            entityIn.func_70097_a(DamageSource.field_76367_g, 0.1f);
        }
    }

    @Override
    public boolean onBlockActivatedBase(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (state != this.FULLY_GROWN_STATE) {
            return false;
        }
        if (worldIn.field_72995_K) {
            return true;
        }
        worldIn.func_175656_a(pos, this.func_176223_P());
        List<ItemStack> drops = this.addAdditionalDrops((IBlockAccess)worldIn, pos, EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185308_t, (EntityLivingBase)playerIn), Lists.newArrayList(), worldIn.field_73012_v);
        for (ItemStack drop : drops) {
            BlockEnderLilly.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)drop);
        }
        return true;
    }
}

