/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.blocks;

import com.google.common.collect.Lists;
import com.rwtema.extrautils2.backend.XUBlockConnectedTextureBase;
import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.network.NetworkHandler;
import com.rwtema.extrautils2.network.XUPacketServerToClient;
import com.rwtema.extrautils2.textures.ConnectedTexture;
import com.rwtema.extrautils2.textures.ISolidWorldTexture;
import com.rwtema.extrautils2.textures.SimpleWorldTexture;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.LogHelper;
import com.rwtema.extrautils2.utils.datastructures.WeakLinkedSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCursedEarth
extends XUBlockConnectedTextureBase {
    public static final int MAX_DECAY = 15;
    public static final PropertyInteger DECAY = PropertyInteger.func_177719_a((String)"decay", (int)0, (int)15);
    public static final WeakLinkedSet<Entity> cursedClient = new WeakLinkedSet();
    static final UUID uuid = UUID.fromString("E53E0344-EA5E-4F71-98F6-40791198D8FE");
    ISolidWorldTexture tex;
    ISolidWorldTexture side;
    ISolidWorldTexture bottom;

    public BlockCursedEarth() {
        super(Material.field_151578_c);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        this.func_149675_a(true);
    }

    public static void startFastSpread(World worldIn, BlockPos pos) {
        BlockCursedEarth earth = (BlockCursedEarth)XU2Entries.cursedEarth.value;
        IBlockState cursedEarthState = earth.func_176223_P();
        worldIn.func_175656_a(pos, cursedEarthState);
        worldIn.func_175684_a(pos.func_185334_h(), (Block)earth, 1);
        worldIn.func_175718_b(1027, pos, 0);
    }

    private static void trySpawnMob(WorldServer world, BlockPos pos, EntityLiving mob) {
        if (mob == null) {
            return;
        }
        boolean shouldCenter = world.field_73012_v.nextBoolean();
        float x = (float)pos.func_177958_n() + (shouldCenter ? 0.5f : world.field_73012_v.nextFloat());
        float y = pos.func_177956_o() + 1;
        float z = (float)pos.func_177952_p() + (shouldCenter ? 0.5f : world.field_73012_v.nextFloat());
        mob.func_70012_b((double)x, (double)y, (double)z, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        if (!ForgeEventFactory.doSpecialSpawn((EntityLiving)mob, (World)world, (float)x, (float)y, (float)z)) {
            mob.func_180482_a(world.func_175649_E(new BlockPos((Entity)mob)), null);
        }
        if (!mob.func_70058_J() || !mob.func_70601_bi()) {
            mob.func_70106_y();
            return;
        }
        if (BlockCursedEarth.spawnMobAsCursed((Entity)mob)) {
            mob.func_70642_aH();
        }
    }

    public static boolean spawnMobAsCursed(Entity mob) {
        mob.field_98038_p = true;
        if (mob instanceof EntityLivingBase) {
            IAttributeInstance attributeInstanceByName;
            mob.getEntityData().func_74768_a("CursedEarth", 60);
            EntityLivingBase living = (EntityLivingBase)mob;
            BlockCursedEarth.applyAttribute(living, SharedMonsterAttributes.field_111264_e, new AttributeModifier(uuid, "CursedEarth", 1.5, 1));
            BlockCursedEarth.applyAttribute(living, SharedMonsterAttributes.field_111263_d, new AttributeModifier(uuid, "CursedEarth", 1.2, 1));
            if (living instanceof EntityZombie && (attributeInstanceByName = living.func_110140_aT().func_111152_a("zombie.spawnReinforcements")) != null) {
                attributeInstanceByName.func_111128_a(0.0);
            }
        }
        if (!mob.field_70170_p.func_72838_d(mob)) {
            return false;
        }
        if (mob.func_184207_aI()) {
            mob.func_184188_bt().forEach(BlockCursedEarth::spawnMobAsCursed);
        }
        return true;
    }

    private static void applyAttribute(EntityLivingBase mob, IAttribute attackDamage, AttributeModifier modifier) {
        IAttributeInstance instance = mob.func_110148_a(attackDamage);
        if (instance != null) {
            instance.func_111121_a(modifier);
        }
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)Blocks.field_150346_d);
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, @Nonnull IBlockState state, EntityPlayer player) {
        return (Integer)state.func_177229_b((IProperty)DECAY) == 0;
    }

    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        int numParticles = 15 - (Integer)stateIn.func_177229_b((IProperty)DECAY);
        for (int i = 0; i < numParticles; ++i) {
            worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)pos.func_177958_n() + rand.nextDouble(), (double)pos.func_177956_o() + 1.01, (double)pos.func_177952_p() + rand.nextDouble(), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public boolean isFireSource(@Nonnull World world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP;
    }

    public void func_180645_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random random) {
        if (worldIn.field_72995_K) {
            return;
        }
        this.performTick(worldIn, pos, random, false);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (worldIn == null || worldIn.field_72995_K) {
            return;
        }
        this.performTick(worldIn, pos, rand, true);
    }

    protected void performTick(World worldIn, BlockPos pos, Random rand, boolean fastSpreading) {
        WorldServer world = (WorldServer)worldIn;
        int light = world.func_175671_l(pos.func_177984_a());
        if (light >= 9) {
            BlockPos add;
            int i;
            boolean nearbyFire;
            IBlockState blockState = world.func_180495_p(pos.func_177984_a());
            boolean bl = nearbyFire = blockState.func_185904_a() == Material.field_151581_o;
            if (nearbyFire && rand.nextInt(5) == 0) {
                world.func_175656_a(pos, Blocks.field_150346_d.func_176223_P());
            }
            if (!nearbyFire) {
                for (i = 0; i < 10; ++i) {
                    add = pos.func_177982_a(rand.nextInt(9) - 4, rand.nextInt(5) - 3, rand.nextInt(9) - 4);
                    if (add.func_177956_o() >= 0 && add.func_177956_o() < 256 && !worldIn.func_175667_e(add) || world.func_180495_p(add).func_185904_a() != Material.field_151581_o) continue;
                    nearbyFire = true;
                    break;
                }
            }
            if (nearbyFire) {
                for (i = 0; i < 40; ++i) {
                    add = pos.func_177982_a(rand.nextInt(9) - 4, rand.nextInt(5) - 3, rand.nextInt(9) - 4);
                    if (add.func_177956_o() >= 0 && add.func_177956_o() < 256 && !worldIn.func_175667_e(add) || world.func_180495_p(add).func_177230_c() != this) continue;
                    IBlockState s = world.func_180495_p(add.func_177984_a());
                    if (s.func_177230_c().func_176200_f((IBlockAccess)worldIn, add.func_177984_a())) {
                        world.func_175656_a(add.func_177984_a(), Blocks.field_150480_ab.func_176223_P());
                        continue;
                    }
                    world.func_175656_a(add, Blocks.field_150346_d.func_176223_P());
                }
                return;
            }
        }
        boolean spread = false;
        if (fastSpreading) {
            ArrayList list = Lists.newArrayList((Iterable)BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-1, -2, -1), (BlockPos)pos.func_177982_a(1, 2, 1)));
            Collections.shuffle(list);
            for (BlockPos blockPos : list) {
                this.trySpread(worldIn, pos, rand, true, world, false, blockPos);
            }
        } else {
            for (int i = 0; i < 4; ++i) {
                BlockPos blockpos = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(5) - 3, rand.nextInt(3) - 1);
                spread = this.trySpread(worldIn, pos, rand, false, world, spread, blockpos);
            }
            if (light >= 9 || spread && rand.nextInt(8) != 0) {
                return;
            }
            AxisAlignedBB bb = new AxisAlignedBB(pos).func_72314_b(-7.0, 4.0, 7.0);
            int numCreaturesNearby = world.func_175647_a(EntityLiving.class, bb, input -> input != null && input.isCreatureType(EnumCreatureType.MONSTER, false)).size();
            if (numCreaturesNearby < 8) {
                this.trySpawnMob(world, pos);
            }
        }
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        tooltip.add(Lang.translate("Aggressively spawns mobs when in darkness."));
        tooltip.add(Lang.translate("Only fire can stop its spread."));
    }

    private boolean trySpread(World worldIn, BlockPos pos, Random rand, boolean fastSpreading, WorldServer world, boolean spread, BlockPos blockpos) {
        if (blockpos.func_177956_o() >= 0 && blockpos.func_177956_o() < 256 && !worldIn.func_175667_e(blockpos)) {
            return spread;
        }
        IBlockState otherBlock = worldIn.func_180495_p(blockpos);
        if (otherBlock.func_177230_c() != Blocks.field_150349_c && (otherBlock.func_177230_c() != Blocks.field_150346_d || otherBlock.func_177229_b((IProperty)BlockDirt.field_176386_a) != BlockDirt.DirtType.DIRT)) {
            return spread;
        }
        IBlockState aboveState = worldIn.func_180495_p(blockpos.func_177984_a());
        if (aboveState.getLightOpacity((IBlockAccess)worldIn, pos.func_177984_a()) > 2) {
            return spread;
        }
        int decay = 16;
        for (BlockPos.MutableBlockPos p : BlockPos.func_177975_b((BlockPos)blockpos.func_177982_a(-1, -1, -1), (BlockPos)blockpos.func_177982_a(1, 1, 1))) {
            IBlockState blockState = world.func_180495_p((BlockPos)p);
            if (blockState.func_177230_c() != this) continue;
            decay = Math.min(decay, (Integer)blockState.func_177229_b((IProperty)DECAY) + 1);
        }
        if (rand.nextBoolean()) {
            ++decay;
        }
        if (decay > 15) {
            return spread;
        }
        worldIn.func_175656_a(blockpos, this.func_176223_P().func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(decay)));
        if (fastSpreading) {
            world.func_175718_b(2001, blockpos, Block.func_149682_b((Block)this));
            world.func_175684_a(blockpos, (Block)this, 2 + rand.nextInt(8));
        }
        return true;
    }

    protected void trySpawnMob(WorldServer world, BlockPos pos) {
        EntityLiving mob;
        EnumCreatureType type = EnumCreatureType.MONSTER;
        Biome.SpawnListEntry entry2 = world.func_175734_a(type, pos);
        if (entry2 == null || !world.func_175732_a(type, entry2, pos)) {
            return;
        }
        try {
            mob = (EntityLiving)entry2.field_76300_b.getConstructor(World.class).newInstance(world);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        BlockCursedEarth.trySpawnMob(world, pos, mob);
    }

    @Override
    @Nonnull
    protected XUBlockStateCreator createBlockState() {
        return new XUBlockStateCreator.Builder(this).addWorldPropertyWithDefault(DECAY, 0).build();
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return true;
    }

    @Override
    public ISolidWorldTexture getConnectedTexture(IBlockState state, EnumFacing side) {
        if (side == EnumFacing.UP) {
            return this.tex;
        }
        if (side == EnumFacing.DOWN) {
            return this.bottom;
        }
        return this.side;
    }

    @Override
    public void registerTextures() {
        this.tex = new ConnectedTexture("evil_earth", this.func_176223_P(), this){

            @Override
            protected boolean matches(IBlockAccess world, BlockPos pos, EnumFacing side, BlockPos originalPos) {
                boolean matches;
                IBlockState b1 = world.func_180495_p(pos);
                boolean bl = matches = b1.func_177230_c() == XU2Entries.cursedEarth.value && b1.func_185894_c(world, pos, side);
                if (matches) {
                    long b;
                    int d1 = (Integer)b1.func_177229_b((IProperty)DECAY);
                    int d2 = (Integer)world.func_180495_p(originalPos).func_177229_b((IProperty)DECAY);
                    if (d1 == 15 && d2 == 15) {
                        return true;
                    }
                    if (d1 == 15 || d2 == 15) {
                        return false;
                    }
                    long a = MathHelper.func_180186_a((Vec3i)pos) >> 16;
                    return (a & 1L) == ((b = MathHelper.func_180186_a((Vec3i)originalPos) >> 16) & 1L);
                }
                return false;
            }
        };
        this.side = new SimpleWorldTexture("cursedearthside");
        this.bottom = new SimpleWorldTexture("cursedearthbottom");
    }

    public static class AICursed
    extends EntityAIBase {
        final EntityLiving living;
        int cursedEarth;

        public AICursed(EntityLiving living, int cursedEarth) {
            this.living = living;
            this.cursedEarth = cursedEarth;
        }

        public boolean func_75250_a() {
            return true;
        }

        public boolean func_75253_b() {
            return true;
        }

        public void func_75246_d() {
            if (this.living.field_70170_p.func_82737_E() % 20L != 0L) {
                return;
            }
            if (this.cursedEarth < 0) {
                return;
            }
            if (this.cursedEarth == 0) {
                for (int k = 0; k < 20; ++k) {
                    Random rand = this.living.field_70170_p.field_73012_v;
                    double d2 = rand.nextGaussian() * 0.02;
                    double d0 = rand.nextGaussian() * 0.02;
                    double d1 = rand.nextGaussian() * 0.02;
                    this.living.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.living.field_70165_t + (double)(rand.nextFloat() * this.living.field_70130_N * 2.0f) - (double)this.living.field_70130_N, this.living.field_70163_u + (double)(rand.nextFloat() * this.living.field_70131_O), this.living.field_70161_v + (double)(rand.nextFloat() * this.living.field_70130_N * 2.0f) - (double)this.living.field_70130_N, d2, d0, d1, new int[0]);
                }
                this.living.func_70106_y();
            } else {
                --this.cursedEarth;
                this.living.getEntityData().func_74768_a("CursedEarth", this.cursedEarth);
            }
        }
    }

    @NetworkHandler.XUPacket
    public static class PacketEntityIsEvil
    extends XUPacketServerToClient {
        private int entityId;
        private boolean isEvil;

        public PacketEntityIsEvil() {
        }

        public PacketEntityIsEvil(int entityId, boolean isEvil) {
            this.entityId = entityId;
            this.isEvil = isEvil;
        }

        @Override
        public void writeData() throws Exception {
            this.writeInt(this.entityId);
            this.writeBoolean(this.isEvil);
        }

        @Override
        public void readData(EntityPlayer player) {
            this.entityId = this.readInt();
            this.isEvil = this.readBoolean();
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public Runnable doStuffClient() {
            return new Runnable(){

                @Override
                public void run() {
                    Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(entityId);
                    if (entity != null) {
                        if (isEvil) {
                            cursedClient.add(entity);
                        } else {
                            cursedClient.remove(entity);
                        }
                    } else {
                        LogHelper.debug("No findy entity", new Object[0]);
                    }
                }
            };
        }
    }

    public static class EventHandler {
        @SubscribeEvent
        public void cureCurse(PlayerInteractEvent.EntityInteract event) {
            NBTTagCompound nbt;
            Entity entity = event.getTarget();
            ItemStack heldItem = event.getEntityPlayer().func_184586_b(event.getHand());
            if (StackHelper.isNull(heldItem) || heldItem.func_77973_b() != Items.field_151117_aB) {
                return;
            }
            if (entity instanceof EntityLiving && (nbt = entity.getEntityData()).func_150297_b("CursedEarth", 3)) {
                EntityLiving living = (EntityLiving)entity;
                for (EntityAITasks.EntityAITaskEntry taskEntry : living.field_70714_bg.field_75782_a) {
                    if (!(taskEntry.field_75733_a instanceof AICursed)) continue;
                    ((AICursed)taskEntry.field_75733_a).cursedEarth = -1;
                    living.field_70714_bg.func_85156_a(taskEntry.field_75733_a);
                    break;
                }
                for (IAttributeInstance attributeInstance : living.func_110140_aT().func_111146_a()) {
                    attributeInstance.func_188479_b(uuid);
                }
                nbt.func_82580_o("CursedEarth");
                event.setCanceled(true);
                event.getEntityPlayer().func_184611_a(event.getHand(), heldItem.func_77973_b().getContainerItem(heldItem));
                NetworkHandler.sendToAllAround(new PacketEntityIsEvil(living.func_145782_y(), false), new NetworkRegistry.TargetPoint(living.field_71093_bK, living.field_70165_t, living.field_70163_u, living.field_70161_v, 64.0));
            }
        }

        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        public void spawnParticle(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.END || Minecraft.func_71410_x().func_147113_T()) {
                return;
            }
            Iterator<Entity> iterator = cursedClient.iterator();
            while (iterator.hasNext()) {
                Entity entity = iterator.next();
                if (entity.field_70128_L) {
                    iterator.remove();
                    continue;
                }
                Random rand = entity.field_70170_p.field_73012_v;
                entity.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, entity.field_70165_t + (rand.nextDouble() - 0.5) * (double)entity.field_70130_N, entity.field_70163_u + rand.nextDouble() * (double)entity.field_70131_O, entity.field_70161_v + (rand.nextDouble() - 0.5) * (double)entity.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
        }

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public void render(RenderLivingEvent.Pre event) {
            if (cursedClient.contains(event.getEntity())) {
                float v = 0.1f;
                GlStateManager.func_179131_c((float)v, (float)v, (float)v, (float)1.0f);
            }
        }

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public void render(RenderLivingEvent.Post event) {
            if (cursedClient.contains(event.getEntity())) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }

        @SubscribeEvent
        public void onStartTrack(PlayerEvent.StartTracking event) {
            NBTTagCompound nbt;
            Entity target = event.getTarget();
            if (!target.field_70128_L && target instanceof EntityLiving && (nbt = target.getEntityData()).func_150297_b("CursedEarth", 3)) {
                NetworkHandler.sendPacketToPlayer(new PacketEntityIsEvil(target.func_145782_y(), true), event.getEntityPlayer());
            }
        }

        @SubscribeEvent
        public void spawnInWorld(EntityJoinWorldEvent event) {
            NBTTagCompound nbt;
            Entity entity = event.getEntity();
            if (entity instanceof EntityLiving && (nbt = entity.getEntityData()).func_150297_b("CursedEarth", 3)) {
                int cursedEarth = nbt.func_74762_e("CursedEarth");
                if (cursedEarth <= 0) {
                    entity.func_70106_y();
                    event.setCanceled(true);
                } else {
                    EntityLiving living = (EntityLiving)entity;
                    living.field_70714_bg.func_75776_a(0, (EntityAIBase)new AICursed(living, cursedEarth));
                }
            }
        }
    }

    public static enum Type {
        CURSED_NORMAL;

    }
}

