/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.grid;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import net.blay09.mods.refinedrelocation.api.RefinedRelocationAPI;
import net.blay09.mods.refinedrelocation.api.filter.ISimpleFilter;
import net.blay09.mods.refinedrelocation.api.grid.ISortingInventory;
import net.blay09.mods.refinedrelocation.capability.CapabilityRootFilter;
import net.blay09.mods.refinedrelocation.grid.SortingGridMember;
import net.blay09.mods.refinedrelocation.grid.SortingStack;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class SortingInventory
extends SortingGridMember
implements ISortingInventory {
    private final LinkedList<SortingStack> sortingStackList = Lists.newLinkedList();
    private IItemHandler itemHandler;
    private ISimpleFilter filter;
    private int priority;

    @Override
    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public ISimpleFilter getFilter() {
        return this.filter;
    }

    @Override
    protected void onFirstTick() {
        super.onFirstTick();
        this.itemHandler = (IItemHandler)this.getTileEntity().getTileEntity().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        this.filter = (ISimpleFilter)this.getTileEntity().getTileEntity().getCapability(CapabilityRootFilter.CAPABILITY, null);
    }

    @Override
    protected void onUpdate() {
        super.onUpdate();
        if (!this.sortingStackList.isEmpty()) {
            SortingStack sortingStack = this.sortingStackList.removeFirst();
            this.getSortingGrid().setSortingActive(true);
            ItemStack itemStack = sortingStack.getItemHandler().getStackInSlot(sortingStack.getSlotIndex());
            if (ItemStack.func_77989_b((ItemStack)itemStack, (ItemStack)sortingStack.getItemStack()) && ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)sortingStack.getItemStack())) {
                RefinedRelocationAPI.insertIntoSortingGrid(this, sortingStack.getSlotIndex(), itemStack);
            }
            this.getSortingGrid().setSortingActive(false);
        }
    }

    @Override
    public void onSlotChanged(int slotIndex) {
        ItemStack itemStack;
        if (this.getSortingGrid() != null && !this.getSortingGrid().isSortingActive() && !this.getTileEntity().getWorld().field_72995_K && (itemStack = this.itemHandler.getStackInSlot(slotIndex)) != null) {
            this.sortingStackList.add(new SortingStack(this.itemHandler, slotIndex, itemStack));
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74777_a("Priority", (short)this.priority);
        return compound;
    }

    public void deserializeNBT(NBTTagCompound compound) {
        this.priority = compound.func_74765_d("Priority");
    }
}

