/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.container;

import javax.annotation.Nullable;
import net.blay09.mods.refinedrelocation.api.RefinedRelocationAPI;
import net.blay09.mods.refinedrelocation.api.TileOrMultipart;
import net.blay09.mods.refinedrelocation.api.container.IContainerMessage;
import net.blay09.mods.refinedrelocation.container.ContainerMod;
import net.blay09.mods.refinedrelocation.filter.NameFilter;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.ItemStack;

public class ContainerNameFilter
extends ContainerMod {
    public static final String KEY_VALUE = "Value";
    private final EntityPlayer player;
    private final TileOrMultipart tileEntity;
    private final NameFilter filter;
    private String lastValue = "";
    private boolean guiNeedsUpdate;

    public ContainerNameFilter(EntityPlayer player, TileOrMultipart tileEntity, NameFilter filter) {
        this.player = player;
        this.tileEntity = tileEntity;
        this.filter = filter;
        this.addPlayerInventory(player, 128);
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (!this.lastValue.equals(this.filter.getValue())) {
            RefinedRelocationAPI.syncContainerValue(KEY_VALUE, this.filter.getValue(), (Iterable<IContainerListener>)this.field_75149_d);
            RefinedRelocationAPI.updateFilterPreview(this.player, this.tileEntity, this.filter);
            this.lastValue = this.filter.getValue();
        }
    }

    @Override
    public void receivedMessageClient(IContainerMessage message) {
        if (message.getKey().equals(KEY_VALUE)) {
            this.filter.setValue(message.getStringValue());
            this.markGuiNeedsUpdate(true);
        }
    }

    @Override
    public void receivedMessageServer(IContainerMessage message) {
        if (message.getKey().equals(KEY_VALUE)) {
            this.filter.setValue(message.getStringValue());
            this.tileEntity.markDirty();
            this.lastValue = this.filter.getValue();
            RefinedRelocationAPI.updateFilterPreview(this.player, this.tileEntity, this.filter);
        }
    }

    @Nullable
    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        ItemStack itemStack = super.func_184996_a(slotId, dragType, clickTypeIn, player);
        RefinedRelocationAPI.updateFilterPreview(player, this.tileEntity, this.filter);
        return itemStack;
    }

    public void sendValueToServer(String value) {
        RefinedRelocationAPI.sendContainerMessageToServer(KEY_VALUE, value);
    }

    public String getValue() {
        return this.filter.getValue();
    }

    public void markGuiNeedsUpdate(boolean dirty) {
        this.guiNeedsUpdate = dirty;
    }

    public boolean doesGuiNeedUpdate() {
        return this.guiNeedsUpdate;
    }

    public TileOrMultipart getTileEntity() {
        return this.tileEntity;
    }
}

