/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.client.gui.element;

import java.util.List;
import net.blay09.mods.refinedrelocation.api.Priority;
import net.blay09.mods.refinedrelocation.api.grid.ISortingInventory;
import net.blay09.mods.refinedrelocation.client.gui.base.element.GuiTextButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;

public class GuiButtonPriority
extends GuiTextButton {
    private final Priority.Enum[] values;
    private final ISortingInventory sortingInventory;
    private int currentIndex;

    public GuiButtonPriority(int x, int y, int width, int height, ISortingInventory sortingInventory) {
        super(x, y, width, height, "");
        this.sortingInventory = sortingInventory;
        this.values = Priority.Enum.values();
        this.currentIndex = 2;
        this.text = I18n.func_135052_a((String)this.values[this.currentIndex].getLangKey(), (Object[])new Object[0]);
    }

    @Override
    public void actionPerformed(int mouseButton) {
        if (!GuiScreen.func_146272_n()) {
            int oldIndex;
            int n = oldIndex = this.currentIndex != -1 ? this.currentIndex : (this.sortingInventory.getPriority() + 1000) / 500;
            if (mouseButton == 0) {
                ++oldIndex;
            } else if (mouseButton == 1) {
                --oldIndex;
            }
            this.currentIndex = Math.max(0, Math.min(this.values.length - 1, oldIndex));
            this.text = I18n.func_135052_a((String)this.values[this.currentIndex].getLangKey(), (Object[])new Object[0]);
            this.sortingInventory.setPriority(this.values[this.currentIndex].getPriority());
        } else {
            this.currentIndex = -1;
            int oldPriority = this.sortingInventory.getPriority();
            if (mouseButton == 0) {
                oldPriority += 10;
            } else if (mouseButton == 1) {
                oldPriority -= 10;
            }
            oldPriority = Math.max(-999, Math.min(999, oldPriority));
            this.sortingInventory.setPriority(oldPriority);
        }
    }

    @Override
    public void mouseWheelMoved(int mouseX, int mouseY, int delta) {
        this.currentIndex = -1;
        int oldPriority = this.sortingInventory.getPriority();
        if (delta > 0) {
            ++oldPriority;
        } else if (delta < 0) {
            --oldPriority;
        }
        oldPriority = Math.max(-999, Math.min(999, oldPriority));
        this.sortingInventory.setPriority(oldPriority);
    }

    @Override
    public void update() {
        super.update();
        this.currentIndex = -1;
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i].getPriority() != this.sortingInventory.getPriority()) continue;
            this.currentIndex = i;
            break;
        }
        this.text = this.currentIndex != -1 ? I18n.func_135052_a((String)this.values[this.currentIndex].getLangKey(), (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.refinedrelocation:rootFilter.priorityCustom", (Object[])new Object[]{this.sortingInventory.getPriority()});
    }

    @Override
    public void addTooltip(List<String> list) {
        if (!GuiScreen.func_146272_n()) {
            list.add(TextFormatting.GREEN + I18n.func_135052_a((String)"gui.refinedrelocation:rootFilter.priorityIncrease", (Object[])new Object[0]));
            list.add(TextFormatting.RED + I18n.func_135052_a((String)"gui.refinedrelocation:rootFilter.priorityDecrease", (Object[])new Object[0]));
        } else {
            list.add(TextFormatting.GREEN + I18n.func_135052_a((String)"gui.refinedrelocation:rootFilter.priorityIncrease10", (Object[])new Object[0]));
            list.add(TextFormatting.RED + I18n.func_135052_a((String)"gui.refinedrelocation:rootFilter.priorityDecrease10", (Object[])new Object[0]));
        }
        if (this.currentIndex != -1) {
            list.add("");
            list.add(I18n.func_135052_a((String)"gui.refinedrelocation:rootFilter.priorityTooltip", (Object[])new Object[]{this.values[this.currentIndex].getPriority()}));
        }
    }
}

