/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.client.gui.base.element;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.blay09.mods.refinedrelocation.client.gui.base.IParentScreen;
import net.minecraft.client.gui.Gui;

public class GuiElement
extends Gui {
    private final List<GuiElement> children = Lists.newArrayList();
    private GuiElement parent;
    private int relX;
    private int relY;
    private int absX;
    private int absY;
    private int width;
    private int height;
    private boolean isDirty;
    private boolean visible = true;

    public GuiElement getParent() {
        return this.parent;
    }

    public void addChild(GuiElement element) {
        this.children.add(element);
        element.parent = this;
    }

    public void setPosition(int x, int y) {
        this.relX = x;
        this.relY = y;
        this.markDirty();
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getAbsoluteX() {
        if (this.isDirty) {
            this.updatePosition();
        }
        return this.absX;
    }

    public int getAbsoluteY() {
        if (this.isDirty) {
            this.updatePosition();
        }
        return this.absY;
    }

    public void updatePosition() {
        if (this.parent != null) {
            this.absX = this.parent.getAbsoluteX() + this.relX;
            this.absY = this.parent.getAbsoluteY() + this.relY;
        } else {
            this.absX = this.relX;
            this.absY = this.relY;
        }
        this.isDirty = false;
        for (GuiElement child : this.children) {
            child.markDirty();
        }
    }

    public void markDirty() {
        this.isDirty = true;
        for (GuiElement element : this.children) {
            element.markDirty();
        }
    }

    public void initGui(IParentScreen parentScreen) {
        for (GuiElement child : this.children) {
            child.initGui(parentScreen);
        }
    }

    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        return this.parent != null && this.parent.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public void mouseReleased(int mouseX, int mouseY, int state) {
        for (GuiElement child : this.children) {
            child.mouseReleased(mouseX, mouseY, state);
        }
    }

    public boolean keyTyped(char typedChar, int keyCode) {
        for (GuiElement child : this.children) {
            if (!child.keyTyped(typedChar, keyCode)) continue;
            return true;
        }
        return false;
    }

    public void mouseWheelMoved(int mouseX, int mouseY, int delta) {
        if (this.parent != null) {
            this.parent.mouseWheelMoved(mouseX, mouseY, delta);
        }
    }

    @OverridingMethodsMustInvokeSuper
    public void update() {
        for (GuiElement child : this.children) {
            child.update();
        }
    }

    @OverridingMethodsMustInvokeSuper
    public void drawBackground(IParentScreen parentScreen, int mouseX, int mouseY) {
        for (GuiElement child : this.children) {
            child.drawBackground(parentScreen, mouseX, mouseY);
        }
    }

    @OverridingMethodsMustInvokeSuper
    public void drawForeground(IParentScreen parentScreen, int mouseX, int mouseY) {
        for (GuiElement child : this.children) {
            child.drawForeground(parentScreen, mouseX, mouseY);
        }
    }

    public boolean isInside(int x, int y) {
        if (!this.visible) {
            return false;
        }
        if (this.isDirty) {
            this.updatePosition();
        }
        return x >= this.absX && x < this.absX + this.width && y >= this.absY && y < this.absY + this.height;
    }

    public GuiElement getElementAt(int x, int y) {
        GuiElement foundChild = this.getChildAt(x, y);
        if (foundChild != null) {
            return foundChild.getElementAt(x, y);
        }
        return this;
    }

    @Nullable
    private GuiElement getChildAt(int x, int y) {
        if (!this.visible) {
            return null;
        }
        for (int i = this.children.size() - 1; i >= 0; --i) {
            GuiElement child = this.children.get(i);
            if (!child.visible || !child.isInside(x, y)) continue;
            return child;
        }
        return null;
    }

    public void removeAllChildren() {
        for (GuiElement child : this.children) {
            child.parent = null;
        }
        this.children.clear();
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void addTooltip(List<String> list) {
        if (this.parent != null) {
            this.parent.addTooltip(list);
        }
    }

    @Nullable
    public IParentScreen getParentScreen() {
        return this.parent != null ? this.parent.getParentScreen() : null;
    }

    public int getRelativeX() {
        return this.relX;
    }

    public int getRelativeY() {
        return this.relY;
    }
}

