/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.blay09.mods.refinedrelocation.api.Capabilities;
import net.blay09.mods.refinedrelocation.api.InternalMethods;
import net.blay09.mods.refinedrelocation.api.RefinedRelocationAPI;
import net.blay09.mods.refinedrelocation.api.TileOrMultipart;
import net.blay09.mods.refinedrelocation.api.container.ITileGuiHandler;
import net.blay09.mods.refinedrelocation.api.filter.IFilter;
import net.blay09.mods.refinedrelocation.api.filter.ISimpleFilter;
import net.blay09.mods.refinedrelocation.api.grid.ISortingGrid;
import net.blay09.mods.refinedrelocation.api.grid.ISortingGridMember;
import net.blay09.mods.refinedrelocation.api.grid.ISortingInventory;
import net.blay09.mods.refinedrelocation.client.gui.element.GuiOpenFilterButton;
import net.blay09.mods.refinedrelocation.filter.FilterRegistry;
import net.blay09.mods.refinedrelocation.grid.SortingGrid;
import net.blay09.mods.refinedrelocation.network.MessageContainer;
import net.blay09.mods.refinedrelocation.network.MessageFilterPreview;
import net.blay09.mods.refinedrelocation.network.MessageOpenGui;
import net.blay09.mods.refinedrelocation.network.NetworkHandler;
import net.blay09.mods.refinedrelocation.util.TileWrapper;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class InternalMethodsImpl
implements InternalMethods {
    private static final Map<Class, ITileGuiHandler> tileGuiHandlerMap = Maps.newHashMap();

    @Override
    public void registerFilter(Class<? extends IFilter> filterClass) {
        FilterRegistry.registerFilter(filterClass);
    }

    @Override
    public void addToSortingGrid(ISortingGridMember member) {
        ISortingGrid sortingGrid = member.getSortingGrid();
        if (sortingGrid != null) {
            return;
        }
        World world = member.getTileEntity().getWorld();
        BlockPos pos = member.getTileEntity().getPos();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            ISortingGridMember otherMember;
            TileEntity tileEntity = world.func_175625_s(pos.func_177972_a(facing));
            if (tileEntity == null || (otherMember = (ISortingGridMember)tileEntity.getCapability(Capabilities.SORTING_GRID_MEMBER, facing.func_176734_d())) == null || otherMember.getSortingGrid() == null) continue;
            if (sortingGrid != null) {
                ((SortingGrid)sortingGrid).mergeWith(otherMember.getSortingGrid());
                continue;
            }
            sortingGrid = otherMember.getSortingGrid();
        }
        if (sortingGrid == null) {
            sortingGrid = new SortingGrid();
        }
        sortingGrid.addMember(member);
    }

    @Override
    public void removeFromSortingGrid(ISortingGridMember member) {
        ISortingGrid sortingGrid = member.getSortingGrid();
        if (sortingGrid == null) {
            return;
        }
        sortingGrid.removeMember(member);
        for (ISortingGridMember otherMember : sortingGrid.getMembers()) {
            otherMember.setSortingGrid(null);
        }
        for (ISortingGridMember otherMember : sortingGrid.getMembers()) {
            RefinedRelocationAPI.addToSortingGrid(otherMember);
        }
    }

    @Override
    public void insertIntoSortingGrid(ISortingInventory sortingInventory, int fromSlotIndex, ItemStack itemStack) {
        ArrayList passingList = Lists.newArrayList();
        ItemStack restStack = sortingInventory.getItemHandler().extractItem(fromSlotIndex, 64, false);
        if (restStack == null) {
            return;
        }
        ISortingGrid sortingGrid = sortingInventory.getSortingGrid();
        for (ISortingGridMember member : sortingGrid.getMembers()) {
            ISortingInventory memberInventory;
            boolean passes;
            if (!(member instanceof ISortingInventory) || !(passes = (memberInventory = (ISortingInventory)member).getFilter().passes(memberInventory.getTileEntity(), itemStack))) continue;
            passingList.add(memberInventory);
        }
        if (passingList.isEmpty()) {
            sortingInventory.getItemHandler().insertItem(fromSlotIndex, restStack, false);
            return;
        }
        ISortingInventory targetInventory = InternalMethodsImpl.getBestTargetInventory(passingList, null);
        if (targetInventory == sortingInventory) {
            sortingInventory.getItemHandler().insertItem(fromSlotIndex, restStack, false);
            return;
        }
        while (restStack != null && !passingList.isEmpty() && targetInventory != null) {
            restStack = ItemHandlerHelper.insertItemStacked((IItemHandler)targetInventory.getItemHandler(), (ItemStack)restStack, (boolean)false);
            if (restStack == null) continue;
            targetInventory = InternalMethodsImpl.getBestTargetInventory(passingList, targetInventory);
        }
        if (restStack != null && (restStack = sortingInventory.getItemHandler().insertItem(fromSlotIndex, restStack, false)) != null) {
            throw new RuntimeException("Refined Relocation just ate one of your items and that's really weird because this should never happen. Now go and report this so I can have a further look into this.");
        }
    }

    @Nullable
    private static ISortingInventory getBestTargetInventory(List<ISortingInventory> passingList, @Nullable ISortingInventory lastInventory) {
        ISortingInventory targetInventory = null;
        int highestPriority = Integer.MIN_VALUE;
        Iterator<ISortingInventory> it = passingList.iterator();
        while (it.hasNext()) {
            ISortingInventory sortingInventory = it.next();
            if (sortingInventory == lastInventory) {
                it.remove();
                continue;
            }
            if (sortingInventory.getPriority() <= highestPriority) continue;
            targetInventory = sortingInventory;
            highestPriority = sortingInventory.getPriority();
        }
        return targetInventory;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiButton createOpenFilterButton(GuiContainer guiContainer, TileEntity tileEntity, int buttonId) {
        return new GuiOpenFilterButton(buttonId, guiContainer.field_147003_i + guiContainer.field_146999_f - 18, guiContainer.field_147009_r + 4, new TileWrapper(tileEntity));
    }

    @Override
    public void sendContainerMessageToServer(String key, String value) {
        NetworkHandler.wrapper.sendToServer((IMessage)new MessageContainer(key, value));
    }

    @Override
    public void sendContainerMessageToServer(String key, NBTTagCompound value) {
        NetworkHandler.wrapper.sendToServer((IMessage)new MessageContainer(key, value));
    }

    @Override
    public void sendContainerMessageToServer(String key, int value) {
        NetworkHandler.wrapper.sendToServer((IMessage)new MessageContainer(key, value));
    }

    @Override
    public void syncContainerValue(String key, String value, Iterable<IContainerListener> listeners) {
        this.syncContainerValue(new MessageContainer(key, value), listeners);
    }

    @Override
    public void syncContainerValue(String key, int value, Iterable<IContainerListener> listeners) {
        this.syncContainerValue(new MessageContainer(key, value), listeners);
    }

    @Override
    public void syncContainerValue(String key, byte[] value, Iterable<IContainerListener> listeners) {
        this.syncContainerValue(new MessageContainer(key, value), listeners);
    }

    @Override
    public void syncContainerValue(String key, NBTTagCompound value, Iterable<IContainerListener> listeners) {
        this.syncContainerValue(new MessageContainer(key, value), listeners);
    }

    private void syncContainerValue(MessageContainer message, Iterable<IContainerListener> listeners) {
        for (IContainerListener listener : listeners) {
            if (!(listener instanceof EntityPlayerMP)) continue;
            NetworkHandler.wrapper.sendTo((IMessage)message, (EntityPlayerMP)listener);
        }
    }

    public void registerGuiHandler(Class tileClass, ITileGuiHandler handler) {
        tileGuiHandlerMap.put(tileClass, handler);
    }

    @Nullable
    public static ITileGuiHandler getGuiHandler(Class tileClass) {
        return tileGuiHandlerMap.get(tileClass);
    }

    @Override
    public void openRootFilterGui(EntityPlayer player, TileEntity tileEntity) {
        NetworkHandler.wrapper.sendToServer((IMessage)new MessageOpenGui(2, tileEntity));
    }

    @Override
    public void updateFilterPreview(EntityPlayer entityPlayer, TileOrMultipart tileEntity, ISimpleFilter filter) {
        if (!entityPlayer.field_70170_p.field_72995_K) {
            byte[] slotStates = new byte[36];
            for (int i = 0; i < slotStates.length; ++i) {
                ItemStack itemStack = entityPlayer.field_71071_by.func_70301_a(i);
                if (itemStack == null) continue;
                slotStates[i] = (byte)(filter.passes(tileEntity, itemStack) ? 1 : 0);
            }
            NetworkHandler.wrapper.sendTo((IMessage)new MessageFilterPreview(slotStates), (EntityPlayerMP)entityPlayer);
        }
    }
}

