/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.vecmath;

import com.enderio.core.common.vecmath.Vector3d;
import com.enderio.core.common.vecmath.Vector3f;

public class Quat4d {
    public double x;
    public double y;
    public double z;
    public double w;

    public static Quat4d makeRotate(double angle, Vector3d axis) {
        double epsilon = 1.0E-7;
        double x = axis.x;
        double y = axis.y;
        double z = axis.z;
        double length = Math.sqrt(x * x + y * y + z * z);
        if (length < epsilon) {
            return new Quat4d();
        }
        double inversenorm = 1.0 / length;
        double coshalfangle = Math.cos(0.5 * angle);
        double sinhalfangle = Math.sin(0.5 * angle);
        Quat4d res = new Quat4d();
        res.x = x * sinhalfangle * inversenorm;
        res.y = y * sinhalfangle * inversenorm;
        res.z = z * sinhalfangle * inversenorm;
        res.w = coshalfangle;
        return res;
    }

    public void rotate(Vector3d vec) {
        double d = -this.x * vec.x - this.y * vec.y - this.z * vec.z;
        double d1 = this.w * vec.x + this.y * vec.z - this.z * vec.y;
        double d2 = this.w * vec.y - this.x * vec.z + this.z * vec.x;
        double d3 = this.w * vec.z + this.x * vec.y - this.y * vec.x;
        vec.x = d1 * this.w - d * this.x - d2 * this.z + d3 * this.y;
        vec.y = d2 * this.w - d * this.y + d1 * this.z - d3 * this.x;
        vec.z = d3 * this.w - d * this.z - d1 * this.y + d2 * this.x;
    }

    public void rotate(Vector3f vec) {
        double d = -this.x * (double)vec.x - this.y * (double)vec.y - this.z * (double)vec.z;
        double d1 = this.w * (double)vec.x + this.y * (double)vec.z - this.z * (double)vec.y;
        double d2 = this.w * (double)vec.y - this.x * (double)vec.z + this.z * (double)vec.x;
        double d3 = this.w * (double)vec.z + this.x * (double)vec.y - this.y * (double)vec.x;
        vec.x = (float)(d1 * this.w - d * this.x - d2 * this.z + d3 * this.y);
        vec.y = (float)(d2 * this.w - d * this.y + d1 * this.z - d3 * this.x);
        vec.z = (float)(d3 * this.w - d * this.z - d1 * this.y + d2 * this.x);
    }
}

