/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.tweaks;

import com.enderio.core.common.tweaks.InfiniBow;
import com.enderio.core.common.tweaks.SlabRecipes;
import com.enderio.core.common.tweaks.Tweak;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class Tweaks {
    private static final List<Tweak> tweaks = new ArrayList<Tweak>();

    public static void loadIngameTweaks() {
        tweaks.add(new Tweak("fixBedSound", "Makes the bed stepSound wool instead of stone"){

            @Override
            public void load() {
            }
        });
        tweaks.add(new Tweak("changeBoatStackSize", "Makes boats stack to 16"){

            @Override
            public void load() {
                Items.field_151124_az.func_77625_d(16);
            }
        });
        tweaks.add(new Tweak("fixPackedIceTool", "Allows packed ice to be mined with a pickaxe"){

            @Override
            public void load() {
                Blocks.field_150403_cj.setHarvestLevel("pickaxe", 0);
            }
        });
    }

    public static void loadNonIngameTweaks() {
        tweaks.add(new SlabRecipes());
        tweaks.add(new InfiniBow());
        tweaks.add(new Tweak("bookToPaperRecipe", "Adds shapeless recipe from 1 book to 2 paper"){

            @Override
            public void load() {
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Items.field_151121_aF, 2), (Object[])new Object[]{Items.field_151122_aG});
            }
        });
        tweaks.add(new Tweak("shapelessPaperRecipe", "Adds a shapeless recipe for paper"){

            @Override
            public void load() {
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Items.field_151121_aF, 3), (Object[])new Object[]{Items.field_151120_aE, Items.field_151120_aE, Items.field_151120_aE});
            }
        });
    }
}

