/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.transform;

import com.enderio.core.common.config.ConfigHandler;
import com.enderio.core.common.event.AnvilMaxCostEvent;
import com.enderio.core.common.event.ItemGUIRenderEvent;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerFurnace;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EnderCoreMethods {
    public static int getMaxAnvilCost(Object source) {
        int maxCost = ConfigHandler.invisibleMode == 1 ? 40 : ConfigHandler.anvilMaxLevel;
        AnvilMaxCostEvent event = new AnvilMaxCostEvent(source, maxCost);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getMaxAnvilCost();
    }

    public static ItemStack transferStackInSlot(ContainerFurnace inv, EntityPlayer p_82846_1_, int p_82846_2_) {
        ItemStack itemstack = null;
        Slot slot = (Slot)inv.field_75151_b.get(p_82846_2_);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (p_82846_2_ == 2) {
                if (!EnderCoreMethods.mergeItemStack((Container)inv, itemstack1, 3, 39, true)) {
                    return null;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (p_82846_2_ != 1 && p_82846_2_ != 0 ? (TileEntityFurnace.func_145954_b((ItemStack)itemstack1) ? !EnderCoreMethods.mergeItemStack((Container)inv, itemstack1, 1, 2, false) && FurnaceRecipes.func_77602_a().func_151395_a(itemstack1) != null && !EnderCoreMethods.mergeItemStack((Container)inv, itemstack1, 0, 1, false) : (FurnaceRecipes.func_77602_a().func_151395_a(itemstack1) != null ? !EnderCoreMethods.mergeItemStack((Container)inv, itemstack1, 0, 1, false) : (p_82846_2_ >= 3 && p_82846_2_ < 30 ? !EnderCoreMethods.mergeItemStack((Container)inv, itemstack1, 30, 39, false) : p_82846_2_ >= 30 && p_82846_2_ < 39 && !EnderCoreMethods.mergeItemStack((Container)inv, itemstack1, 3, 30, false)))) : !EnderCoreMethods.mergeItemStack((Container)inv, itemstack1, 3, 39, false)) {
                return null;
            }
            if (itemstack1.field_77994_a == 0) {
                slot.func_75215_d((ItemStack)null);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.field_77994_a == itemstack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(p_82846_1_, itemstack1);
        }
        return itemstack;
    }

    private static boolean mergeItemStack(Container inv, ItemStack p_75135_1_, int p_75135_2_, int p_75135_3_, boolean p_75135_4_) {
        ItemStack itemstack1;
        Slot slot;
        boolean flag1 = false;
        int k = p_75135_2_;
        if (p_75135_4_) {
            k = p_75135_3_ - 1;
        }
        if (p_75135_1_.func_77985_e()) {
            while (p_75135_1_.field_77994_a > 0 && (!p_75135_4_ && k < p_75135_3_ || p_75135_4_ && k >= p_75135_2_)) {
                slot = (Slot)inv.field_75151_b.get(k);
                itemstack1 = slot.func_75211_c();
                if (itemstack1 != null && itemstack1.func_77973_b() == p_75135_1_.func_77973_b() && (!p_75135_1_.func_77981_g() || p_75135_1_.func_77952_i() == itemstack1.func_77952_i()) && ItemStack.func_77970_a((ItemStack)p_75135_1_, (ItemStack)itemstack1)) {
                    int l = itemstack1.field_77994_a + p_75135_1_.field_77994_a;
                    if (l <= p_75135_1_.func_77976_d()) {
                        p_75135_1_.field_77994_a = 0;
                        itemstack1.field_77994_a = l;
                        slot.func_75218_e();
                        flag1 = true;
                    } else if (itemstack1.field_77994_a < p_75135_1_.func_77976_d()) {
                        p_75135_1_.field_77994_a -= p_75135_1_.func_77976_d() - itemstack1.field_77994_a;
                        itemstack1.field_77994_a = p_75135_1_.func_77976_d();
                        slot.func_75218_e();
                        flag1 = true;
                    }
                }
                if (p_75135_4_) {
                    --k;
                    continue;
                }
                ++k;
            }
        }
        if (p_75135_1_.field_77994_a > 0) {
            k = p_75135_4_ ? p_75135_3_ - 1 : p_75135_2_;
            while (!p_75135_4_ && k < p_75135_3_ || p_75135_4_ && k >= p_75135_2_) {
                slot = (Slot)inv.field_75151_b.get(k);
                itemstack1 = slot.func_75211_c();
                if (itemstack1 == null) {
                    slot.func_75215_d(p_75135_1_.func_77946_l());
                    slot.func_75218_e();
                    p_75135_1_.field_77994_a = 0;
                    flag1 = true;
                    break;
                }
                if (p_75135_4_) {
                    --k;
                    continue;
                }
                ++k;
            }
        }
        return flag1;
    }

    public static void renderItemOverlayIntoGUI(ItemStack stack, int xPosition, int yPosition) {
        if (stack != null) {
            if (stack.func_77973_b() instanceof IOverlayRenderAware) {
                ((IOverlayRenderAware)stack.func_77973_b()).renderItemOverlayIntoGUI(stack, xPosition, yPosition);
            }
            MinecraftForge.EVENT_BUS.post((Event)new ItemGUIRenderEvent.Post(stack, xPosition, yPosition));
        }
    }

    public static void renderItemAndEffectIntoGUI(ItemStack stack, int xPosition, int yPosition) {
        if (stack != null) {
            if (stack.func_77973_b() instanceof IUnderlayRenderAware) {
                ((IUnderlayRenderAware)stack.func_77973_b()).renderItemAndEffectIntoGUI(stack, xPosition, yPosition);
            }
            MinecraftForge.EVENT_BUS.post((Event)new ItemGUIRenderEvent.Pre(stack, xPosition, yPosition));
        }
    }

    public static boolean isElytraFlying(EntityLivingBase entity) {
        ItemStack itemstack = entity.func_184582_a(EntityEquipmentSlot.CHEST);
        if (itemstack != null && itemstack.func_77973_b() instanceof IElytraFlyingProvider2) {
            return ((IElytraFlyingProvider2)itemstack.func_77973_b()).isElytraFlying(entity, itemstack, entity.field_70122_E || entity.func_184218_aH() || entity.func_70090_H() || EnderCoreMethods.isInLavaSafe((Entity)entity));
        }
        return false;
    }

    public static boolean isInLavaSafe(Entity entity) {
        return EnderCoreMethods.isMaterialInBBSafe(entity.field_70170_p, entity.func_174813_aQ().func_72314_b((double)-0.1f, (double)-0.4f, (double)-0.1f), Material.field_151587_i);
    }

    public static boolean isMaterialInBBSafe(World world, AxisAlignedBB bb, Material materialIn) {
        int i = MathHelper.func_76128_c((double)bb.field_72340_a);
        int j = MathHelper.func_76143_f((double)bb.field_72336_d);
        int k = MathHelper.func_76128_c((double)bb.field_72338_b);
        int l = MathHelper.func_76143_f((double)bb.field_72337_e);
        int i1 = MathHelper.func_76128_c((double)bb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)bb.field_72334_f);
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$pooledmutableblockpos.func_181079_c(k1, l1, i2);
                    if (!world.func_175668_a((BlockPos)blockpos$pooledmutableblockpos, false) || world.func_180495_p((BlockPos)blockpos$pooledmutableblockpos).func_185904_a() != materialIn) continue;
                    blockpos$pooledmutableblockpos.func_185344_t();
                    return true;
                }
            }
        }
        blockpos$pooledmutableblockpos.func_185344_t();
        return false;
    }

    public static boolean isCreeperTarget(EntityCreeper swellingCreeper, EntityLivingBase entitylivingbase) {
        if (entitylivingbase instanceof ICreeperTarget) {
            return ((ICreeperTarget)entitylivingbase).isCreeperTarget(swellingCreeper);
        }
        return true;
    }

    public static interface ICreeperTarget {
        public boolean isCreeperTarget(EntityCreeper var1);
    }

    public static interface IElytraFlyingProvider2 {
        public boolean isElytraFlying(EntityLivingBase var1, ItemStack var2, boolean var3);
    }

    @Deprecated
    public static interface IElytraFlyingProvider {
        public boolean isElytraFlying(EntityLivingBase var1, ItemStack var2);
    }

    public static interface IUnderlayRenderAware {
        public void renderItemAndEffectIntoGUI(ItemStack var1, int var2, int var3);
    }

    public static interface IOverlayRenderAware {
        public void renderItemOverlayIntoGUI(ItemStack var1, int var2, int var3);
    }
}

