/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.render;

import com.enderio.core.common.vecmath.Vector3f;
import com.enderio.core.common.vecmath.Vector4f;
import java.awt.Color;
import org.lwjgl.opengl.GL11;

public final class ColorUtil {
    public static Vector4f toFloat(Color color) {
        float[] rgba = color.getComponents(null);
        return new Vector4f(rgba[0], rgba[1], rgba[2], rgba[3]);
    }

    public static Vector3f toFloat(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        return new Vector3f((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
    }

    public static Vector4f toFloat4(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        return new Vector4f((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 1.0f);
    }

    public static int getRGB(Color color) {
        return ColorUtil.getRGB(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static int getRGBA(Color color) {
        return ColorUtil.getRGBA(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public static int getARGB(Color color) {
        return ColorUtil.getRGBA(color.getAlpha(), color.getRed(), color.getGreen(), color.getBlue());
    }

    public static int getRGB(Vector3f rgb) {
        return ColorUtil.getRGB(rgb.x, rgb.y, rgb.z);
    }

    public static int getRGB(float r, float g, float b) {
        return ColorUtil.getRGB((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f));
    }

    public static int getRGBA(Vector4f col) {
        return ColorUtil.getRGBA(col.x, col.y, col.z, col.w);
    }

    public static int getRGBA(float r, float g, float b, float a) {
        return ColorUtil.getRGBA((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f), (int)(a * 255.0f));
    }

    public static int getARGB(float r, float g, float b, float a) {
        return ColorUtil.getARGB((int)(a * 255.0f), (int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f));
    }

    public static int getRGB(int r, int g, int b) {
        return (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int getARGB(int r, int g, int b, int a) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int getRGBA(int r, int g, int b, int a) {
        return (r & 0xFF) << 24 | (g & 0xFF) << 16 | (b & 0xFF) << 8 | a & 0xFF;
    }

    public static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
    }

    public static int toHex(int r, int g, int b) {
        int hex = 0;
        hex |= r << 16;
        hex |= g << 8;
        return hex |= b;
    }

    private ColorUtil() {
    }
}

