/*
 * Decompiled with CFR 0.152.
 */
package ic2.jeiIntegration.recipe.machine;

import ic2.api.item.IBlockCuttingBlade;
import ic2.api.recipe.IElectrolyzerRecipeManager;
import ic2.api.recipe.IMachineRecipeManager;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeOutput;
import ic2.core.item.type.BlockCuttingBladeType;
import ic2.core.item.type.CraftingItemType;
import ic2.core.ref.BlockName;
import ic2.core.ref.ItemName;
import ic2.core.ref.TeBlock;
import ic2.core.util.StackUtil;
import ic2.jeiIntegration.recipe.machine.AdvancedIORecipeWrapper;
import ic2.jeiIntegration.recipe.machine.ElectrolyzerWrapper;
import ic2.jeiIntegration.recipe.machine.IORecipeCategory;
import ic2.jeiIntegration.recipe.machine.IORecipeWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public interface IRecipeWrapperGenerator<T> {
    public static final IRecipeWrapperGenerator<IMachineRecipeManager> basicMachine = new IRecipeWrapperGenerator<IMachineRecipeManager>(){

        @Override
        public List<IRecipeWrapper> getRecipeList(IORecipeCategory<IMachineRecipeManager> category) {
            ArrayList<IRecipeWrapper> recipes = new ArrayList<IRecipeWrapper>();
            for (IMachineRecipeManager.RecipeIoContainer container : ((IMachineRecipeManager)category.recipeManager).getRecipes()) {
                recipes.add((IRecipeWrapper)new IORecipeWrapper(container, category));
            }
            return recipes;
        }
    };
    public static final IRecipeWrapperGenerator<IMachineRecipeManager> recycler = new IRecipeWrapperGenerator<IMachineRecipeManager>(){

        @Override
        public List<IRecipeWrapper> getRecipeList(IORecipeCategory<IMachineRecipeManager> category) {
            IRecipeInput input = new IRecipeInput(){

                @Override
                public boolean matches(ItemStack subject) {
                    return StackUtil.checkItemEquality(subject, BlockName.te.getItemStack(TeBlock.recycler));
                }

                @Override
                public List<ItemStack> getInputs() {
                    return Collections.singletonList(BlockName.te.getItemStack(TeBlock.recycler));
                }

                @Override
                public int getAmount() {
                    return 1;
                }
            };
            return Collections.singletonList(new IORecipeWrapper(new IMachineRecipeManager.RecipeIoContainer(input, new RecipeOutput(null, ItemName.crafting.getItemStack(CraftingItemType.scrap))), category));
        }
    };
    public static final IRecipeWrapperGenerator<IMachineRecipeManager> blockCutter = new IRecipeWrapperGenerator<IMachineRecipeManager>(){
        private final List<ItemStack> candidates = Arrays.asList(ItemName.block_cutting_blade.getItemStack(BlockCuttingBladeType.iron), ItemName.block_cutting_blade.getItemStack(BlockCuttingBladeType.steel), ItemName.block_cutting_blade.getItemStack(BlockCuttingBladeType.diamond));

        @Override
        public List<IRecipeWrapper> getRecipeList(IORecipeCategory<IMachineRecipeManager> category) {
            ArrayList<IRecipeWrapper> list = new ArrayList<IRecipeWrapper>();
            for (IMachineRecipeManager.RecipeIoContainer container : ((IMachineRecipeManager)category.recipeManager).getRecipes()) {
                list.add((IRecipeWrapper)new AdvancedIORecipeWrapper(container, this.getInput(this.getHadness(container.output)), category));
            }
            return list;
        }

        private int getHadness(RecipeOutput output) {
            if (output.metadata == null) {
                return Integer.MAX_VALUE;
            }
            return output.metadata.func_74762_e("hardness");
        }

        private IRecipeInput getInput(final int hardness) {
            return new IRecipeInput(){

                @Override
                public boolean matches(ItemStack subject) {
                    return subject != null && subject.func_77973_b() instanceof IBlockCuttingBlade && ((IBlockCuttingBlade)subject.func_77973_b()).getHardness(subject) > hardness;
                }

                @Override
                public List<ItemStack> getInputs() {
                    ArrayList<ItemStack> list = new ArrayList<ItemStack>(candidates.size());
                    for (ItemStack stack : candidates) {
                        if (((IBlockCuttingBlade)stack.func_77973_b()).getHardness(stack) < hardness) continue;
                        list.add(stack);
                    }
                    return list;
                }

                @Override
                public int getAmount() {
                    return 1;
                }
            };
        }
    };
    public static final IRecipeWrapperGenerator<IElectrolyzerRecipeManager> electrolyzer = new IRecipeWrapperGenerator<IElectrolyzerRecipeManager>(){

        @Override
        public List<IRecipeWrapper> getRecipeList(IORecipeCategory<IElectrolyzerRecipeManager> category) {
            ArrayList<IRecipeWrapper> recipes = new ArrayList<IRecipeWrapper>();
            for (Map.Entry<String, IElectrolyzerRecipeManager.ElectrolyzerRecipe> recipe : ((IElectrolyzerRecipeManager)category.recipeManager).getRecipeMap().entrySet()) {
                Fluid input = FluidRegistry.getFluid((String)recipe.getKey());
                if (input == null) continue;
                recipes.add((IRecipeWrapper)new ElectrolyzerWrapper(new FluidStack(input, recipe.getValue().inputAmount), recipe.getValue().outputs, category));
            }
            return recipes;
        }
    };

    public List<IRecipeWrapper> getRecipeList(IORecipeCategory<T> var1);
}

