/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.uu;

import ic2.core.IC2;
import ic2.core.recipe.AdvRecipe;
import ic2.core.util.LogCategory;
import ic2.core.util.StackUtil;
import ic2.core.uu.IRecipeResolver;
import ic2.core.uu.LeanItemStack;
import ic2.core.uu.RecipeTransformation;
import ic2.core.uu.RecipeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class ForgeCraftingResolver
implements IRecipeResolver {
    private static final double transformCost = 1.0;

    @Override
    public List<RecipeTransformation> getTransformations() {
        ArrayList<RecipeTransformation> ret = new ArrayList<RecipeTransformation>();
        for (IRecipe irecipe : CraftingManager.func_77594_a().func_77592_b()) {
            Object[] inputs = null;
            ItemStack output = null;
            try {
                ShapedOreRecipe recipe;
                if (irecipe instanceof ShapedOreRecipe) {
                    recipe = (ShapedOreRecipe)irecipe;
                    inputs = recipe.getInput();
                    output = recipe.func_77571_b();
                } else {
                    if (!(irecipe instanceof ShapelessOreRecipe)) continue;
                    recipe = (ShapelessOreRecipe)irecipe;
                    inputs = recipe.getInput().toArray();
                    output = recipe.func_77571_b();
                }
                if (StackUtil.isEmpty(output)) continue;
                ret.add(new RecipeTransformation(1.0, RecipeUtil.fixIngredientSize(AdvRecipe.expandArray(inputs)), new LeanItemStack(output)));
            }
            catch (Throwable t) {
                List inputsList = inputs == null ? null : Arrays.asList(inputs);
                IC2.log.warn(LogCategory.Uu, t, "invalid recipe (" + irecipe.getClass().getName() + ", " + inputsList + " -> " + output + ")");
            }
        }
        return ret;
    }
}

