/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.recipe;

import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.IRecipeInputFactory;
import ic2.api.recipe.RecipeInputFluidContainer;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.RecipeInputOreDict;
import ic2.core.recipe.RecipeInputMultiple;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;

public class RecipeInputFactory
implements IRecipeInputFactory {
    @Override
    public IRecipeInput forStack(ItemStack stack) {
        return new RecipeInputItemStack(stack);
    }

    @Override
    public IRecipeInput forStack(ItemStack stack, int amount) {
        return new RecipeInputItemStack(stack, amount);
    }

    @Override
    public IRecipeInput forOreDict(String name) {
        return new RecipeInputOreDict(name);
    }

    @Override
    public IRecipeInput forOreDict(String name, int amount) {
        return new RecipeInputOreDict(name, amount);
    }

    @Override
    public IRecipeInput forOreDict(String name, int amount, int metaOverride) {
        return new RecipeInputOreDict(name, amount, metaOverride);
    }

    @Override
    public IRecipeInput forFluidContainer(Fluid fluid) {
        return new RecipeInputFluidContainer(fluid);
    }

    @Override
    public IRecipeInput forFluidContainer(Fluid fluid, int amount) {
        return new RecipeInputFluidContainer(fluid, amount);
    }

    @Override
    public IRecipeInput forAny(IRecipeInput ... options) {
        return new RecipeInputMultiple(options);
    }

    @Override
    public IRecipeInput forAny(Iterable<IRecipeInput> options) {
        if (options instanceof Collection) {
            return new RecipeInputMultiple(((Collection)options).toArray(new IRecipeInput[0]));
        }
        IRecipeInput[] optionsArray = new IRecipeInput[16];
        int pos = 0;
        for (IRecipeInput option : options) {
            if (pos >= optionsArray.length) {
                optionsArray = Arrays.copyOf(optionsArray, optionsArray.length * 2);
            }
            optionsArray[pos] = option;
            ++pos;
        }
        if (pos != optionsArray.length) {
            optionsArray = Arrays.copyOf(optionsArray, pos);
        }
        return new RecipeInputMultiple(optionsArray);
    }
}

