/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.upgrade;

import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import ic2.api.network.ClientModifiable;
import ic2.core.ContainerBase;
import ic2.core.GuiIC2;
import ic2.core.IC2;
import ic2.core.gui.EnumCycleHandler;
import ic2.core.gui.GuiElement;
import ic2.core.gui.IClickHandler;
import ic2.core.gui.IEnableHandler;
import ic2.core.gui.MouseButton;
import ic2.core.gui.SlotGrid;
import ic2.core.gui.Text;
import ic2.core.gui.TextBox;
import ic2.core.gui.VanillaButton;
import ic2.core.gui.dynamic.TextProvider;
import ic2.core.init.Localization;
import ic2.core.item.ContainerHandHeldInventory;
import ic2.core.item.upgrade.ComparisonSettings;
import ic2.core.item.upgrade.ComparisonType;
import ic2.core.item.upgrade.HandHeldAdvancedUpgrade;
import ic2.core.item.upgrade.HandHeldUpgradeOption;
import ic2.core.item.upgrade.MoveableButton;
import ic2.core.item.upgrade.MoveableTextBox;
import ic2.core.item.upgrade.Settings;
import ic2.core.slot.SlotHologramSlot;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class HandHeldMeta
extends HandHeldUpgradeOption {
    protected final ComparisonType initialComparisonType;
    protected final String initialNormalBox;
    protected final String initialExtraBox;
    protected final ComparisonSettings initialNormalSetting;
    protected final ComparisonSettings initialExtraSetting;

    public HandHeldMeta(HandHeldAdvancedUpgrade upgradeGUI) {
        super(upgradeGUI, "meta");
        Settings settings = new Settings(this.getNBT());
        this.initialComparisonType = settings.comparison;
        this.initialNormalBox = settings.mainBox;
        this.initialExtraBox = settings.extraBox;
        this.initialNormalSetting = settings.main;
        this.initialExtraSetting = settings.extra;
    }

    @Override
    public ContainerBase<?> getGuiContainer(EntityPlayer player) {
        return new ContainerEditMeta();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean isAdmin) {
        return new GuiEditMeta();
    }

    @SideOnly(value=Side.CLIENT)
    public class GuiEditMeta
    extends GuiIC2<ContainerEditMeta> {
        public GuiEditMeta() {
            super(new ContainerEditMeta());
            this.addElement(HandHeldMeta.this.getBackButton(this));
            this.addElement((GuiElement<?>)((VanillaButton)new VanillaButton(this, 10, 25, 75, 15, new EnumCycleHandler<ComparisonType>(ComparisonType.values(), ((ContainerEditMeta)this.container).comparisonType){

                @Override
                public void onClick(MouseButton button) {
                    super.onClick(button);
                    ((ContainerEditMeta)((GuiEditMeta)GuiEditMeta.this).container).comparisonType = (ComparisonType)((Object)this.getCurrentValue());
                    IC2.network.get(false).sendContainerField(GuiEditMeta.this.container, "comparisonType");
                }
            }).withText(new Supplier<String>(){

                public String get() {
                    return Localization.translate(((ContainerEditMeta)((GuiEditMeta)GuiEditMeta.this).container).comparisonType.name);
                }
            })).withTooltip(new Supplier<String>(){

                public String get() {
                    return Localization.translate(((ContainerEditMeta)((GuiEditMeta)GuiEditMeta.this).container).comparisonType.name + ".desc", Localization.translate("ic2.upgrade.advancedGUI.meta"));
                }
            }));
            IEnableHandler rangeEnabled = new IEnableHandler(){

                @Override
                public boolean isEnabled() {
                    return ((ContainerEditMeta)((GuiEditMeta)GuiEditMeta.this).container).comparisonType == ComparisonType.RANGE;
                }
            };
            IEnableHandler filtersEnabled = new IEnableHandler(){

                @Override
                public boolean isEnabled() {
                    return !((ContainerEditMeta)((GuiEditMeta)GuiEditMeta.this).container).comparisonType.ignoreFilters();
                }
            };
            this.addElement((GuiElement<?>)((VanillaButton)((VanillaButton)new MoveableButton(this, 75, 43, 60, 43, 17, 15, new EnumCycleHandler<ComparisonSettings>(ComparisonSettings.values(), ((ContainerEditMeta)this.container).normalSetting){

                @Override
                public void onClick(MouseButton button) {
                    super.onClick(button);
                    ((ContainerEditMeta)((GuiEditMeta)GuiEditMeta.this).container).normalSetting = (ComparisonSettings)((Object)this.getCurrentValue());
                    IC2.network.get(false).sendContainerField(GuiEditMeta.this.container, "normalSetting");
                    switch ((ComparisonSettings)((Object)this.getCurrentValue())) {
                        case LESS: 
                        case LESS_OR_EQUAL: {
                            if (((ContainerEditMeta)((GuiEditMeta)GuiEditMeta.this).container).extraSetting == ComparisonSettings.LESS || ((ContainerEditMeta)((GuiEditMeta)GuiEditMeta.this).container).extraSetting == ComparisonSettings.LESS_OR_EQUAL) break;
                            ((ContainerEditMeta)((GuiEditMeta)GuiEditMeta.this).container).extraSetting = ComparisonSettings.LESS;
                            IC2.network.get(false).sendContainerField(GuiEditMeta.this.container, "extraSetting");
                            break;
                        }
                        case GREATER: 
                        case GREATER_OR_EQUAL: {
                            if (((ContainerEditMeta)((GuiEditMeta)GuiEditMeta.this).container).extraSetting == ComparisonSettings.GREATER || ((ContainerEditMeta)((GuiEditMeta)GuiEditMeta.this).container).extraSetting == ComparisonSettings.GREATER_OR_EQUAL) break;
                            ((ContainerEditMeta)((GuiEditMeta)GuiEditMeta.this).container).extraSetting = ComparisonSettings.GREATER;
                            IC2.network.get(false).sendContainerField(GuiEditMeta.this.container, "extraSetting");
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unexpected other setting: " + this.getCurrentValue());
                        }
                    }
                }
            }).withMoveHandler(rangeEnabled).withEnableHandler(filtersEnabled)).withText(new Supplier<String>(){

                public String get() {
                    return ((ContainerEditMeta)((GuiEditMeta)GuiEditMeta.this).container).normalSetting.symbol;
                }
            })).withTooltip(new Supplier<String>(){

                public String get() {
                    return Localization.translate(((ContainerEditMeta)((GuiEditMeta)GuiEditMeta.this).container).normalSetting.name);
                }
            }));
            this.addElement((GuiElement<?>)((VanillaButton)((VanillaButton)new VanillaButton(this, 105, 43, 17, 15, new IClickHandler(){

                @Override
                public void onClick(MouseButton button) {
                    if (button == MouseButton.left || button == MouseButton.right) {
                        switch (((ContainerEditMeta)((GuiEditMeta)GuiEditMeta.this).container).normalSetting) {
                            case LESS: 
                            case LESS_OR_EQUAL: {
                                if (((ContainerEditMeta)((GuiEditMeta)GuiEditMeta.this).container).extraSetting == ComparisonSettings.LESS) {
                                    ((ContainerEditMeta)((GuiEditMeta)GuiEditMeta.this).container).extraSetting = ComparisonSettings.LESS_OR_EQUAL;
                                    break;
                                }
                                ((ContainerEditMeta)((GuiEditMeta)GuiEditMeta.this).container).extraSetting = ComparisonSettings.LESS;
                                break;
                            }
                            case GREATER: 
                            case GREATER_OR_EQUAL: {
                                if (((ContainerEditMeta)((GuiEditMeta)GuiEditMeta.this).container).extraSetting == ComparisonSettings.GREATER) {
                                    ((ContainerEditMeta)((GuiEditMeta)GuiEditMeta.this).container).extraSetting = ComparisonSettings.GREATER_OR_EQUAL;
                                    break;
                                }
                                ((ContainerEditMeta)((GuiEditMeta)GuiEditMeta.this).container).extraSetting = ComparisonSettings.GREATER;
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unexpected other setting: " + (Object)((Object)((ContainerEditMeta)((GuiEditMeta)GuiEditMeta.this).container).normalSetting));
                            }
                        }
                        IC2.network.get(false).sendContainerField(GuiEditMeta.this.container, "extraSetting");
                    }
                }
            }).withEnableHandler(rangeEnabled)).withText(new Supplier<String>(){

                public String get() {
                    return ((ContainerEditMeta)((GuiEditMeta)GuiEditMeta.this).container).extraSetting.symbol;
                }
            })).withTooltip(new Supplier<String>(){

                public String get() {
                    return Localization.translate(((ContainerEditMeta)((GuiEditMeta)GuiEditMeta.this).container).extraSetting.name);
                }
            }));
            Predicate<String> numberOnly = new Predicate<String>(){

                public boolean apply(String input) {
                    try {
                        Integer.parseInt(input);
                        return true;
                    }
                    catch (NumberFormatException e) {
                        return input.isEmpty();
                    }
                }
            };
            final MoveableTextBox textBox = new MoveableTextBox(this, 40, 43, 25, 43, 30, 15, ((ContainerEditMeta)this.container).normalBox);
            this.addElement((GuiElement<?>)textBox.withMoveHandler(rangeEnabled).withTextWatcher(new TextBox.ITextBoxWatcher(){

                @Override
                public void onChanged(String oldValue, String newValue) {
                    ((ContainerEditMeta)((GuiEditMeta)GuiEditMeta.this).container).normalBox = newValue;
                    IC2.network.get(false).sendContainerField(GuiEditMeta.this.container, "normalBox");
                }
            }).withTextValidator(numberOnly).withEnableHandler(filtersEnabled));
            this.addElement((GuiElement<?>)new TextBox(this, 125, 43, 30, 15, ((ContainerEditMeta)this.container).extraBox).withTextWatcher(new TextBox.ITextBoxWatcher(){

                @Override
                public void onChanged(String oldValue, String newValue) {
                    ((ContainerEditMeta)((GuiEditMeta)GuiEditMeta.this).container).extraBox = newValue;
                    IC2.network.get(false).sendContainerField(GuiEditMeta.this.container, "extraBox");
                }
            }).withTextValidator(numberOnly).withEnableHandler(rangeEnabled));
            this.addElement((GuiElement<?>)Text.create(this, 100, 47, TextProvider.ofTranslated("ic2.upgrade.advancedGUI.meta"), 0x404040, false).withEnableHandler(new IEnableHandler(){

                @Override
                public boolean isEnabled() {
                    return textBox.isEnabled() && !textBox.isMoved();
                }
            }));
            this.addElement((GuiElement<?>)Text.create(this, 80, 47, TextProvider.ofTranslated("ic2.upgrade.advancedGUI.meta"), 0x404040, false).withEnableHandler(new IEnableHandler(){

                @Override
                public boolean isEnabled() {
                    return textBox.isEnabled() && textBox.isMoved();
                }
            }));
            this.addElement(new SlotGrid(this, 7, 7, 9, 1, SlotGrid.SlotStyle.Normal));
            this.addElement(new SlotGrid(this, 7, 83, 9, 3, SlotGrid.SlotStyle.Normal));
            this.addElement(new SlotGrid(this, 7, 141, 9, 1, SlotGrid.SlotStyle.Normal));
        }

        @Override
        protected void drawBackgroundAndTitle(float partialTicks, int mouseX, int mouseY) {
            int side;
            GuiElement.bindCommonTexture();
            this.drawTexturedRect(-16.0, -16.0, 32.0, 32.0, 0.0, 0.0);
            this.drawTexturedRect(this.field_146999_f - 16, -16.0, 32.0, 32.0, 64.0, 0.0);
            this.drawTexturedRect(-16.0, this.field_147000_g - 16, 32.0, 32.0, 0.0, 64.0);
            this.drawTexturedRect(this.field_146999_f - 16, this.field_147000_g - 16, 32.0, 32.0, 64.0, 64.0);
            for (side = 0; side < 2; ++side) {
                int y = this.field_147000_g * side - 16;
                int v = 64 * side;
                for (int x = 16; x < this.field_146999_f - 16; x += 32) {
                    this.drawTexturedRect(x, y, Math.min(32, this.field_146999_f - 16 - x), 32.0, 32.0, v);
                }
            }
            for (side = 0; side < 2; ++side) {
                int x = this.field_146999_f * side - 16;
                int u = 64 * side;
                for (int y = 16; y < this.field_147000_g - 16; y += 32) {
                    this.drawTexturedRect(x, y, 32.0, Math.min(32, this.field_147000_g - 16 - y), u, 32.0);
                }
            }
            for (int y = 16; y < this.field_147000_g - 16; y += 32) {
                int height = Math.min(32, this.field_147000_g - 16 - y);
                for (int x = 16; x < this.field_146999_f - 16; x += 32) {
                    this.drawTexturedRect(x, y, Math.min(32, this.field_146999_f - 16 - x), height, 32.0, 32.0);
                }
            }
        }

        @Override
        protected ResourceLocation getTexture() {
            return null;
        }
    }

    public class ContainerEditMeta
    extends ContainerHandHeldInventory<HandHeldMeta> {
        @ClientModifiable
        protected ComparisonType comparisonType;
        @ClientModifiable
        protected String normalBox;
        @ClientModifiable
        protected String extraBox;
        @ClientModifiable
        protected ComparisonSettings normalSetting;
        @ClientModifiable
        protected ComparisonSettings extraSetting;

        public ContainerEditMeta() {
            super(HandHeldMeta.this);
            this.comparisonType = HandHeldMeta.this.initialComparisonType;
            this.normalBox = HandHeldMeta.this.initialNormalBox;
            this.extraBox = HandHeldMeta.this.initialExtraBox;
            this.normalSetting = HandHeldMeta.this.initialNormalSetting;
            this.extraSetting = HandHeldMeta.this.initialExtraSetting;
            this.addPlayerInventorySlots(HandHeldMeta.this.player, 166);
            for (int slot = 0; slot < 9; slot = (int)((byte)(slot + 1))) {
                this.func_75146_a(new SlotHologramSlot(HandHeldMeta.this.inventory, slot, 8 + 18 * slot, 8, 1, HandHeldMeta.this.makeSaveCallback()));
            }
        }

        @Override
        public void func_75134_a(EntityPlayer player) {
            NBTTagCompound nbt = HandHeldMeta.this.getNBT();
            nbt.func_74757_a("active", this.comparisonType != ComparisonType.IGNORED);
            ComparisonType saveType = this.comparisonType;
            switch (this.comparisonType) {
                case COMPARISON: {
                    if (this.normalBox.isEmpty()) {
                        saveType = ComparisonType.DIRECT;
                    } else {
                        nbt.func_74778_a("normal", this.normalBox);
                        nbt.func_74774_a("normalComp", this.normalSetting.getForNBT());
                    }
                }
                case RANGE: {
                    if (this.normalBox.isEmpty()) {
                        if (this.extraBox.isEmpty()) {
                            saveType = ComparisonType.DIRECT;
                            break;
                        }
                        saveType = ComparisonType.COMPARISON;
                        nbt.func_74778_a("normal", this.extraBox);
                        nbt.func_74774_a("normalComp", this.extraSetting.getForNBT());
                        break;
                    }
                    nbt.func_74778_a("normal", this.normalBox);
                    nbt.func_74774_a("normalComp", this.normalSetting.getForNBT());
                    if (this.extraBox.isEmpty()) {
                        saveType = ComparisonType.COMPARISON;
                        break;
                    }
                    nbt.func_74778_a("extra", this.extraBox);
                    nbt.func_74774_a("extraComp", this.extraSetting.getForNBT());
                }
            }
            nbt.func_74774_a("type", saveType.getForNBT());
            super.func_75134_a(player);
        }
    }
}

