/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.init;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import ic2.core.IC2;
import ic2.core.util.LogCategory;
import ic2.core.util.ReflectionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.io.IOUtils;

public class Ic2Loot {
    private static Gson gson;

    public static void init() {
        new Ic2Loot();
    }

    private Ic2Loot() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        try {
            LootTable table;
            if (!event.getName().func_110624_b().equals("minecraft")) {
                return;
            }
            InputStream is = this.getClass().getResourceAsStream("/assets/ic2/loot_tables/" + event.getName().func_110623_a() + ".json");
            if (is == null) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            InputStreamReader reader = null;
            try {
                int len;
                reader = new InputStreamReader(is, Charsets.UTF_8);
                char[] buffer = new char[4096];
                while ((len = reader.read(buffer)) != -1) {
                    sb.append(buffer, 0, len);
                }
            }
            catch (IOException e) {
                try {
                    IC2.log.warn(LogCategory.General, e, "Can't load loot table %s.", event.getName().func_110623_a());
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)reader);
                return;
            }
            IOUtils.closeQuietly((Reader)reader);
            if (gson == null) {
                gson = (Gson)ReflectionUtil.getFieldValue(ReflectionUtil.getField(LootTableManager.class, Gson.class), null);
            }
            if ((table = ForgeHooks.loadLootTable((Gson)gson, (ResourceLocation)new ResourceLocation("ic2", event.getName().func_110623_a()), (String)sb.toString(), (boolean)false)) == null) {
                return;
            }
            LootPool pool = table.getPool("ic2");
            if (pool == null) {
                return;
            }
            event.getTable().addPool(pool);
        }
        catch (Throwable t) {
            IC2.log.warn(LogCategory.General, t, "Error loading loot table %s.", event.getName().func_110623_a());
        }
    }
}

