/*
 * Decompiled with CFR 0.152.
 */
package com.pam.harvestcraft.loottables;

import com.pam.harvestcraft.loottables.CustomLootPool;
import com.pam.harvestcraft.loottables.LootHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.event.LootTableLoadEvent;

public class LootHandler {
    public static final String SEPARATE_LOOT_POOL_ID = "harvestcraft";
    public static final String VANILLA_LOOT_POOL_ID = "main";

    public static void handleLootTableMod(LootTableLoadEvent event) {
        List<CustomLootPool> customLootPools = LootHandler.getCustomLootPools(event.getName());
        for (CustomLootPool customLootPool : customLootPools) {
            String lootPoolId = customLootPool.isSeperateLootPool() ? SEPARATE_LOOT_POOL_ID : VANILLA_LOOT_POOL_ID;
            LootHandler.createPoolIfNotExists(event.getTable(), lootPoolId);
            LootPool lootPool = event.getTable().getPool(lootPoolId);
            for (LootEntryItem entry : customLootPool.getLootEntries()) {
                lootPool.addEntry((LootEntry)entry);
            }
        }
    }

    private static void createPoolIfNotExists(LootTable lootTable, String poolId) {
        if (poolId.equals(VANILLA_LOOT_POOL_ID) || lootTable.getPool(poolId) != null) {
            return;
        }
        lootTable.addPool(new LootPool(new LootEntry[0], new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(0.0f), poolId));
    }

    private static List<CustomLootPool> getCustomLootPools(ResourceLocation resourceLocation) {
        ArrayList<CustomLootPool> results = new ArrayList<CustomLootPool>();
        if (resourceLocation == null) {
            return results;
        }
        for (CustomLootPool customLootPool : LootHelper.additionalLootPools) {
            if (!customLootPool.getResourceLocation().equals((Object)resourceLocation)) continue;
            results.add(customLootPool);
        }
        return results;
    }
}

