/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.integration.minetweaker;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.storagedrawers.OreDictionaryBlacklist")
public class OreDictionaryBlacklist {
    @ZenMethod
    public static void add(String name) {
        if (name != null && name.length() > 0) {
            MineTweakerAPI.apply((IUndoableAction)new AddNameAction(name));
        } else {
            MineTweakerAPI.logError((String)"Tried to add empty ore dictionary name to drawer conversion blacklist.");
        }
    }

    @ZenMethod
    public static void addPrefix(String prefix) {
        if (prefix != null && prefix.length() > 0) {
            MineTweakerAPI.apply((IUndoableAction)new AddPrefixAction(prefix));
        } else {
            MineTweakerAPI.logError((String)"Tried to add empty ore dictionary prefix to drawer conversion blacklist.");
        }
    }

    private static class AddPrefixAction
    implements IUndoableAction {
        String name;
        boolean added;

        public AddPrefixAction(String name) {
            this.name = name;
        }

        public void apply() {
            this.added = StorageDrawers.oreDictRegistry.addBlacklistPrefix(this.name);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            if (this.added) {
                StorageDrawers.oreDictRegistry.removeBlacklistPrefix(this.name);
            }
        }

        public String describe() {
            if (this.added) {
                return "Adding ore dictionary prefix '" + this.name + "' to drawer conversion blacklist.";
            }
            return "Ore dictionary prefix '" + this.name + "' already registered in drawer conversion blacklist.";
        }

        public String describeUndo() {
            if (this.added) {
                return "Removing previously added ore dictionary prefix '" + this.name + "' from drawer conversion blacklist.";
            }
            return "";
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddNameAction
    implements IUndoableAction {
        String name;
        boolean added;

        public AddNameAction(String name) {
            this.name = name;
        }

        public void apply() {
            this.added = StorageDrawers.oreDictRegistry.addBlacklist(this.name);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            if (this.added) {
                StorageDrawers.oreDictRegistry.removeBlacklist(this.name);
            }
        }

        public String describe() {
            if (this.added) {
                return "Adding ore dictionary key '" + this.name + "' to drawer conversion blacklist.";
            }
            return "Ore dictionary key '" + this.name + "' already registered in drawer conversion blacklist.";
        }

        public String describeUndo() {
            if (this.added) {
                return "Removing previously added ore dictionary key '" + this.name + "' from drawer conversion blacklist.";
            }
            return "";
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

